/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.rpg;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.AbstractRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.StringUtils;
import java.util.StringTokenizer;

public class RPGRecordParser
extends AbstractRecordParser {
    protected boolean isEnd;
    private boolean isPlusContinuation;
    private boolean isMinusContinuation;
    private boolean isEllipsisContinuation;
    private boolean isInLiteral;
    private boolean isInParm;
    protected boolean isInComment;
    private boolean isInStringLiteral;
    private boolean isFreeFormatRPG;
    protected char C_featureState;
    protected char C_specification;
    protected int currentColumn;
    protected String externalFile;
    protected String externalData;
    String externalFileDecl;
    boolean hasExtDescKeyword;
    String extDescFileObject = null;
    String extDescFileLibrary = null;
    boolean hasExtFileKeyword = false;
    boolean hasDeviceExtKeyword;
    boolean isDclfExternal = true;
    String externalDataDecl;
    boolean hasExtNameKeyword = false;
    String extNameDataObject = null;
    String extNameDataLibrary = null;
    boolean isDcldsExternal = false;
    protected String currentToken;
    protected boolean hasSequenceNumber = false;
    protected boolean isStatementBeginning;
    static final String DCL_F = "dcl-f";
    static final String DCL_DS = "dcl-ds";
    static final String DISK = "DISK";
    static final String PRINTER = "PRINTER";
    static final String SEQ = "SEQ";
    static final String WORKSTN = "WORKSTN";
    static final String SPECIAL = "SPECIAL";
    static final String EXTDESC = "EXTDESC";
    static final String EXTFILE = "EXTFILE";
    static final String STAR_EXT = "*EXT";
    static final String EXT = "EXT";
    static final String EXTNAME = "EXTNAME";
    static final String LIBL = "*LIBL";
    static final String SLASH = "/";

    @Override
    protected void processOneRecord(int recordCount, String iRecord, String baseLanguage) {
        if (!this.continueScanning(iRecord = this.skipSequenceNumber(iRecord))) {
            return;
        }
        int indexOfComment = iRecord.indexOf("//");
        if (indexOfComment >= 7 && iRecord.substring(5, indexOfComment).trim().length() == 0) {
            return;
        }
        if (this.CheckCopyOrInclude(iRecord)) {
            return;
        }
        this.C_specification = Character.toUpperCase(iRecord.charAt(5));
        switch (this.C_specification) {
            case 'H': 
            case 'I': 
            case 'O': 
            case 'P': {
                this.currentColumn = 79;
                break;
            }
            case 'F': {
                if (iRecord.length() >= 22 && iRecord.substring(21, 22).equalsIgnoreCase("e")) {
                    if (this.externalFile != null) {
                        this.metaData.addInclude(64, this.externalFile);
                    }
                    this.externalFile = this.getExternalFileName(iRecord);
                }
                if (this.externalFile == null) break;
                if (iRecord.length() > 44) {
                    this.currentColumn = 43;
                    break;
                }
                this.currentColumn = 79;
                break;
            }
            case 'D': {
                if (iRecord.length() >= 25 && iRecord.substring(23, 25).equalsIgnoreCase("DS") && iRecord.substring(21, 22).equalsIgnoreCase("e")) {
                    if (this.externalData != null) {
                        this.metaData.addInclude(65, this.externalData);
                        this.externalData = null;
                    }
                    this.externalData = this.getExternalFileName(iRecord);
                }
                if (this.externalData == null) break;
                if (iRecord.length() > 44) {
                    this.currentColumn = 43;
                    break;
                }
                this.currentColumn = 79;
                break;
            }
            case ' ': 
            case 'C': {
                StringTokenizer tokens;
                this.currentColumn = 7;
                if (iRecord.length() >= 15 && iRecord.substring(6, 15).equalsIgnoreCase("/EXEC SQL")) {
                    this.C_featureState = (char)83;
                    this.currentColumn = 15;
                } else if ((this.C_featureState == 'S' || this.C_featureState == 'I') && iRecord.length() >= 15 && iRecord.substring(6, 15).equalsIgnoreCase("/END-EXEC")) {
                    this.C_featureState = (char)85;
                    this.currentColumn = 79;
                    this.isInComment = false;
                    this.isInStringLiteral = false;
                } else if (iRecord.length() >= 11 && iRecord.substring(6, 11).equalsIgnoreCase("/FREE")) {
                    this.isFreeFormatRPG = true;
                    this.isStatementBeginning = true;
                    this.currentColumn = 79;
                } else if (iRecord.length() >= 15 && iRecord.substring(6, 15).equalsIgnoreCase("/END-FREE")) {
                    this.isFreeFormatRPG = false;
                    this.currentColumn = 79;
                    this.isInComment = false;
                    this.isInStringLiteral = false;
                    this.isStatementBeginning = true;
                } else if ((this.C_featureState == 'S' || this.C_featureState == 'I') && iRecord.charAt(6) == '+') {
                    this.isPlusContinuation = true;
                } else if (this.checkNewFreeFormat(iRecord)) {
                    this.isFreeFormatRPG = true;
                }
                if (!this.isFreeFormatRPG || !(tokens = new StringTokenizer(iRecord.substring(6))).hasMoreTokens()) break;
                String first = tokens.nextToken();
                if (first.equalsIgnoreCase("EXEC")) {
                    String second;
                    if (!tokens.hasMoreTokens() || !(second = tokens.nextToken()).equalsIgnoreCase("SQL") || this.isInStringLiteral || this.isInComment) break;
                    this.C_featureState = (char)83;
                    this.currentColumn = iRecord.indexOf(second) + 3;
                    break;
                }
                if (first.equalsIgnoreCase(DCL_F)) {
                    this.C_featureState = (char)71;
                    this.isStatementBeginning = true;
                    this.currentColumn = iRecord.indexOf(first) + 5;
                    break;
                }
                if (!first.equalsIgnoreCase(DCL_DS)) break;
                this.C_featureState = (char)69;
                this.isStatementBeginning = true;
                this.currentColumn = iRecord.indexOf(first) + 6;
                break;
            }
        }
        if (this.currentColumn > iRecord.length() - 1) {
            return;
        }
        String newRecord = iRecord.substring(this.currentColumn).trim();
        if (this.isFreeFormatRPG) {
            this.processFreeFormatStatement(iRecord, newRecord);
        } else if (this.C_featureState == 'S' || this.C_featureState == 'I') {
            this.processFixFormatSQLInclude(iRecord, newRecord);
        } else if (this.externalFile != null || this.externalData != null) {
            this.processKeywordParameters(iRecord, newRecord);
        }
    }

    protected boolean continueScanning(String iRecord) {
        if (this.isEnd) {
            return false;
        }
        if (iRecord.length() >= 2 && iRecord.substring(0, 2).equals("**")) {
            this.isEnd = true;
            return false;
        }
        return iRecord.length() >= 7 && iRecord.charAt(6) != '*';
    }

    protected String skipSequenceNumber(String iRecord) {
        if (this.hasSequenceNumber && iRecord.length() > 12) {
            iRecord = iRecord.substring(12);
        }
        if (iRecord.length() > 80) {
            iRecord = iRecord.substring(0, 80);
        }
        return iRecord;
    }

    private void processKeywordParameters(String iRecord, String newRecord) {
        if (this.isPlusContinuation || this.isEllipsisContinuation) {
            while (newRecord.length() != 0 && (newRecord.startsWith(" ") || newRecord.startsWith("\t"))) {
                newRecord = newRecord.substring(1);
            }
        }
        int previousChar = 32;
        int previousPreviousChar = 32;
        int charToSkip = 0;
        while (newRecord != null && !newRecord.startsWith("\n") && newRecord.length() > 0) {
            char currentChar = newRecord.charAt(0);
            if (!this.isInLiteral) {
                if (!this.isInParm) {
                    if (currentChar == '(') {
                        this.completeKeywordToken(this.currentToken.trim());
                        this.currentToken = "";
                        this.isInParm = true;
                    } else {
                        this.currentToken = String.valueOf(this.currentToken) + currentChar;
                    }
                } else if (currentChar == ')') {
                    this.completeParamTokens(this.currentToken.trim());
                    this.currentToken = "";
                    this.isInParm = false;
                } else if (newRecord.length() == 1 && previousPreviousChar == 46 && previousChar == 46 && currentChar == '.') {
                    this.isEllipsisContinuation = true;
                    this.currentToken = this.currentToken.substring(0, this.currentToken.length() - 2);
                } else {
                    if (currentChar == '\'') {
                        this.isInLiteral = true;
                    }
                    this.currentToken = String.valueOf(this.currentToken) + currentChar;
                }
            } else if (newRecord.length() == 1 && currentChar == '+') {
                this.isPlusContinuation = true;
                this.isMinusContinuation = false;
            } else if (newRecord.length() == 1 && currentChar == '-') {
                this.isPlusContinuation = false;
                this.isMinusContinuation = true;
            } else if (currentChar == '\'') {
                if (newRecord.length() > 1 && newRecord.charAt(1) == '\'') {
                    charToSkip = 1;
                    this.currentToken = String.valueOf(this.currentToken) + "''";
                } else {
                    this.isInLiteral = false;
                    this.currentToken = String.valueOf(this.currentToken) + currentChar;
                }
            } else {
                this.currentToken = String.valueOf(this.currentToken) + currentChar;
            }
            previousPreviousChar = previousChar;
            previousChar = currentChar;
            newRecord = newRecord.substring(1 + charToSkip);
            charToSkip = 0;
        }
    }

    private void processFreeFormatStatement(String iRecord, String newRecord) {
        char currentChar = ' ';
        char previousChar = ' ';
        int charToSkip = 0;
        boolean skipWhitespace = true;
        while (!newRecord.startsWith("\n") && newRecord.length() > 0) {
            currentChar = newRecord.charAt(0);
            if (this.isInStringLiteral) {
                if (currentChar == '\'') {
                    if (newRecord.length() > 1 && newRecord.charAt(1) == '\'') {
                        charToSkip = 1;
                        if (this.C_featureState == 'I' || this.C_featureState == 'G' || this.C_featureState == 'E') {
                            this.currentToken = String.valueOf(this.currentToken) + "''";
                        }
                    } else {
                        this.isInStringLiteral = false;
                        if (this.C_featureState == 'I') {
                            this.completeSQLIncludeTokens(String.valueOf(this.currentToken) + currentChar);
                            this.currentToken = "";
                        } else if (this.C_featureState == 'G' || this.C_featureState == 'E') {
                            this.currentToken = String.valueOf(this.currentToken) + "'";
                        }
                    }
                } else if (this.C_featureState == 'I' || this.C_featureState == 'G' || this.C_featureState == 'E') {
                    this.currentToken = String.valueOf(this.currentToken) + currentChar;
                }
            } else if (this.isInComment) {
                if (previousChar == '*' && currentChar == '/') {
                    this.isInComment = false;
                }
            } else {
                if (this.C_featureState == 'S' || this.C_featureState == 'I') {
                    if (previousChar == '/' && currentChar == '/' || currentChar == '-' && previousChar == '-') {
                        this.completeSQLIncludeTokens(this.currentToken.substring(0, this.currentToken.length() - 1));
                        this.currentToken = "";
                        break;
                    }
                    if (previousChar == '/' && currentChar == '*') {
                        this.isInComment = true;
                        this.completeSQLIncludeTokens(this.currentToken.substring(0, this.currentToken.length() - 1));
                        this.currentToken = "";
                    } else {
                        this.currentToken = String.valueOf(this.currentToken) + currentChar;
                    }
                }
                if (previousChar == '/' && currentChar == '/') break;
                if (currentChar == '\'') {
                    this.isInStringLiteral = true;
                }
                if (currentChar == ';') {
                    if (this.C_featureState == 'G') {
                        if (this.currentToken.length() > 0) {
                            this.completeDclfToken(this.currentToken);
                        }
                        this.completeDclfStatement();
                        this.currentToken = "";
                    } else if (this.C_featureState == 'E') {
                        if (this.currentToken.length() > 0) {
                            this.completeDcldsToken(this.currentToken);
                        }
                        this.completeDcldsStatement();
                        this.currentToken = "";
                    }
                    this.isStatementBeginning = true;
                    break;
                }
                this.isStatementBeginning = false;
                if (this.C_featureState == 'G' || this.C_featureState == 'E') {
                    if (currentChar == ' ') {
                        if (!skipWhitespace) {
                            if (this.C_featureState == 'G') {
                                this.completeDclfToken(this.currentToken);
                            } else {
                                this.completeDcldsToken(this.currentToken);
                            }
                            this.currentToken = "";
                            skipWhitespace = true;
                        }
                    } else {
                        skipWhitespace = false;
                        this.currentToken = String.valueOf(this.currentToken) + currentChar;
                    }
                }
            }
            previousChar = currentChar;
            newRecord = newRecord.substring(1 + charToSkip);
            charToSkip = 0;
        }
        if (this.currentToken.length() > 0) {
            if (this.C_featureState == 'S' || this.C_featureState == 'I') {
                this.completeSQLIncludeTokens(this.currentToken);
                this.currentToken = "";
            } else if (this.isInStringLiteral && this.currentToken.charAt(this.currentToken.length() - 1) == '+') {
                this.currentToken = this.currentToken.substring(0, this.currentToken.length() - 1);
            } else if (this.C_featureState == 'E') {
                this.completeDcldsToken(this.currentToken);
                this.currentToken = "";
            } else if (this.C_featureState == 'G') {
                this.completeDclfToken(this.currentToken);
                this.currentToken = "";
            }
        }
    }

    protected boolean checkNewFreeFormat(String iRecord) {
        return iRecord.charAt(5) == ' ' && iRecord.charAt(6) == ' ' && iRecord.substring(7).trim().length() != 0;
    }

    protected void processFixFormatSQLInclude(String iRecord, String newRecord) {
        int previousChar = 32;
        while (!newRecord.startsWith("\n") && newRecord.length() > 0) {
            char currentChar = newRecord.charAt(0);
            if (!this.isInComment) {
                if (currentChar == '-' && previousChar == 45) {
                    if (this.currentToken.length() > 2) {
                        this.completeSQLIncludeTokens(this.currentToken.substring(0, this.currentToken.length() - 1));
                    }
                    this.currentToken = "";
                    break;
                }
                if (currentChar == '*' && previousChar == 47) {
                    this.isInComment = true;
                    if (this.currentToken.length() > 2) {
                        this.completeSQLIncludeTokens(this.currentToken.substring(0, this.currentToken.length() - 1));
                    }
                    this.currentToken = "";
                } else {
                    this.currentToken = String.valueOf(this.currentToken) + currentChar;
                }
            } else if (currentChar == '/' && previousChar == 42) {
                this.isInComment = false;
            }
            previousChar = currentChar;
            newRecord = newRecord.substring(1);
        }
        if (this.currentToken.trim().length() > 0) {
            this.completeSQLIncludeTokens(this.currentToken);
            this.currentToken = "";
        }
    }

    protected void completeSQLIncludeTokens(String currentToken) {
        this.completeSQLIncludeTokens(currentToken, 66);
    }

    protected void completeSQLIncludeTokens(String currentToken, int typeId) {
        StringTokenizer tokens = new StringTokenizer(currentToken, " ;");
        if (tokens.hasMoreTokens()) {
            String first = tokens.nextToken();
            if (this.C_featureState == 'S') {
                if (first.equalsIgnoreCase("INCLUDE")) {
                    this.C_featureState = (char)73;
                    if (tokens.hasMoreTokens()) {
                        this.metaData.addInclude(typeId, tokens.nextToken());
                        this.C_featureState = (char)85;
                    }
                } else {
                    this.C_featureState = (char)85;
                }
            } else if (this.C_featureState == 'I') {
                if (!first.equalsIgnoreCase("SQLDA")) {
                    this.metaData.addInclude(typeId, first);
                }
                this.C_featureState = (char)85;
            }
        }
    }

    protected void completeDclfStatement() {
        if (this.externalFileDecl != null && this.isDclfExternal) {
            if (!this.hasExtDescKeyword) {
                this.metaData.addInclude(64, this.externalFileDecl);
            } else if (this.extDescFileObject != null) {
                if (this.extDescFileLibrary == null) {
                    this.metaData.addInclude(64, this.extDescFileObject);
                } else {
                    this.metaData.addInclude(64, String.valueOf(this.extDescFileLibrary) + SLASH + this.extDescFileObject);
                }
            }
        }
        this.externalFileDecl = null;
        this.extDescFileObject = null;
        this.extDescFileLibrary = null;
        this.hasExtDescKeyword = false;
        this.hasExtFileKeyword = false;
        this.isDclfExternal = true;
        this.C_featureState = (char)85;
    }

    protected void completeDclfToken(String token) {
        boolean isDeviceTypeExternalDef = false;
        if (!this.isDclfExternal) {
            return;
        }
        int tokenLength = 0;
        if (token != null) {
            tokenLength = token.length();
        }
        if (this.externalFileDecl == null) {
            this.externalFileDecl = new String(token);
        } else if (tokenLength >= DISK.length() && token.substring(0, DISK.length()).equalsIgnoreCase(DISK)) {
            isDeviceTypeExternalDef = this.checkDeviceParm(token, DISK.length());
            if (!isDeviceTypeExternalDef) {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= SEQ.length() && token.substring(0, SEQ.length()).equalsIgnoreCase(SEQ)) {
            isDeviceTypeExternalDef = this.checkDeviceParm(token, SEQ.length());
            if (!isDeviceTypeExternalDef) {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= WORKSTN.length() && token.substring(0, WORKSTN.length()).equalsIgnoreCase(WORKSTN)) {
            isDeviceTypeExternalDef = this.checkDeviceParm(token, WORKSTN.length());
            if (!isDeviceTypeExternalDef) {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= PRINTER.length() && token.substring(0, PRINTER.length()).equalsIgnoreCase(PRINTER)) {
            isDeviceTypeExternalDef = this.checkDeviceParm(token, PRINTER.length());
            if (!isDeviceTypeExternalDef) {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= SPECIAL.length() && token.substring(0, SPECIAL.length()).equalsIgnoreCase(SPECIAL)) {
            isDeviceTypeExternalDef = this.checkDeviceParm(token, SPECIAL.length());
            if (!isDeviceTypeExternalDef) {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= EXTDESC.length() && token.substring(0, EXTDESC.length()).equalsIgnoreCase(EXTDESC)) {
            String tmpExtDescValue = token.substring(EXTDESC.length() + 1, token.length() - 1);
            this.hasExtDescKeyword = true;
            if (tmpExtDescValue.substring(0, 1).equals("'")) {
                QualifiedObjectName qualifiedExtFile = this.getQuotedValue(tmpExtDescValue);
                this.extDescFileObject = qualifiedExtFile.objectName();
                this.extDescFileLibrary = qualifiedExtFile.libraryName();
            } else {
                this.isDclfExternal = false;
            }
        } else if (tokenLength >= EXTFILE.length() && token.substring(0, EXTFILE.length()).equalsIgnoreCase(EXTFILE)) {
            this.hasExtFileKeyword = true;
        }
    }

    private QualifiedObjectName getQuotedValue(String quotedName) {
        String unquotedName = quotedName.substring(1, quotedName.length() - 1);
        if (!unquotedName.contains(SLASH)) {
            return new QualifiedObjectName(unquotedName);
        }
        String[] libAndObject = unquotedName.split(SLASH);
        QualifiedObjectName result = new QualifiedObjectName(libAndObject[0], libAndObject[1]);
        return result;
    }

    private boolean checkDeviceParm(String token, int keywordLength) {
        if (token.length() != keywordLength) {
            if (token.length() < keywordLength + 2 + STAR_EXT.length()) {
                return false;
            }
            return token.substring(keywordLength + 1, token.length() - 1).equalsIgnoreCase(STAR_EXT);
        }
        return true;
    }

    protected void completeDcldsStatement() {
        if (this.externalDataDecl != null && this.isDcldsExternal) {
            if (!this.hasExtNameKeyword) {
                this.metaData.addInclude(65, this.externalDataDecl);
                this.externalData = null;
            } else if (this.extNameDataObject != null) {
                if (this.extNameDataLibrary == null) {
                    this.metaData.addInclude(65, this.extNameDataObject);
                } else {
                    this.metaData.addInclude(65, String.valueOf(this.extNameDataLibrary) + SLASH + this.extNameDataObject);
                }
            }
        }
        this.externalDataDecl = null;
        this.extNameDataObject = null;
        this.extNameDataLibrary = null;
        this.hasExtNameKeyword = false;
        this.isDcldsExternal = false;
        this.C_featureState = (char)85;
    }

    protected void completeDcldsToken(String token) {
        int tokenLength = 0;
        if (token != null) {
            tokenLength = token.length();
        }
        if (this.externalDataDecl == null) {
            this.externalDataDecl = new String(token);
        } else if (tokenLength >= EXTNAME.length() && token.substring(0, EXTNAME.length()).equalsIgnoreCase(EXTNAME)) {
            String tmpExtNameValue = token.substring(EXTNAME.length() + 1, token.length() - 1);
            this.hasExtNameKeyword = true;
            if (tmpExtNameValue.substring(0, 1).equals("'")) {
                QualifiedObjectName qualifiedExtName = this.getQuotedValue(tmpExtNameValue);
                this.extNameDataObject = qualifiedExtName.objectName();
                this.extNameDataLibrary = qualifiedExtName.libraryName();
                this.isDcldsExternal = true;
            } else {
                this.isDcldsExternal = false;
            }
        } else if (tokenLength >= EXT.length() && token.substring(0, EXT.length()).equalsIgnoreCase(EXT)) {
            this.isDcldsExternal = true;
        }
    }

    private void completeParamTokens(String currentToken) {
        StringTokenizer tokens = new StringTokenizer(currentToken, " :");
        if (tokens.hasMoreTokens()) {
            String first = tokens.nextToken();
            if (this.C_featureState == 'F') {
                if (first.startsWith("'") && first.endsWith("'") && (first = first.substring(1, first.length() - 1)).indexOf(" ") < 0) {
                    this.metaData.addInclude(64, first);
                    this.externalFile = null;
                }
            } else if (this.C_featureState == 'D' && (first = first.startsWith("'") && first.endsWith("'") ? first.substring(1, first.length() - 1) : first.toUpperCase()).indexOf(" ") < 0) {
                this.metaData.addInclude(65, first);
                this.externalData = null;
            }
            this.C_featureState = (char)85;
        }
    }

    private void completeKeywordToken(String currentToken) {
        StringTokenizer tokens = new StringTokenizer(currentToken, " :");
        if (tokens.hasMoreTokens()) {
            String first = tokens.nextToken();
            this.C_featureState = this.externalFile != null && first.equalsIgnoreCase(EXTDESC) ? (char)70 : (this.externalData != null && first.equalsIgnoreCase(EXTNAME) ? (char)68 : (char)85);
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        if (this.externalFile != null) {
            this.metaData.addInclude(64, this.externalFile);
            this.externalFile = null;
        }
        if (this.externalData != null) {
            this.metaData.addInclude(65, this.externalData);
            this.externalData = null;
        }
        return this.metaData;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.metaData = new ClassifierMetaData();
        this.isPlusContinuation = false;
        this.isMinusContinuation = false;
        this.isEllipsisContinuation = false;
        this.C_featureState = (char)85;
        this.currentColumn = 0;
        this.currentToken = "";
        this.isFreeFormatRPG = false;
        this.isStatementBeginning = false;
    }

    private boolean CheckCopyOrInclude(String inrec) {
        String first;
        StringTokenizer tokens = new StringTokenizer(inrec = inrec.substring(6));
        if (tokens.hasMoreTokens() && ((first = tokens.nextToken()).equalsIgnoreCase("/COPY") || first.equalsIgnoreCase("/INCLUDE")) && (inrec.startsWith(first) || !inrec.startsWith(first) && !this.isInStringLiteral && !this.isInComment && this.isStatementBeginning) && tokens.hasMoreTokens()) {
            String second = tokens.nextToken();
            int indexOfSecondToken = inrec.indexOf(second);
            if (second.endsWith(";")) {
                second = second.substring(0, second.length() - 1);
            }
            if (first.equalsIgnoreCase("/COPY") && inrec.indexOf(first) == indexOfSecondToken - 6 || first.equalsIgnoreCase("/INCLUDE") && inrec.indexOf(first) == indexOfSecondToken - 9) {
                return this.parsingCopyValue(inrec, second, indexOfSecondToken);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parsingCopyValue(String inrec, String second, int indexOfSecondToken) {
        String firstQuote = second.substring(0, 1);
        if (firstQuote.equals("'")) {
            int indexOflastQuote = inrec.lastIndexOf(firstQuote);
            if (indexOflastQuote <= indexOfSecondToken) return false;
            String qutoedStr = inrec.substring(indexOfSecondToken, indexOflastQuote + 1);
            this.addCopyMetadata(qutoedStr);
            return true;
        }
        if (firstQuote.equals("\"")) {
            StringTokenizer subtokens = new StringTokenizer(second, "/,");
            boolean isValidToken = true;
            while (subtokens.hasMoreTokens()) {
                isValidToken = this.isValidString(subtokens.nextToken());
                if (!isValidToken) break;
            }
            if (!isValidToken) {
                String qutoedStr = inrec.substring(indexOfSecondToken, inrec.lastIndexOf("\"") + 1);
                if (!this.isValidString(qutoedStr)) return false;
                this.addCopyMetadata(qutoedStr);
                return true;
            }
            this.addCopyMetadata(second);
            return true;
        }
        this.addCopyMetadata(second);
        return true;
    }

    protected void addCopyMetadata(String metadataStr) {
        this.metaData.addInclude(63, metadataStr);
    }

    private boolean isContinuation() {
        return this.isMinusContinuation || this.isPlusContinuation || this.isEllipsisContinuation;
    }

    private String getExternalFileName(String iRecord) {
        String fileName = StringUtils.strip(iRecord.substring(6, 16));
        if (fileName.length() > 0) {
            this.isInParm = false;
            this.isInLiteral = false;
            this.isPlusContinuation = false;
            this.isMinusContinuation = false;
            this.isEllipsisContinuation = false;
            return fileName.toUpperCase();
        }
        return null;
    }

    @Override
    public boolean init() {
        return true;
    }

    public void setHasSequenceNumber(boolean hasSequenceNumber) {
        this.hasSequenceNumber = hasSequenceNumber;
    }

    private boolean isValidString(String str) {
        if (str != null) {
            int firstIndex = str.indexOf("\"");
            int lastIndex = str.lastIndexOf("\"");
            if (firstIndex == 0 && lastIndex > 0 && lastIndex == str.length() - 1 && str.substring(1, lastIndex).indexOf("\"") < 0 && str.substring(1, lastIndex).indexOf("'") < 0) {
                return true;
            }
        }
        return false;
    }

    private class QualifiedObjectName {
        String fLibraryName;
        String fObjectName;

        QualifiedObjectName() {
            this.fLibraryName = null;
            this.fObjectName = null;
        }

        QualifiedObjectName(String objectName) {
            this.fLibraryName = RPGRecordParser.LIBL;
            this.fObjectName = objectName;
        }

        QualifiedObjectName(String libraryName, String objectName) {
            this.fLibraryName = libraryName;
            this.fObjectName = objectName;
        }

        String objectName() {
            return this.fObjectName;
        }

        String libraryName() {
            return this.fLibraryName;
        }
    }
}

