/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.rpg;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.rpg.RPGRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.StringUtils;
import java.util.StringTokenizer;

public class OPMRPGRecordParser
extends RPGRecordParser {
    @Override
    protected void processOneRecord(int recordCount, String iRecord, String baseLanguage) {
        if (!this.continueScanning(iRecord = this.skipSequenceNumber(iRecord))) {
            return;
        }
        if (this.CheckCopy(iRecord)) {
            return;
        }
        this.C_specification = Character.toUpperCase(iRecord.charAt(5));
        switch (this.C_specification) {
            case 'F': {
                this.getExternalFileName(iRecord);
                return;
            }
            case 'I': {
                this.getExternalDS(iRecord);
                return;
            }
            case 'C': {
                this.currentColumn = 7;
                if (iRecord.length() >= 15 && iRecord.substring(6, 15).equalsIgnoreCase("/EXEC SQL")) {
                    this.C_featureState = (char)83;
                    this.currentColumn = 15;
                } else if ((this.C_featureState == 'S' || this.C_featureState == 'I') && iRecord.length() >= 15 && iRecord.substring(6, 15).equalsIgnoreCase("/END-EXEC")) {
                    this.C_featureState = (char)85;
                    this.currentColumn = 79;
                    this.isInComment = false;
                }
                if (this.currentColumn > iRecord.length() - 1) break;
                String newRecord = iRecord.substring(this.currentColumn).trim();
                if (this.C_featureState != 'S' && this.C_featureState != 'I') break;
                this.processFixFormatSQLInclude(iRecord, newRecord);
                break;
            }
        }
    }

    @Override
    protected boolean continueScanning(String iRecord) {
        if (iRecord.trim().length() <= 0) {
            return false;
        }
        if (this.isEnd) {
            return false;
        }
        if (iRecord.substring(0, 2).equals("**")) {
            this.isEnd = true;
            return false;
        }
        return iRecord.length() >= 7 && iRecord.charAt(6) != '*';
    }

    @Override
    protected String skipSequenceNumber(String iRecord) {
        if (this.hasSequenceNumber && iRecord.length() > 12) {
            iRecord = iRecord.substring(12);
        }
        if (iRecord.length() > 80) {
            iRecord = iRecord.substring(0, 80);
        }
        return iRecord;
    }

    private void getExternalFileName(String iRecord) {
        String fileName;
        char external;
        if (iRecord.length() >= 19 && ((external = iRecord.charAt(18)) == 'e' || external == 'E') && (fileName = StringUtils.strip(iRecord.substring(6, 14))).length() > 0) {
            this.metaData.addInclude(64, fileName);
        }
    }

    @Override
    protected void completeSQLIncludeTokens(String currentToken) {
        this.completeSQLIncludeTokens(currentToken, 68);
    }

    private void getExternalDS(String iRecord) {
        String fileName;
        char external;
        if (iRecord.length() >= 20 && iRecord.substring(18, 20).equalsIgnoreCase("DS") && ((external = iRecord.charAt(16)) == 'e' || external == 'E') && (fileName = StringUtils.strip(iRecord.substring(6, 14))).length() > 0) {
            String extFile = null;
            if (iRecord.length() > 20) {
                extFile = iRecord.length() > 28 ? iRecord.substring(20, 28).trim() : iRecord.substring(20).trim();
            }
            if (extFile != null && extFile.length() > 0) {
                fileName = extFile;
            }
            this.metaData.addInclude(65, fileName);
        }
    }

    @Override
    protected void addCopyMetadata(String metadataStr) {
        this.metaData.addInclude(67, metadataStr);
    }

    private boolean CheckCopy(String inrec) {
        String first;
        StringTokenizer tokens = new StringTokenizer(inrec = inrec.substring(6));
        if (tokens.hasMoreTokens() && (first = tokens.nextToken()).equalsIgnoreCase("/COPY") && inrec.startsWith(first) && tokens.hasMoreTokens()) {
            String second = tokens.nextToken();
            int indexOfSecondToken = inrec.indexOf(second);
            if (second.endsWith(";")) {
                second = second.substring(0, second.length() - 1);
            }
            if (first.equalsIgnoreCase("/COPY") && inrec.indexOf(first) == indexOfSecondToken - 6) {
                return this.parsingCopyValue(inrec, second, indexOfSecondToken);
            }
        }
        return false;
    }
}

