/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.dds;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.BaseClassifier;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.DDSClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.PRTFRecordParser;
import java.io.InputStream;

public class PRTFClassifier
extends BaseClassifier {
    static final String version = "V1.0";

    public PRTFClassifier() {
        this.setVersion(version);
        this.setLanguageRecordParser(new PRTFRecordParser());
    }

    public PRTFClassifier(InputStream fileContent, boolean hasSequenceNumber) {
        this.setVersion(version);
        PRTFRecordParser recordParser = new PRTFRecordParser();
        recordParser.setHasSequenceNumber(hasSequenceNumber);
        this.setLanguageRecordParser(recordParser);
    }

    @Override
    public void init(String iOutputFormat, boolean debug) {
        super.init(iOutputFormat, debug);
        this.getLanguageRecordParser().init();
    }

    @Override
    protected String getMemberRecordString() {
        return "PRTF";
    }

    @Override
    public String getLanguageCd() {
        return "PRTF";
    }

    @Override
    protected IClassifierMetaDataHelper getClassifierMetaDataHelper(String outputFormat) {
        return new DDSClassifierMetaDataHelper(outputFormat);
    }
}

