/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.dds;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.BaseClassifier;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.DDSClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.LFRecordParser;
import java.io.InputStream;

public class LFClassifier
extends BaseClassifier {
    static final String version = "V1.0";

    public LFClassifier() {
        this.setVersion(version);
        this.setLanguageRecordParser(new LFRecordParser());
    }

    public LFClassifier(InputStream fileContent, boolean hasSequenceNumber) {
        this.setVersion(version);
        LFRecordParser recordParser = new LFRecordParser();
        recordParser.setHasSequenceNumber(hasSequenceNumber);
        this.setLanguageRecordParser(recordParser);
    }

    @Override
    public void init(String iOutputFormat, boolean debug) {
        super.init(iOutputFormat, debug);
        this.getLanguageRecordParser().init();
    }

    @Override
    protected String getMemberRecordString() {
        return "LF";
    }

    @Override
    public String getLanguageCd() {
        return "LF";
    }

    @Override
    protected IClassifierMetaDataHelper getClassifierMetaDataHelper(String outputFormat) {
        return new DDSClassifierMetaDataHelper(outputFormat);
    }
}

