/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.dds;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.BaseClassifier;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.DDSClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.DSPFRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.dds.LFRecordParser;
import java.io.InputStream;

public class DSPFClassifier
extends BaseClassifier {
    static final String version = "V1.0";

    public DSPFClassifier() {
        this.setVersion(version);
        this.setLanguageRecordParser(new LFRecordParser());
    }

    public DSPFClassifier(InputStream fileContent, boolean hasSequenceNumber) {
        this.setVersion(version);
        DSPFRecordParser recordParser = new DSPFRecordParser();
        recordParser.setHasSequenceNumber(hasSequenceNumber);
        this.setLanguageRecordParser(recordParser);
    }

    @Override
    public void init(String iOutputFormat, boolean debug) {
        super.init(iOutputFormat, debug);
        this.getLanguageRecordParser().init();
    }

    @Override
    protected String getMemberRecordString() {
        return "DSPF";
    }

    @Override
    public String getLanguageCd() {
        return "DSPF";
    }

    @Override
    protected IClassifierMetaDataHelper getClassifierMetaDataHelper(String outputFormat) {
        return new DDSClassifierMetaDataHelper(outputFormat);
    }
}

