/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.dds;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.AbstractRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractDDSRecordParser
extends AbstractRecordParser {
    protected boolean isEnd;
    protected boolean hasSequenceNumber = false;
    protected char C_specification;
    protected char D_type;
    protected char IO_usage;
    protected String recordFormatName;
    protected String fieldName;
    protected String keyFieldName;
    protected boolean isReferenceField;
    protected int fieldLength;
    protected int decimalPlaces;
    protected boolean isPlusContinuation;
    protected boolean isMinusContinuation;
    protected boolean isKeywordEnd;
    protected boolean keywordFound;
    protected List<String> referenceFiles = new ArrayList<String>();
    protected String currentParmValue = "";

    protected abstract void processKeywords(String var1);

    protected abstract int getTypeId();

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.metaData = new ClassifierMetaData();
        this.isPlusContinuation = false;
        this.isMinusContinuation = false;
        this.currentParmValue = "";
        this.isKeywordEnd = false;
        this.keywordFound = false;
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguage) {
        if (!this.continueScanning(iRecord = this.skipSequenceNumber(iRecord))) {
            return;
        }
        if (iRecord.length() >= 1 && iRecord.charAt(0) == '*') {
            return;
        }
        this.processPositionalEntries(iRecord);
        this.processKeywords(iRecord);
    }

    public void setHasSequenceNumber(boolean hasSequenceNumber) {
        this.hasSequenceNumber = hasSequenceNumber;
    }

    protected String skipSequenceNumber(String iRecord) {
        if (this.hasSequenceNumber && iRecord.length() > 12) {
            iRecord = iRecord.substring(12);
        }
        if (iRecord.length() > 6) {
            iRecord = iRecord.substring(6);
        }
        if (iRecord.length() > 80) {
            iRecord = iRecord.substring(0, 80);
        }
        return iRecord;
    }

    protected boolean continueScanning(String iRecord) {
        if (this.isEnd) {
            return false;
        }
        return iRecord.length() >= 7 && iRecord.charAt(6) != '*';
    }

    protected void processPositionalEntries(String iRecord) {
        if (iRecord.length() >= 12) {
            this.C_specification = Character.toUpperCase(iRecord.charAt(11));
            switch (this.C_specification) {
                case 'R': {
                    if (iRecord.length() < 23) break;
                    this.recordFormatName = iRecord.substring(13, 22);
                    break;
                }
                case ' ': {
                    if (iRecord.length() < 23) break;
                    this.fieldName = iRecord.substring(13, 22);
                    break;
                }
                case 'K': {
                    if (iRecord.length() < 23) break;
                    this.keyFieldName = iRecord.substring(13, 22);
                    break;
                }
            }
        }
        if (iRecord.length() >= 24 && Character.toUpperCase(iRecord.charAt(23)) == 'R') {
            this.isReferenceField = true;
        }
        if (iRecord.length() >= 29) {
            String potentialFieldLength = iRecord.substring(24, 28).trim();
            int n = this.fieldLength = potentialFieldLength.equalsIgnoreCase("") ? -1 : this.parseInt(potentialFieldLength);
        }
        if (iRecord.length() >= 30) {
            this.D_type = Character.toUpperCase(iRecord.charAt(29));
        }
        if (iRecord.length() >= 31) {
            int n = this.decimalPlaces = iRecord.substring(30, 31).trim().equalsIgnoreCase("") ? -1 : this.parseInt(iRecord.substring(30, 31).trim());
            if (this.D_type == ' ') {
                this.D_type = this.decimalPlaces == -1 ? (char)65 : (char)80;
            }
        }
        if (iRecord.length() >= 33) {
            this.IO_usage = Character.toUpperCase(iRecord.charAt(32));
            switch (this.IO_usage) {
                case ' ': 
                case 'B': {
                    break;
                }
                case 'I': {
                    break;
                }
            }
        }
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        return this.createMetadata(this.getTypeId());
    }

    protected ClassifierMetaData createMetadata(int typeid) {
        if (this.referenceFiles != null) {
            for (String referenceFile : this.referenceFiles) {
                this.metaData.addInclude(typeid, referenceFile);
            }
            this.referenceFiles.clear();
        }
        return this.metaData;
    }

    protected void processContinuation(String iRecord) {
        char lastChar;
        if (this.keywordFound && (this.isPlusContinuation || this.isMinusContinuation)) {
            String referenceVariable = iRecord.substring(38, iRecord.length());
            this.currentParmValue = this.isPlusContinuation ? String.valueOf(this.currentParmValue) + referenceVariable.trim() : (String.valueOf(this.currentParmValue) + referenceVariable).trim();
            this.currentParmValue = this.currentParmValue.substring(0, this.currentParmValue.length() - 1);
        }
        this.isPlusContinuation = (lastChar = iRecord.trim().charAt(iRecord.trim().length() - 1)) == '+';
        this.isMinusContinuation = lastChar == '-';
        this.isKeywordEnd = lastChar == ')';
    }

    protected void processParameterValues(int skipParm) {
        if (this.currentParmValue.length() > 0 & this.isKeywordEnd) {
            String token;
            this.keywordFound = false;
            StringTokenizer tokenizer = new StringTokenizer(this.currentParmValue, " ", false);
            if (skipParm == 1) {
                tokenizer.nextToken();
            } else if (skipParm == 2 && !this.referenceFiles.contains(token = tokenizer.nextToken())) {
                this.referenceFiles.add(token);
            }
            if (skipParm == 1 || skipParm == 0) {
                while (tokenizer.hasMoreElements()) {
                    token = tokenizer.nextToken();
                    if (this.referenceFiles.contains(token)) continue;
                    this.referenceFiles.add(token);
                }
            }
        }
    }

    protected void initializeParameterValue(String iRecord, int startIndex) {
        this.currentParmValue = iRecord.substring(startIndex, iRecord.length()).trim();
        this.currentParmValue = this.currentParmValue.substring(0, this.currentParmValue.length() - 1);
    }

    private int parseInt(String str) {
        if ((str = str.trim()).length() > 0 && str.charAt(0) == '+') {
            str = str.substring(1);
        }
        return Integer.parseInt(str);
    }
}

