/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol.COBOLClassifier;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol.IBMICOBOLClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol.IBMICOBOLRecordParser;

public class IBMiCOBOLClassifier
extends COBOLClassifier {
    static final String version = "V1.0";
    public static int SEQUENCENUMBERLENGTH = 12;
    private boolean hasSequenceNumber = true;

    public IBMiCOBOLClassifier() {
        this(true);
    }

    public IBMiCOBOLClassifier(boolean hasSequenceNumber) {
        this.setVersion(version);
        this.setLanguageRecordParser(new IBMICOBOLRecordParser());
        this.hasSequenceNumber = hasSequenceNumber;
    }

    @Override
    protected String preprocess(String inrec) {
        if (!this.hasSequenceNumber) {
            return inrec;
        }
        try {
            String processedString = inrec.substring(SEQUENCENUMBERLENGTH);
            return processedString;
        }
        catch (Exception e) {
            return inrec;
        }
    }

    @Override
    protected IClassifierMetaDataHelper getClassifierMetaDataHelper(String outputFormat) {
        return new IBMICOBOLClassifierMetaDataHelper(outputFormat);
    }
}

