/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.cobol.COBOLClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.StringUtils;
import java.util.Map;
import java.util.Set;

public class IBMICOBOLClassifierMetaDataHelper
extends COBOLClassifierMetaDataHelper {
    public IBMICOBOLClassifierMetaDataHelper(String outputFormat) {
        super(outputFormat);
    }

    @Override
    protected String formatJsonINCL(Integer iInclTypeId, String iInclName) {
        StringBuffer metaData = new StringBuffer();
        iInclName = StringUtils.replace(iInclName, "\"", "\\\"");
        switch (iInclTypeId) {
            case 80: {
                metaData.append("\"").append("type").append("\":\"");
                metaData.append("IBM i External File").append("\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"");
                metaData.append("USE").append("\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("*FILE").append("\"");
                break;
            }
            case 3: {
                metaData.append("\"").append("type").append("\":\"COPY\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
                break;
            }
            case 4: {
                metaData.append("\"").append("type").append("\":\"COPY\"");
                String[] tokens = iInclName.split(" DD=");
                metaData.append(", \"").append("name").append("\":\"" + tokens[0] + "\"");
                metaData.append(", \"ddName\":\"" + tokens[1] + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
                break;
            }
            case 5: {
                metaData.append("\"").append("type").append("\":\"++INCLUDE\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
                break;
            }
            case 6: {
                metaData.append("\"").append("type").append("\":\"-INC\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
                break;
            }
            case 7: {
                metaData.append("\"").append("type").append("\":\"SQL INCLUDE\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
                break;
            }
            default: {
                metaData.append("\"").append("type").append("\":\"unknown\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
            }
        }
        return metaData.toString();
    }

    @Override
    protected boolean getCompletJSONString(Map iInclList, boolean firstIncl) {
        for (Map.Entry e : iInclList.entrySet()) {
            Set values = (Set)e.getValue();
            for (Object value : values) {
                Integer inclTypeId = (Integer)e.getKey();
                String inclName = (String)value;
                if (inclTypeId == 3) {
                    inclTypeId = inclTypeId + 1;
                    String includeName = String.valueOf(inclName) + " DD=" + "QCBLLESRC";
                    firstIncl = this.getJSONString(firstIncl, inclTypeId, includeName);
                    includeName = String.valueOf(inclName) + " DD=" + "QLBLSRC";
                    firstIncl = this.getJSONString(firstIncl, inclTypeId, includeName);
                    continue;
                }
                firstIncl = this.getJSONString(firstIncl, inclTypeId, inclName);
            }
        }
        return firstIncl;
    }
}

