/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.cl;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cl.AbstractCLRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cl.CLCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class BaseCLRecordParser
extends AbstractCLRecordParser {
    protected ArrayList<CLCommand> commandList = new ArrayList();
    protected HashMap<String, String> commandNameMap = null;
    protected HashMap<String, String> keywordNameMap = null;
    protected String NO_KEYWORD = "NOKEYWORD";
    protected String currentCommand;
    protected char previousChar;
    protected char previousPreviousChar;
    private boolean isPlusContinuation;
    private boolean isMinusContinuation;
    private boolean isInComment;
    private boolean isInStringLiteral;

    public BaseCLRecordParser(HashMap<String, String> commandMaps) {
        this.commandNameMap = commandMaps;
    }

    public BaseCLRecordParser() {
    }

    @Override
    public void processInitialization() {
        super.processInitialization();
        this.processDeallocate();
        this.metaData = new ClassifierMetaData();
        this.commandList = new ArrayList();
        this.commandNameMap = null;
        this.keywordNameMap = null;
        this.isPlusContinuation = false;
        this.isMinusContinuation = false;
        this.currentCommand = "";
    }

    @Override
    protected void processOneRecord(int iRecordCount, String iRecord, String iBaseLanguage) {
        if ((iRecord = this.skipSequenceNumber(iRecord)).startsWith("/*")) {
            this.isInComment = true;
            iRecord = iRecord.substring(2);
        }
        int charToSkip = 0;
        String currentToken = "";
        iRecord = iRecord.trim();
        boolean addCurrentChar = false;
        while (!iRecord.startsWith("\n") && iRecord.length() > 0) {
            char currentChar = iRecord.charAt(0);
            if (!this.isInStringLiteral) {
                if (!this.isInComment) {
                    if (iRecord.startsWith(" /*") || iRecord.startsWith("/* ") || iRecord.startsWith("/**")) {
                        this.isInComment = true;
                        charToSkip = 2;
                        addCurrentChar = currentChar == ' ';
                    } else {
                        addCurrentChar = true;
                    }
                    if (currentChar == '\'') {
                        this.isInStringLiteral = true;
                        addCurrentChar = true;
                    }
                } else {
                    addCurrentChar = false;
                    if (iRecord.startsWith("*/")) {
                        this.isInComment = false;
                        charToSkip = 1;
                    }
                }
            } else if (currentChar == '\'') {
                if (iRecord.startsWith("''")) {
                    charToSkip = 1;
                    currentToken = String.valueOf(currentToken) + "''";
                } else {
                    this.isInStringLiteral = false;
                    addCurrentChar = true;
                }
            } else {
                addCurrentChar = true;
            }
            if (currentToken.length() == 0 && currentChar == ' ' && !this.isMinusContinuation) {
                addCurrentChar = false;
            }
            if (iRecord.length() == 1) {
                if (currentChar == '+') {
                    this.isPlusContinuation = true;
                    addCurrentChar = false;
                } else if (currentChar == '-') {
                    this.isMinusContinuation = true;
                    addCurrentChar = false;
                } else {
                    this.isPlusContinuation = false;
                    this.isMinusContinuation = false;
                }
            }
            if (addCurrentChar) {
                currentToken = String.valueOf(currentToken) + currentChar;
            }
            iRecord = iRecord.substring(1 + charToSkip);
            charToSkip = 0;
        }
        this.currentCommand = String.valueOf(this.currentCommand) + currentToken;
        if (this.currentCommand.length() > 0 && !this.isMinusContinuation && !this.isPlusContinuation) {
            this.completeCurrentCommand(this.currentCommand);
            this.currentCommand = "";
        }
    }

    protected void completeCurrentCommand(String currentCommand) {
        if (currentCommand.startsWith("//")) {
            currentCommand = currentCommand.substring(2);
        }
        String command = null;
        StringTokenizer stokens = new StringTokenizer(currentCommand);
        if (stokens.hasMoreTokens()) {
            StringTokenizer commandTokens;
            command = stokens.nextToken();
            if (command.equals("?") && stokens.countTokens() >= 2) {
                command = stokens.nextToken();
            }
            if ((commandTokens = new StringTokenizer(command, ":/")).countTokens() == 1) {
                command = commandTokens.nextToken();
            } else if (commandTokens.countTokens() == 2) {
                commandTokens.nextToken();
                command = commandTokens.nextToken();
            } else if (commandTokens.countTokens() == 3) {
                commandTokens.nextToken();
                commandTokens.nextToken();
                command = commandTokens.nextToken();
            }
        }
        if (this.getCommandNameMap().get(command) != null) {
            CLCommand newCommand = new CLCommand(command);
            int charToSkip = 0;
            String currentToken = "";
            String keywordName = "";
            boolean addCurrentChar = false;
            boolean isQuotedObject = false;
            currentCommand = currentCommand.substring(currentCommand.indexOf(command) + command.length());
            while (currentCommand.length() > 0) {
                char currentChar = currentCommand.charAt(0);
                if (!this.isInStringLiteral) {
                    if (!isQuotedObject) {
                        if (currentChar == ' ' || currentChar == ')') {
                            if (currentToken.length() > 0) {
                                this.completeParm(newCommand, keywordName, currentToken);
                                currentToken = "";
                            }
                            addCurrentChar = false;
                        } else if (currentChar == '(') {
                            keywordName = currentToken;
                            currentToken = "";
                            addCurrentChar = false;
                        } else {
                            addCurrentChar = true;
                            if (currentChar == '\"') {
                                isQuotedObject = true;
                            }
                        }
                    } else {
                        addCurrentChar = true;
                        if (currentChar == '\"') {
                            isQuotedObject = false;
                        }
                    }
                    if (currentChar == '\'') {
                        this.isInStringLiteral = true;
                        addCurrentChar = true;
                    }
                } else if (currentChar == '\'') {
                    if (currentCommand.startsWith("''")) {
                        charToSkip = 1;
                        currentToken = String.valueOf(currentToken) + "''";
                    } else {
                        this.isInStringLiteral = false;
                        addCurrentChar = true;
                    }
                } else {
                    addCurrentChar = true;
                }
                if (addCurrentChar) {
                    currentToken = String.valueOf(currentToken) + currentChar;
                }
                currentCommand = currentCommand.substring(1 + charToSkip);
                charToSkip = 0;
            }
            if (currentToken.length() > 0) {
                this.completeParm(newCommand, keywordName, currentToken);
            }
            this.commandList.add(newCommand);
        }
    }

    private void completeParm(CLCommand command, String keywordName, String parm) {
        if (command != null) {
            if (keywordName == null || keywordName.length() == 0) {
                keywordName = this.NO_KEYWORD;
            }
            if (this.getKeywordNameMap().containsKey(keywordName)) {
                command.addKeywordParm(keywordName, parm);
            }
        }
    }

    protected String skipSequenceNumber(String iRecord) {
        if (this.hasSequenceNumber && iRecord.length() > 12) {
            iRecord = iRecord.substring(12);
        }
        return iRecord;
    }

    @Override
    public ClassifierMetaData processEndOfFile(int lineCount) {
        return null;
    }

    protected ArrayList<CLCommand> getCommandList() {
        return this.commandList;
    }

    protected HashMap<String, String> getCommandNameMap() {
        if (this.commandNameMap == null) {
            this.commandNameMap = new HashMap();
        }
        return this.commandNameMap;
    }

    protected HashMap<String, String> getKeywordNameMap() {
        if (this.keywordNameMap == null) {
            this.keywordNameMap = new HashMap();
        }
        return this.keywordNameMap;
    }

    @Override
    public boolean init() {
        return true;
    }
}

