/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify.cfgmgr;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.cfgmgr.SecurityException;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    private static final String[] DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor"};
    private static String[] _supported_crypto_algorithms = null;

    static {
        if (_supported_crypto_algorithms == null) {
            _supported_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
        }
    }

    public static byte[] decipher(byte[] encrypted_bytes, String crypto_algorithm) throws SecurityException {
        if (crypto_algorithm == null) {
            throw new SecurityException(4);
        }
        byte[] decrypted_bytes = null;
        if (!crypto_algorithm.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new SecurityException(4);
        }
        decrypted_bytes = PasswordCipherUtil.xor(encrypted_bytes);
        if (decrypted_bytes == null) {
            throw new SecurityException(1);
        }
        return decrypted_bytes;
    }

    public static byte[] encipher(byte[] decrypted_bytes, String crypto_algorithm) throws SecurityException {
        if (crypto_algorithm == null) {
            throw new SecurityException(4);
        }
        byte[] encrypted_bytes = null;
        if (!crypto_algorithm.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new SecurityException(4);
        }
        encrypted_bytes = PasswordCipherUtil.xor(decrypted_bytes);
        if (encrypted_bytes == null) {
            throw new SecurityException(1);
        }
        return encrypted_bytes;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return _supported_crypto_algorithms;
    }

    private static byte[] xor(byte[] bytes) {
        byte[] xor_bytes = null;
        if (bytes != null) {
            xor_bytes = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                xor_bytes[i] = (byte)(0x5F ^ bytes[i]);
                ++i;
            }
        }
        return xor_bytes;
    }
}

