/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.FileTypeClassification;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

public class BaseClassifierMetaDataHelper
implements IClassifierMetaDataHelper {
    private final String dd_output = "DD:ATTRBOUT";
    private boolean firstAttr = true;
    private ClassifierMetaData metaData = null;
    private PrintWriter out = null;
    private String fileTypeCd = null;
    private String resourceType;
    private String memberName = "";
    private String outputFormat;
    private StringBuffer jsonStringBuffer;

    public BaseClassifierMetaDataHelper(String iOutputFormat) {
        if (iOutputFormat.equalsIgnoreCase("JSON")) {
            this.jsonStringBuffer = new StringBuffer("");
            this.outputFormat = "JSON";
        } else {
            this.jsonStringBuffer = null;
            this.outputFormat = "";
        }
    }

    @Override
    public void AttribOutput(ClassifierMetaData iMetaData) {
        Map<Integer, Integer> attnList;
        int RD_COMMENT_LINES = 27;
        int RD_NONCOMMENT_LINES = 28;
        int RD_BLANK_LINES = 29;
        int RD_NONCOMNT_BEF_1ST = 39;
        int RD_NONCOMNT_AFT_1ST = 40;
        int DMH_RECORD_COUNT_MEM = 106;
        this.metaData = iMetaData;
        if (this.outputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\t\"attrs\": [");
        }
        this.CreateATTNRecords(106, iMetaData.getTotalLine());
        this.CreateATTNRecords(27, iMetaData.getCommentLine());
        this.CreateATTNRecords(28, iMetaData.getNonCommentLine());
        this.CreateATTNRecords(29, iMetaData.getBlankLine());
        if (iMetaData.getNonBefore() >= 0) {
            this.CreateATTNRecords(39, iMetaData.getNonBefore());
        }
        if (iMetaData.getNonAfter() >= 0) {
            this.CreateATTNRecords(40, iMetaData.getNonAfter());
        }
        if ((attnList = iMetaData.getAttnList()) != null) {
            for (Map.Entry<Integer, Integer> e : attnList.entrySet()) {
                this.CreateATTNRecords(e.getKey(), e.getValue());
            }
        }
        if (this.outputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\t], ");
        }
        this.CreateINCLrecord(iMetaData.getInclList());
    }

    @Override
    public void CloseAttrRecordFile() {
        if (this.outputFormat.equals("JSON")) {
            return;
        }
        this.out.flush();
        this.out.close();
    }

    public void CreateATTNRecords(Integer iAttrTypeId, Integer iAttrNumValue) {
        if (this.outputFormat.equals("JSON")) {
            if (this.firstAttr) {
                this.jsonStringBuffer.append("\n\t\t");
                this.firstAttr = false;
            } else {
                this.jsonStringBuffer.append(",\n\t\t");
            }
            this.jsonStringBuffer.append("{");
            this.jsonStringBuffer.append(this.formatJsonATTN(iAttrTypeId, iAttrNumValue));
            this.jsonStringBuffer.append("}");
            return;
        }
        this.out.println(String.format("ATTN %d %d", iAttrTypeId, iAttrNumValue));
        this.out.flush();
    }

    private void CreateINCLrecord(Map iInclList) {
        if (iInclList == null || iInclList.size() == 0) {
            return;
        }
        if (this.outputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\"references\": [");
        }
        boolean firstIncl = true;
        firstIncl = this.getCompletJSONString(iInclList, firstIncl);
        if (this.outputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n\t\t], ");
        }
    }

    protected boolean getCompletJSONString(Map iInclList, boolean firstIncl) {
        for (Map.Entry e : iInclList.entrySet()) {
            Set values = (Set)e.getValue();
            for (Object value : values) {
                Integer inclTypeId = (Integer)e.getKey();
                String inclName = (String)value;
                firstIncl = this.getJSONString(firstIncl, inclTypeId, inclName);
            }
        }
        return firstIncl;
    }

    protected boolean getJSONString(boolean firstIncl, Integer inclTypeId, String inclName) {
        if (this.outputFormat.equals("JSON")) {
            if (firstIncl) {
                this.jsonStringBuffer.append("\n\t\t");
                firstIncl = false;
            } else {
                this.jsonStringBuffer.append(",\n\t\t");
            }
            this.jsonStringBuffer.append("{");
            this.jsonStringBuffer.append(this.formatJsonINCL(inclTypeId, inclName));
            this.jsonStringBuffer.append("}");
        } else {
            this.out.println(String.format("INCL %d %s", inclTypeId, inclName));
            this.out.flush();
        }
        return firstIncl;
    }

    public void CreateLIBRrecord(String iContainerName, String iRmType) {
        if (this.outputFormat.equals("JSON")) {
            return;
        }
        this.out.println(String.format("LIBR %s %s", this.quote(iContainerName), iRmType));
        this.out.flush();
    }

    @Override
    public void CreateMEMBrecord(String iLanguageCd) {
        if (this.outputFormat.equals("JSON")) {
            this.jsonStringBuffer.append("\n");
            this.jsonStringBuffer.append("\t\"name\":\"" + this.memberName + "\",\n");
            this.jsonStringBuffer.append("\t\"languageCd\":\"" + iLanguageCd + "\",\n");
            return;
        }
        this.out.println(String.format("MEMB %s %s", this.quote(this.memberName), iLanguageCd));
        this.out.flush();
    }

    public void CreateSITErecord(String iSiteName) {
        if (this.outputFormat.equals("JSON")) {
            return;
        }
        if (iSiteName == null || iSiteName.length() == 0) {
            return;
        }
        this.out.println(String.format("SITE %s", this.quote(iSiteName)));
        this.out.flush();
    }

    public void CreateTOOLrecord() {
        if (this.outputFormat.equals("JSON")) {
            return;
        }
        this.out.println(String.format("TOOL 0001000217", new Object[0]));
        this.out.flush();
    }

    @Override
    public String getFileTypeCd() {
        if (this.fileTypeCd == null) {
            if (this.metaData == null) {
                this.fileTypeCd = "UNKN";
            } else {
                FileTypeClassification fileTypeClassification = new FileTypeClassification(this.metaData.getAttcList(), this.metaData.getAttnList(), this.metaData.getInclList());
                this.fileTypeCd = fileTypeClassification.identifyFileType(this.metaData.getLanguageCd());
            }
        }
        return this.fileTypeCd;
    }

    @Override
    public boolean OpenAttrRecordFile() {
        FileWriter fw;
        if (this.outputFormat.equals("JSON")) {
            return true;
        }
        try {
            fw = new FileWriter("DD:ATTRBOUT");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.out = new PrintWriter(fw);
        return true;
    }

    @Override
    public String getLanguageCd() {
        return this.metaData.getLanguageCd();
    }

    private String getLogicalName(String iFilename) {
        int pChar = iFilename.lastIndexOf(46);
        if (pChar == -1) {
            return iFilename.toUpperCase();
        }
        return iFilename.substring(0, pChar).toUpperCase();
    }

    @Override
    public String getMetaDataString() {
        String patternString;
        if (!this.outputFormat.equals("JSON")) {
            return "";
        }
        if (this.metaData == null) {
            return "";
        }
        String jsonString = this.jsonStringBuffer.toString();
        if (!jsonString.startsWith(patternString = "{\n\"classify\": {")) {
            jsonString = String.valueOf(patternString) + jsonString;
            String tempFileTypeCd = this.getFileTypeCd();
            jsonString = String.valueOf(jsonString) + "\n";
            if (tempFileTypeCd.equals("INCL") || tempFileTypeCd.equals("PROC")) {
                jsonString = String.valueOf(jsonString) + "\t\"" + "fileTypeCd" + "\":\"" + tempFileTypeCd + "\",\n";
                jsonString = String.valueOf(jsonString) + "\t\"" + "logicalName" + "\":\"" + this.getLogicalName(this.memberName) + "\"\n";
            } else {
                jsonString = String.valueOf(jsonString) + "\t\"" + "fileTypeCd" + "\":\"" + tempFileTypeCd + "\"\n";
            }
            jsonString = String.valueOf(jsonString) + "\t}\n}";
        }
        return jsonString;
    }

    private String formatJsonATTN(Integer attrTypeId, Integer attrNumValue) {
        StringBuffer metaData = new StringBuffer("\"type\":\"");
        switch (attrTypeId) {
            case 27: {
                metaData.append("commentLines");
                break;
            }
            case 28: {
                metaData.append("nonCommentLines");
                break;
            }
            case 29: {
                metaData.append("blankLines");
                break;
            }
            case 33: {
                metaData.append("execSQL");
                break;
            }
            case 34: {
                metaData.append("identificationDivision");
                break;
            }
            case 35: {
                metaData.append("environmentDivision");
                break;
            }
            case 36: {
                metaData.append("dataDivision");
                break;
            }
            case 37: {
                metaData.append("procedureDivision");
                break;
            }
            case 38: {
                metaData.append("callCBLTDLI");
                break;
            }
            case 39: {
                metaData.append("nonCommentBefore1st");
                break;
            }
            case 40: {
                metaData.append("nonCommentAfter1st");
                break;
            }
            case 44: {
                metaData.append("OPSYN");
                break;
            }
            case 45: {
                metaData.append("ICTL");
                break;
            }
            case 46: {
                metaData.append("CSECT");
                break;
            }
            case 47: {
                metaData.append("START");
                break;
            }
            case 48: {
                metaData.append("PSB");
                break;
            }
            case 49: {
                metaData.append("PCB");
                break;
            }
            case 50: {
                metaData.append("FCT");
                break;
            }
            case 51: {
                metaData.append("PCT");
                break;
            }
            case 52: {
                metaData.append("jobCard");
                break;
            }
            case 53: {
                metaData.append("execStmt");
                break;
            }
            case 54: {
                metaData.append("execPgm");
                break;
            }
            case 55: {
                metaData.append("PPT");
                break;
            }
            case 57: {
                metaData.append("ENTRY");
                break;
            }
            case 62: {
                metaData.append("macroDef");
                break;
            }
            case 63: {
                metaData.append("procDef");
                break;
            }
            case 64: {
                metaData.append("copyReplacing");
                break;
            }
            case 65: {
                metaData.append("DFHMSD");
                break;
            }
            case 81: {
                metaData.append("DBD");
                break;
            }
            case 82: {
                metaData.append("CEEENTRY");
                break;
            }
            case 83: {
                metaData.append("splittingNodes");
                break;
            }
            case 84: {
                metaData.append("CEEXAHD");
                break;
            }
            case 85: {
                metaData.append("CEEXART");
                break;
            }
            case 86: {
                metaData.append("CEEXAST");
                break;
            }
            case 87: {
                metaData.append("MFS");
                break;
            }
            case 106: {
                metaData.append("recordCount");
                break;
            }
            default: {
                metaData.append("unknown");
            }
        }
        metaData.append("\", \"value\":\"" + attrNumValue + "\"");
        return metaData.toString();
    }

    private String quote(String s) {
        return s.indexOf(32) == -1 ? s : String.valueOf('\"') + s + '\"';
    }

    @Override
    public void setMemberName(String iSetting) {
        this.memberName = iSetting;
    }

    protected String formatJsonINCL(Integer iInclTypeId, String iInclName) {
        StringBuffer metaData = new StringBuffer();
        iInclName = StringUtils.replace(iInclName, "\"", "\\\"");
        switch (iInclTypeId) {
            case 3: {
                metaData.append("\"").append("type").append("\":\"COPY\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                break;
            }
            case 4: {
                metaData.append("\"").append("type").append("\":\"COPY\"");
                String[] tokens = iInclName.split(" DD=");
                metaData.append(", \"").append("name").append("\":\"" + tokens[0] + "\"");
                metaData.append(", \"ddName\":\"" + tokens[1] + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                break;
            }
            case 5: {
                metaData.append("\"").append("type").append("\":\"++INCLUDE\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                break;
            }
            case 6: {
                metaData.append("\"").append("type").append("\":\"-INC\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                break;
            }
            case 7: {
                metaData.append("\"").append("type").append("\":\"SQL INCLUDE\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                break;
            }
            case 8: {
                metaData.append("\"").append("type").append("\":\"MACRO\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"MAC\"");
                break;
            }
            case 9: {
                metaData.append("\"").append("type").append("\":\"PROC\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"PROC\"");
                break;
            }
            case 62: {
                metaData.append("\"").append("type").append("\":\"MACRO_DEF\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"MAC\"");
                break;
            }
            default: {
                metaData.append("\"").append("type").append("\":\"unknown\"");
                metaData.append(", \"").append("name").append("\":\"" + iInclName + "\"");
                metaData.append(", \"").append("fileTypeCd").append("\":\"INCL\"");
                metaData.append(", \"").append("resourceType").append("\":\"").append("MBR").append("\"");
            }
        }
        return metaData.toString();
    }
}

