/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.BaseClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.IClassifierMetaDataHelper;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ILanguageRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cfgmgr.ConfigEntry;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cfgmgr.ConfigFile;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.cfgmgr.ConfigRuntimeException;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.FileHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class BaseClassifier {
    private final String aipAnalyzers = "/com/ibm/team/enterprise/ibmi/metadata/common/classify/aipAnalyzers";
    private ILanguageRecordParser recordParser;
    private IClassifierMetaDataHelper metaDataHelper;
    private String[] fileRecords;
    private String inrec;
    private int lineCount;
    private boolean debug = false;
    private String version = "";
    private String check_ContentMIMEType;
    private String check_FileExtension;
    private String check_LanguageCd;
    private String languageCd;

    public void init(String iOutputFormat, boolean debug) {
        this.inrec = "";
        this.debug = debug;
        this.metaDataHelper = this.getClassifierMetaDataHelper(iOutputFormat);
        if (this.getLanguageRecordParser() != null) {
            this.getLanguageRecordParser().setDebug(debug);
        }
    }

    protected IClassifierMetaDataHelper getClassifierMetaDataHelper(String outputFormat) {
        return new BaseClassifierMetaDataHelper(outputFormat);
    }

    protected FileHandler processSingleFile(String iContainerName, String iFileName, String iLocalName, String iFileContent) {
        if (iContainerName == null) {
            iContainerName = "";
        }
        if (iFileName == null) {
            iFileName = "";
        }
        if (iLocalName == null) {
            iLocalName = "";
        }
        FileHandler fileHandler = new FileHandler(iContainerName, iFileName, iLocalName);
        this.InitializeFields(fileHandler.getNormalizedFileName());
        String fileSpecText = fileHandler.getFileToOpen();
        String fileContent = iFileContent == null ? fileHandler.getFileContent(fileSpecText) : iFileContent;
        this.ProcessFilesContent(fileHandler, fileSpecText, fileContent);
        return fileHandler;
    }

    private void InitializeFields(String iFileName) {
        this.metaDataHelper.setMemberName(iFileName);
        this.getLanguageRecordParser().setIdentifier('N');
        this.getLanguageRecordParser().setBlankCount(0);
    }

    private void ProcessFilesContent(FileHandler iFileHandler, String iFileSpecText, String iFileContent) {
        this.check_ContentMIMEType = "";
        this.check_LanguageCd = this.getLanguageCd();
        if (iFileHandler != null && (this.check_LanguageCd == null || this.check_LanguageCd.equals("")) && !this.checkFileExtension(iFileHandler.getNormalizedFileName())) {
            this.check_LanguageCd = this.getLanguageCd();
        }
        this.processFileRecords(this.check_LanguageCd, iFileContent, iFileSpecText);
        this.processEndOfFile(this.lineCount);
        this.memoryStructureCleanup();
    }

    protected ClassifierMetaData processEndOfFile(int lineCount) {
        String mbrRecord = this.getMemberRecordString();
        this.metaDataHelper.CreateMEMBrecord(mbrRecord);
        ClassifierMetaData metaData = this.getLanguageRecordParser().processEndOfFile(lineCount);
        metaData.setLanguageCd(mbrRecord);
        this.metaDataHelper.AttribOutput(metaData);
        return metaData;
    }

    /*
     * Unable to fully structure code
     */
    private boolean processFileRecords(String iLanguageCd, String iFileContent, String iFileSpecText) {
        this.initializeValidators();
        if (!this.checkIfMemberExists(iFileSpecText, iFileContent)) {
            return false;
        }
        if (!this.getFileRecords(iFileSpecText, iFileContent)) {
            return false;
        }
        this.lineCount = 0;
        recordAvailable = this.getSingleRecord(this.lineCount);
        if (recordAvailable && (this.lineCount != 0 || this.inrec.length() != 0)) ** GOTO lbl17
        return true;
lbl-1000:
        // 1 sources

        {
            if (this.debug) {
                System.out.println(String.format("Debug:  currentLine=[%05d %s]", new Object[]{this.lineCount + 1, this.inrec}));
            }
            if (!this.isBlankLine(this.inrec)) {
                this.inrec = this.preprocess(this.inrec);
                this.getLanguageRecordParser().process(this.lineCount, this.inrec, this.getLanguageCd());
            }
            ++this.lineCount;
            recordAvailable = this.getSingleRecord(this.lineCount);
lbl17:
            // 2 sources

            ** while (recordAvailable)
        }
lbl18:
        // 1 sources

        return true;
    }

    protected String preprocess(String inrec) {
        return inrec;
    }

    public String getLanguageCd() {
        return this.languageCd;
    }

    private boolean isBlankLine(String inrec) {
        String temp = inrec.trim();
        if (temp.length() != 0) {
            return false;
        }
        this.getLanguageRecordParser().incrementBlankCount();
        return true;
    }

    protected void initializeValidators() {
        this.getLanguageRecordParser().processInitialization();
        this.getLanguageRecordParser().setIdentifier('U');
    }

    private boolean checkIfMemberExists(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            return true;
        }
        File file = new File(iFileSpecText);
        return file.exists() && file.canRead();
    }

    private boolean getFileRecords(String iFileSpecText, String iFileContent) {
        if (iFileContent != null) {
            this.fileRecords = iFileContent.split("\n");
            return true;
        }
        File file = new File(iFileSpecText);
        FileInputStream fis = null;
        String contents = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            contents = this.readInputStream(fis);
            this.fileRecords = contents.split("\n");
            fis.close();
        }
        catch (IOException e) {
            this.fileRecords = null;
            return false;
        }
        return true;
    }

    private boolean getSingleRecord(int iLineCount) {
        if (this.fileRecords == null) {
            return false;
        }
        if (iLineCount >= this.fileRecords.length) {
            return false;
        }
        this.inrec = this.fileRecords[iLineCount];
        if (this.inrec.endsWith("\r")) {
            this.inrec = this.inrec.substring(0, this.inrec.length() - 1);
        }
        return true;
    }

    private String readInputStream(InputStream readStream) throws IOException {
        int BUFF_SIZE = 4096;
        ByteArrayOutputStream accumulator = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int readSize = readStream.read(buffer, 0, 4096);
        while (readSize >= 0) {
            accumulator.write(buffer, 0, readSize);
            readSize = readStream.read(buffer, 0, 4096);
        }
        return accumulator.toString();
    }

    public void setLanguageRecordParser(ILanguageRecordParser recordParser) {
        this.recordParser = recordParser;
    }

    protected ILanguageRecordParser getLanguageRecordParser() {
        return this.recordParser;
    }

    private void reportLineIfDebugModeOn() {
        if (this.debug) {
            System.out.println(String.format("Debug:  currentLine=[%05d %s]", this.lineCount, this.inrec));
        }
    }

    private boolean checkForBlankLine() {
        String temp = this.inrec.trim();
        if (temp.length() != 0) {
            return false;
        }
        this.getLanguageRecordParser().incrementBlankCount();
        return true;
    }

    public String analyzeFilesMetadata(String iContainerName, String iFileName) {
        return this.analyzeFilesMetadata(iContainerName, iFileName, (String)null);
    }

    public String analyzeFilesMetadata(String iFileName, InputStream iInputStream) {
        return this.analyzeFilesMetadata(null, iFileName, iInputStream);
    }

    public String analyzeFilesMetadata(String iContainerName, String iFileName, InputStream iInputStream) {
        String fileContent;
        try {
            fileContent = FileHandler.readInputStream(iInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.analyzeFilesMetadata(iContainerName, iFileName, fileContent);
    }

    public String analyzeFilesMetadata(String iContainerName, String iFileName, String iFileContent) {
        this.init("JSON", this.debug);
        this.processSingleFile(iContainerName, iFileName, null, iFileContent);
        return this.metaDataHelper.getMetaDataString();
    }

    public String getMetaDataString() {
        return this.metaDataHelper.getMetaDataString();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    protected String getMemberRecordString() {
        return "";
    }

    protected void memoryStructureCleanup() {
        this.getLanguageRecordParser().processDeallocate();
        this.getLanguageRecordParser().setIdentifier('D');
    }

    protected boolean checkFileExtension(String iFileNameNoQuotes) {
        String charValue;
        int pChar = iFileNameNoQuotes.lastIndexOf(46);
        if (pChar == -1) {
            return false;
        }
        if (iFileNameNoQuotes.substring(pChar).length() == 1) {
            return false;
        }
        this.check_FileExtension = iFileNameNoQuotes.substring(pChar + 1);
        String workFileExtension = charValue = this.check_FileExtension.toUpperCase();
        if (this.debug) {
            System.out.println("Debug: fileName has extension\n");
        }
        boolean foundExtensionMatch = false;
        boolean foundLanguageCd = false;
        String cfgSection = "";
        String currentCfgSection = null;
        String contentMIMEType = "";
        String languageCd = "";
        Map<String, String> values = this.getConfigMap("/com/ibm/team/enterprise/ibmi/metadata/common/classify/aipAnalyzers");
        TreeSet<String> keys = new TreeSet<String>(values.keySet());
        block0: for (String key : keys) {
            String value = values.get(key);
            int index = key.indexOf(46);
            if (index == -1) {
                cfgSection = "";
            } else {
                cfgSection = key.substring(0, index);
                key = key.substring(index + 1);
            }
            if (this.debug) {
                System.out.println("Debug: section [" + cfgSection + "] key [" + key + "] value [" + value + "]");
            }
            if (currentCfgSection == null) {
                currentCfgSection = cfgSection;
            } else if (!currentCfgSection.equals(cfgSection)) {
                if (foundExtensionMatch && foundLanguageCd) break;
                foundExtensionMatch = false;
                foundLanguageCd = false;
                contentMIMEType = "";
                languageCd = "";
                currentCfgSection = cfgSection;
            }
            if (key.equals("contentMIMEType")) {
                contentMIMEType = value;
                continue;
            }
            if (key.equals("fileExts")) {
                String[] tempString = value.split(",");
                int i = 0;
                while (i < tempString.length) {
                    charValue = tempString[i].toUpperCase();
                    if (charValue.equals(workFileExtension)) {
                        foundExtensionMatch = true;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!key.equals("languageCd")) continue;
            foundLanguageCd = true;
            languageCd = value;
        }
        if (foundExtensionMatch && languageCd.length() != 0) {
            if (this.debug) {
                System.out.println(String.format("Debug: Matched extension, found languageCd: %s", languageCd));
            }
            this.check_ContentMIMEType = contentMIMEType;
            this.check_LanguageCd = languageCd;
        } else if (this.debug) {
            System.out.println(String.format("Debug: Did not match an %s extension", "/com/ibm/team/enterprise/ibmi/metadata/common/classify/aipAnalyzers.cfg"));
        }
        return true;
    }

    private Map<String, String> getConfigMap(String config) throws ConfigRuntimeException {
        TreeMap<String, String> m = new TreeMap<String, String>();
        ConfigFile c = this.getConfigFile(config);
        Map<String, ConfigEntry> valueMap = c.getAllValuesMap();
        for (String key : valueMap.keySet()) {
            m.put(key, valueMap.get(key).getValue());
        }
        return m;
    }

    private ConfigFile getConfigFile(String filename) throws ConfigRuntimeException {
        InputStream inputStream;
        if (filename.indexOf(46) == -1) {
            filename = String.valueOf(filename) + ".cfg";
        }
        if ((inputStream = this.getClass().getResourceAsStream(filename)) == null) {
            throw new ConfigRuntimeException("Could not getResourceAsStream() for [" + filename + "]");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ConfigFile c = new ConfigFile(dataInputStream);
        return c;
    }

    public boolean init() {
        return true;
    }
}

