/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.metadata.common.classify;

import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierMetaData;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ClassifierReservedWord;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.ILanguageRecordParser;
import com.ibm.team.enterprise.ibmi.metadata.common.classify.utils.StringUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public abstract class AbstractRecordParser
implements ILanguageRecordParser {
    protected boolean debug = false;
    protected boolean isWindows;
    protected char identifier = (char)73;
    protected ClassifierMetaData metaData = null;
    protected HashMap<String, ClassifierReservedWord> reservedWords;
    protected int blankCount = 0;
    protected int reserveWordCount = 0;
    protected int score = 0;
    protected String reservedWordFilename = null;

    protected AbstractRecordParser() {
        this.isWindows = System.getProperty("os.name").startsWith("Win");
        this.reservedWords = new HashMap();
    }

    protected ClassifierReservedWord AllocateReserveWord(String iToken, String iTokenType, int iTokenWeight, int iTokenAttrTypeId) {
        ClassifierReservedWord reservedWord = new ClassifierReservedWord(iToken, iTokenAttrTypeId, iTokenType, iTokenWeight);
        if (iTokenWeight == 1) {
            reservedWord.setTokenWeight(0);
        } else if (iTokenWeight == 2) {
            reservedWord.setTokenWeight(1);
        } else if (iTokenWeight == 3) {
            reservedWord.setTokenWeight(10);
        } else if (iTokenWeight == 4) {
            reservedWord.setTokenWeight(10);
        } else if (iTokenWeight == 5) {
            reservedWord.setTokenWeight(60);
        } else {
            return null;
        }
        if (iTokenType.equals("ReservedWord")) {
            reservedWord.setTokenWordType(1);
        } else if (iTokenType.equals("Delimit")) {
            reservedWord.setTokenWordType(2);
        } else if (iTokenType.equals("Verb")) {
            reservedWord.setTokenWordType(3);
        } else if (iTokenType.equals("ScopeDelimit")) {
            reservedWord.setTokenWordType(4);
        } else if (iTokenType.equals("Ignore")) {
            reservedWord.setTokenWordType(5);
        } else {
            return null;
        }
        return reservedWord;
    }

    protected boolean CheckAlternateFormsOfCopy(String iRecord) {
        String pTokens;
        String s;
        if (iRecord.length() > 17 && (s = iRecord.substring(7, 17)).equals("++INCLUDE ")) {
            pTokens = iRecord.substring(16);
            if ((pTokens = pTokens.trim()).length() != 0) {
                String[] token = StringUtils.split(pTokens, ".");
                String memberName = token[0];
                this.metaData.addInclude(5, memberName);
                return true;
            }
        }
        if (iRecord.length() > 4 && (s = iRecord.substring(0, 5)).equals("-INC ")) {
            pTokens = iRecord.substring(4);
            if ((pTokens = pTokens.trim()).length() != 0) {
                String[] token = StringUtils.split(pTokens, ".");
                String memberName = token[0];
                this.metaData.addInclude(6, memberName);
                return true;
            }
        }
        return false;
    }

    public int getBlankCount() {
        return this.blankCount;
    }

    public int getCommentCount() {
        return this.metaData.getCommentLine();
    }

    @Override
    public char getIdentifier() {
        return this.identifier;
    }

    public int getReserveWordCount() {
        return this.reserveWordCount;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void incrementBlankCount() {
        ++this.blankCount;
    }

    @Override
    public boolean init() {
        return this.initializeReservedWords();
    }

    protected boolean initializeReservedWords() {
        InputStream inputStream;
        block5: {
            if (this.reservedWords.size() != 0) {
                return true;
            }
            inputStream = this.getClass().getResourceAsStream(this.reservedWordFilename);
            if (inputStream != null) break block5;
            System.out.println("Error: resource not found [" + this.reservedWordFilename + "]");
            return false;
        }
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#")) continue;
                String[] tokens = StringUtils.splitQuoted(strLine, ',', true, true, true);
                int tokenAttrTypeId = Integer.parseInt(tokens[3]);
                String token = tokens[0];
                String tokenType = tokens[1];
                int tokenWeight = Integer.parseInt(tokens[2]);
                ClassifierReservedWord reservedWord = this.AllocateReserveWord(token, tokenType, tokenWeight, tokenAttrTypeId);
                if (reservedWord == null) continue;
                this.reservedWords.put(token, reservedWord);
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void process(int iRecordCount, String iRecord, String iBaseLanguage) {
        this.processOneRecord(iRecordCount, iRecord, iBaseLanguage);
    }

    @Override
    public void processInitialization() {
        this.blankCount = 0;
        this.identifier = (char)73;
        this.reserveWordCount = 0;
        this.score = 0;
    }

    @Override
    public void processDeallocate() {
        this.metaData = null;
    }

    public void resetReservedWords() {
        this.reservedWords = null;
    }

    @Override
    public void setBlankCount(int iSetting) {
        this.blankCount = iSetting;
    }

    @Override
    public void setDebug(boolean iSetting) {
        this.debug = iSetting;
    }

    @Override
    public void setIdentifier(char iSetting) {
        this.identifier = iSetting;
    }

    public void setScore(int iSetting) {
        this.score = iSetting;
    }

    protected abstract void processOneRecord(int var1, String var2, String var3);
}

