/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.client.scanner;

import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScannerFilter;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MetadataScannerUtil {
    public static final List<String> getDependencyTypes(ITeamRepository repository, ILanguageDefinition langdef, IFileMetadataScannerFilter filter, boolean excludeDuplicates) {
        ArrayList<String> dependencyTypes = new ArrayList<String>();
        if (repository != null) {
            IMetadataScannerClientLibrary library = (IMetadataScannerClientLibrary)repository.getClientLibrary(IMetadataScannerClientLibrary.class);
            List stringHelpers = langdef.getSourceCodeDataScanners();
            ArrayList<String> scannerNames = new ArrayList<String>(stringHelpers.size());
            for (IStringHelper stringHelper : stringHelpers) {
                scannerNames.add(stringHelper.getValue());
            }
            try {
                IFileMetadataScanner[] scanners;
                IFileMetadataScanner[] iFileMetadataScannerArray = scanners = library.getMetadataScanner(scannerNames.toArray(new String[scannerNames.size()]));
                int n = scanners.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileMetadataScanner scanner = iFileMetadataScannerArray[n2];
                    if (filter == null || filter.accept(scanner)) {
                        MetadataScannerUtil.getDependencyTypes(scanner, dependencyTypes, excludeDuplicates);
                    }
                    ++n2;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return dependencyTypes;
    }

    public static final List<String> getDependencyTypes(IFileMetadataScanner scanner) {
        ArrayList<String> dependencyTypes = new ArrayList<String>();
        MetadataScannerUtil.getDependencyTypes(scanner, dependencyTypes, false);
        return dependencyTypes;
    }

    public static final void getDependencyTypes(IFileMetadataScanner scanner, List<String> dependencyTypes, boolean excludeDuplicates) {
        String typeStr;
        if (dependencyTypes == null) {
            dependencyTypes = new ArrayList<String>();
        }
        if ((typeStr = scanner.getDependencyTypes()) != null) {
            StringTokenizer st = new StringTokenizer(typeStr, ",");
            while (st.hasMoreTokens()) {
                String next = st.nextToken().trim();
                if (excludeDuplicates) {
                    if (dependencyTypes.contains(next)) continue;
                    dependencyTypes.add(next);
                    continue;
                }
                dependencyTypes.add(next);
            }
        }
    }
}

