/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.client.query;

import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.common.scanner.IMetadataValueType;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.AttributeOperator;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public class MetadataQueryClientUtil {
    public static IAttribute createAttribute(String id, String name, String namespace, IMetadataValueType type, String repositoryUrl) {
        UUID uuid = id == null ? UUID.generate() : UUID.valueOf((String)id);
        if (type == IMetadataValueType.BOOLEAN) {
            ArrayList<AttributeOperator> operators = new ArrayList<AttributeOperator>(1);
            operators.add(AttributeOperator.IS);
            return new Attribute(uuid, namespace, name, null, IAttribute.AttributeType.BOOLEAN, null, operators, repositoryUrl);
        }
        if (type == IMetadataValueType.LIST) {
            return new Attribute(uuid, namespace, name, null, IAttribute.AttributeType.LIST, null, new ArrayList(0), repositoryUrl);
        }
        if (type == IMetadataValueType.NUMBER) {
            ArrayList<AttributeOperator> operators = new ArrayList<AttributeOperator>(2);
            operators.add(AttributeOperator.IS);
            operators.add(AttributeOperator.IS_NOT);
            operators.add(AttributeOperator.GREATER_OR_EQUALS);
            operators.add(AttributeOperator.LESS_OR_EQUALS);
            return new Attribute(uuid, namespace, name, null, IAttribute.AttributeType.NUMBER, null, operators, repositoryUrl);
        }
        ArrayList<AttributeOperator> operators = new ArrayList<AttributeOperator>(2);
        operators.add(AttributeOperator.IS);
        operators.add(AttributeOperator.IS_NOT);
        operators.add(AttributeOperator.CONTAINS);
        operators.add(AttributeOperator.DOES_NOT_CONTAIN);
        return new Attribute(uuid, namespace, name, null, IAttribute.AttributeType.STRING, null, operators, repositoryUrl);
    }

    public static IAttribute toAttribute(TransportProperty property, String repositoryUrl) {
        IMetadataValueType type = MetadataQueryClientUtil.convertToMetadataValueType(property.getValue());
        if (type == null) {
            return null;
        }
        IAttribute attribute = MetadataQueryClientUtil.createAttribute(null, property.getLocalName(), property.getNamespace(), type, repositoryUrl);
        List properties = property.getValue().getPropertyList();
        if (properties != null) {
            for (TransportProperty next : properties) {
                type = MetadataQueryClientUtil.convertToMetadataValueType(next.getValue());
                if (type == null) continue;
                attribute.addChildAttribute(MetadataQueryClientUtil.createAttribute(null, next.getLocalName(), next.getNamespace(), type, repositoryUrl));
            }
        }
        return attribute;
    }

    public static IMetadataValueType convertToMetadataValueType(TransportPropertyValue propertyValue) {
        if (propertyValue.getValueType() == 1) {
            return IMetadataValueType.BOOLEAN;
        }
        if (propertyValue.getValueType() == 2) {
            return IMetadataValueType.NUMBER;
        }
        if (propertyValue.getValueType() == 0) {
            return IMetadataValueType.STRING;
        }
        if (propertyValue.getValueType() == 3) {
            return IMetadataValueType.LIST;
        }
        return null;
    }
}

