/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.metadata.client.collection;

import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.metadata.client.collection.ClientFactory;
import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportFile;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportProperty;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportPropertyValue;
import com.ibm.team.enterprise.metadata.common.collection.transport.TransportUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MetadataCollectionUtils {
    public static TransportFile createSourceFileMetadata(IFile file, boolean initScm) throws TeamRepositoryException {
        if (file != null && ZComponentUtils.isShared((IAdaptable)file)) {
            IShareable shareable = ZComponentUtils.getSharable((IResource)file);
            String filePath = "/" + file.getProject().getName();
            String projectRelativePath = file.getProjectRelativePath().toString();
            if (!projectRelativePath.startsWith("/")) {
                projectRelativePath = "/" + projectRelativePath;
            }
            filePath = String.valueOf(filePath) + projectRelativePath;
            return MetadataCollectionUtils.createSourceFileMetadata(shareable, file.getName(), filePath, initScm);
        }
        return null;
    }

    public static TransportFile createSourceFileMetadata(IFile file) throws TeamRepositoryException {
        return MetadataCollectionUtils.createSourceFileMetadata(file, true);
    }

    public static TransportFile createSourceFileMetadata(IShareable shareable, String fileName, String filePath) throws TeamRepositoryException {
        return MetadataCollectionUtils.createSourceFileMetadata(shareable, fileName, filePath, true);
    }

    private static TransportFile createSourceFileMetadata(IShareable shareable, String fileName, String filePath, boolean initScm) throws TeamRepositoryException {
        TransportFile sfm = null;
        MetadataClientArgs args = MetadataCollectionUtils.getMetadataClientArgs(shareable);
        String itemSlug = MetadataCollectionUtils.getSlug(args.getFileItemId());
        String fileResourceURI = "http://www.ibm.com/xmlns/prod/rational/rtc/scd/file/" + itemSlug;
        sfm = new TransportFile(fileResourceURI);
        if (initScm) {
            sfm.getProperties().add(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "fileName", new TransportPropertyValue(fileName)));
            sfm.getProperties().add(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "fileItemId", new TransportPropertyValue(args.getFileItemId())));
            sfm.getProperties().add(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "componentId", new TransportPropertyValue(args.getComponentId())));
            sfm.getProperties().add(new TransportProperty("http://www.ibm.com/xmlns/prod/rational/rtc/metadata/sourcefile/scm/", "filePath", new TransportPropertyValue(filePath)));
        }
        return sfm;
    }

    public static TransportFile getSourceFileMetadata(IFile file, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (file != null && ZComponentUtils.isShared((IAdaptable)file)) {
            IShareable shareable = ZComponentUtils.getSharable((IResource)file);
            return MetadataCollectionUtils.getSourceFileMetadata(shareable, progressMonitor);
        }
        return null;
    }

    public static TransportFile getSourceFileMetadata(IShareable shareable, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        MetadataClientArgs args = MetadataCollectionUtils.getMetadataClientArgs(shareable);
        return MetadataCollectionUtils.getSourceFileMetadata(args.getTeamRepository(), args.getStreamId(), args.getComponentId(), args.getFileItemId(), progressMonitor);
    }

    public static TransportFile getSourceFileMetadata(ITeamRepository repo, String streamId, String componentId, String fileItemId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        TransportFile tFile = null;
        IMetadataCollectionClient client = ClientFactory.getMetadataCollectionClient(repo);
        String metadata = client.getSourceFileMetadata(streamId, componentId, fileItemId, progressMonitor);
        if (metadata != null) {
            try {
                List fileList = TransportUtil.fromXML((String)metadata);
                if (fileList.size() == 1) {
                    tFile = (TransportFile)fileList.get(0);
                }
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return tFile;
    }

    public static void setSourceFileMetadata(IFile file, TransportFile metadata, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (file == null || !ZComponentUtils.isShared((IAdaptable)file)) {
            throw new TeamRepositoryException("File is not shared");
        }
        IShareable shareable = ZComponentUtils.getSharable((IResource)file);
        MetadataCollectionUtils.setSourceFileMetadata(shareable, metadata, progressMonitor);
    }

    public static void setSourceFileMetadata(IShareable shareable, TransportFile metadata, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        MetadataClientArgs args = MetadataCollectionUtils.getMetadataClientArgs(shareable);
        MetadataCollectionUtils.setSourceFileMetadata(args.getTeamRepository(), args.getStreamId(), args.getComponentId(), args.fileItemId, metadata, progressMonitor);
    }

    public static void setSourceFileMetadata(ITeamRepository repo, String streamId, String componentId, String fileItemId, TransportFile metadata, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IMetadataCollectionClient client = ClientFactory.getMetadataCollectionClient(repo);
        ArrayList<TransportFile> fileList = new ArrayList<TransportFile>();
        fileList.add(metadata);
        String metadataString = null;
        try {
            metadataString = TransportUtil.toXML(fileList);
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        client.setSourceFileMetadata(streamId, componentId, fileItemId, metadataString, progressMonitor);
    }

    public static String getSlug(String itemId) {
        StringBuffer slugBuffer = new StringBuffer();
        slugBuffer.append("_itemId=");
        slugBuffer.append(itemId);
        return slugBuffer.toString();
    }

    private static IWorkspaceHandle getWorkspaceHandle(IShareable share) throws FileSystemException {
        IShare s = share.getShare((IProgressMonitor)new NullProgressMonitor());
        ISharingDescriptor desc = s.getSharingDescriptor();
        return (IWorkspaceHandle)desc.getConnectionHandle();
    }

    private static IWorkspace getWorkspaceStream(IWorkspace workspace, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, (IProgressMonitor)new NullProgressMonitor())).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }

    public static MetadataClientArgs getMetadataClientArgs(IFile file) throws TeamRepositoryException {
        if (file != null && ZComponentUtils.isShared((IAdaptable)file)) {
            IShareable shareable = ZComponentUtils.getSharable((IResource)file);
            return MetadataCollectionUtils.getMetadataClientArgs(shareable);
        }
        return null;
    }

    public static MetadataClientArgs getMetadataClientArgs(IShareable shareable) throws TeamRepositoryException {
        ITeamRepository repo = ZComponentUtils.getTeamRepository((IShareable)shareable);
        if (repo != null && repo.loggedIn()) {
            IWorkspaceHandle workspaceHandle = MetadataCollectionUtils.getWorkspaceHandle(shareable);
            IWorkspace workspace = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, (IProgressMonitor)new NullProgressMonitor());
            IWorkspace stream = MetadataCollectionUtils.getWorkspaceStream(workspace, repo);
            if (stream == null) {
                throw new TeamRepositoryException("No stream could be found");
            }
            IShare share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
            ISharingDescriptor desc = share.getSharingDescriptor();
            SharingDescriptor sd = (SharingDescriptor)desc;
            IVersionableHandle vh = shareable.getVersionable((IProgressMonitor)new NullProgressMonitor());
            if (vh != null) {
                MetadataClientArgs args = new MetadataClientArgs();
                args.setStreamId(stream.getItemId().getUuidValue());
                args.setComponentId(sd.getComponent().getItemId().getUuidValue());
                args.setFileItemId(vh.getItemId().getUuidValue());
                if (vh.getStateId() != null) {
                    args.setFileStateId(vh.getStateId().getUuidValue());
                }
                args.setTeamRepository(repo);
                return args;
            }
        }
        return null;
    }

    public static class MetadataClientArgs {
        private String fileItemId;
        private String fileStateId;
        private String streamId;
        private String componentId;
        private ITeamRepository teamRepository;

        public String getFileItemId() {
            return this.fileItemId;
        }

        public void setFileItemId(String fileItemId) {
            this.fileItemId = fileItemId;
        }

        public String getStreamId() {
            return this.streamId;
        }

        public void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        public ITeamRepository getTeamRepository() {
            return this.teamRepository;
        }

        public void setTeamRepository(ITeamRepository teamRepository) {
            this.teamRepository = teamRepository;
        }

        public String getFileStateId() {
            return this.fileStateId;
        }

        public void setFileStateId(String fileStateId) {
            this.fileStateId = fileStateId;
        }
    }
}

