/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.metadata.client.scanner;

import com.ibm.team.enterprise.internal.metadata.client.scanner.FileMetadataScannerInfo;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.common.scanner.IMetadataValueType;
import com.ibm.team.enterprise.metadata.scanner.common.service.IMetadataScannerService;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;

public class MetadataScannerClientLibrary
implements IMetadataScannerClientLibrary {
    private final IClientLibraryContext context;

    public MetadataScannerClientLibrary(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.context = context;
    }

    private IMetadataScannerService getService() throws TeamRepositoryException {
        IMetadataScannerService service = (IMetadataScannerService)this.context.getServiceInterface(IMetadataScannerService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get IMetadataParserService");
        }
        return service;
    }

    @Override
    public IFileMetadataScanner[] getAllMetadataScanners() throws TeamRepositoryException {
        String jsonString = this.getService().getAllMetadataScannerInfos();
        try {
            JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanners(jsonArray);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IFileMetadataScanner[] getMetadataScannerByCategories(String[] categories) throws TeamRepositoryException {
        String jsonString = this.getService().getMetadataScannerInfoByCategories(categories);
        try {
            JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanners(jsonArray);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IFileMetadataScanner getDefaultMetadataScanner() throws TeamRepositoryException {
        String jsonString = this.getService().getDefaultMetadataScannerInfo();
        try {
            JSONObject map = JSONObject.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanner(map);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IFileMetadataScanner getDefaultMetadataScanner(IMetadataScannerService.Platform platform) throws TeamRepositoryException {
        String jsonString = this.getService().getDefaultMetadataScannerInfo2(platform.name());
        try {
            JSONObject map = JSONObject.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanner(map);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IFileMetadataScanner getMetadataScanner(String id) throws TeamRepositoryException {
        String jsonString = this.getService().getMetadataScannerInfo(id);
        if (jsonString == null) {
            return null;
        }
        try {
            JSONObject map = JSONObject.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanner(map);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public IFileMetadataScanner[] getMetadataScanner(String[] ids) throws TeamRepositoryException {
        String jsonString = this.getService().getMetadataScannerInfos(ids);
        try {
            JSONArray jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
            return this.toFileMetadataScanners(jsonArray);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private IFileMetadataScanner[] toFileMetadataScanners(JSONArray jsonArray) {
        IFileMetadataScanner[] scanners = new IFileMetadataScanner[jsonArray.size()];
        int i = 0;
        while (i < scanners.length) {
            scanners[i] = this.toFileMetadataScanner((JSONObject)jsonArray.get(i));
            ++i;
        }
        return scanners;
    }

    private IFileMetadataScanner toFileMetadataScanner(JSONObject map) {
        String name = (String)map.get((Object)"name");
        String label = (String)map.get((Object)"label");
        String classname = (String)map.get((Object)"classname");
        String type = (String)map.get((Object)"type");
        String excludeFiles = (String)map.get((Object)"excludeFiles");
        String namespace = (String)map.get((Object)"namespace");
        String dependencyTypes = (String)map.get((Object)"dependencyTypes");
        String categories = (String)map.get((Object)"categories");
        FileMetadataScannerInfo info = new FileMetadataScannerInfo(name, label, classname, type, excludeFiles, namespace, dependencyTypes, categories);
        JSONArray generalTypes = (JSONArray)map.get((Object)"generalTypes");
        if (generalTypes != null) {
            HashMap<String, IMetadataValueType> metadataValueTypes = new HashMap<String, IMetadataValueType>();
            int i = 0;
            while (i < generalTypes.size()) {
                JSONObject obj = (JSONObject)generalTypes.get(i);
                String id = (String)obj.get((Object)"generalTypeId");
                String metadataValueType = (String)obj.get((Object)"generalTypeValue");
                metadataValueTypes.put(id, IMetadataValueType.valueOf((String)metadataValueType));
                ++i;
            }
            info.setGeneralMetadataTypes(metadataValueTypes);
        }
        return info;
    }
}

