/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.metadata.client.scanner;

import com.ibm.team.enterprise.common.common.utils.StringMatcher;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.common.scanner.IMetadataValueType;
import com.ibm.team.enterprise.metadata.common.scanner.IPropertyProvider;
import com.ibm.team.enterprise.metadata.common.scanner.IScannerData;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FileMetadataScannerInfo
implements IFileMetadataScanner {
    protected String excludeFiles;
    protected String name;
    protected String label;
    protected String classname;
    protected String type;
    protected String namespace;
    protected String category;
    protected String dependencyTypes;
    protected Map<String, IMetadataValueType> metadataValueTypeMap;

    public FileMetadataScannerInfo(String name, String label, String classname, String type, String excludeFiles, String namespace, String dependencyTypes, String category) {
        this.name = name;
        this.label = label;
        this.classname = classname;
        this.type = type;
        this.excludeFiles = excludeFiles;
        this.namespace = namespace;
        this.dependencyTypes = dependencyTypes;
        this.category = category;
    }

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(String excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDependencyTypes() {
        return this.dependencyTypes;
    }

    public void setDependencyTypes(String dependencyTypes) {
        this.dependencyTypes = dependencyTypes;
    }

    public boolean accept(String fileName) {
        if (this.excludeFiles != null) {
            StringTokenizer st = new StringTokenizer(this.excludeFiles, ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                StringMatcher matcher = new StringMatcher(str, false, false);
                if (!matcher.match(fileName)) continue;
                return false;
            }
        }
        return true;
    }

    public IScannerData scan(InputStream fileContent, Map<String, String> properties) throws Exception {
        return null;
    }

    public IPropertyProvider getPropertyProvider() {
        return null;
    }

    public void setPropertyProviderClass(IPropertyProvider propertyProvider) {
    }

    public void setGeneralMetadataTypes(Map<String, IMetadataValueType> map) {
        if (map != null) {
            this.metadataValueTypeMap = new HashMap<String, IMetadataValueType>();
            this.metadataValueTypeMap.putAll(map);
        }
    }

    public Map<String, IMetadataValueType> getGeneralMetadataTypes() {
        return this.metadataValueTypeMap;
    }
}

