/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.metadata.client.query;

import com.ibm.team.enterprise.internal.metadata.client.query.nls.Messages;
import com.ibm.team.enterprise.metadata.client.query.IMetadataQueryClient;
import com.ibm.team.enterprise.metadata.common.query.IScdQueryDescriptor;
import com.ibm.team.enterprise.metadata.common.query.util.RdfXmlConverter2;
import com.ibm.team.enterprise.metadata.common.query.util.Util;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.enterprise.metadata.query.common.IMetadataQuery;
import com.ibm.team.enterprise.metadata.query.common.service.IQueryService;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MetadataQueryClient
implements IMetadataQueryClient {
    private final IClientLibraryContext context;
    private String content;

    private String getContent() {
        return this.content;
    }

    private void setContent(String content) {
        this.content = content;
    }

    public MetadataQueryClient(IClientLibraryContext context) {
        this.context = context;
    }

    @Override
    public IMetadataQuery getMetadataQuery(final IProjectAreaHandle projectArea, final String name, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IMetadataQuery)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IMetadataQuery>(){

            public IMetadataQuery run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                MetadataQueryClient.this.fetchtContentInBackground(projectArea.getItemId().getUuidValue(), name);
                return RdfXmlConverter2.toMetadataQuery((String)MetadataQueryClient.this.getContent());
            }
        });
    }

    protected void fetchtContentInBackground(final String uuidValue, final String name) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    MetadataQueryClient.this.setContent(MetadataQueryClient.this.getService().getQuery(uuidValue, name));
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveMetadataQuery(final IMetadataQuery query, final boolean overwrite, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                String rdfxml = RdfXmlConverter2.toRdfXml((IMetadataQuery)query);
                return MetadataQueryClient.this.getService().saveQuery(rdfxml, overwrite);
            }
        });
    }

    @Override
    public void modifyMetadataQuery(final IMetadataQuery query, final String oldName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                String rdfxml = RdfXmlConverter2.toRdfXml((IMetadataQuery)query);
                return MetadataQueryClient.this.getService().modifyQuery(rdfxml, oldName);
            }
        });
    }

    @Override
    public IMetadataQuery duplicateMetadataQuery(final IProjectAreaHandle projectArea, final String oldName, final String newName, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IMetadataQuery)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IMetadataQuery>(){

            public IMetadataQuery run(IProgressMonitor monitor) throws TeamRepositoryException {
                IMetadataQuery query;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if ((query = MetadataQueryClient.this.getMetadataQuery(projectArea, oldName, monitor)) == null) {
                    throw new TeamRepositoryException((Throwable)new NullPointerException());
                }
                IMetadataQuery newQuery = query.newMetadataQuery();
                newQuery.setName(newName);
                return newQuery;
            }
        });
    }

    @Override
    public IMetadataQuery saveCopy(final IMetadataQuery query, final String newName, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IMetadataQuery)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IMetadataQuery>(){

            public IMetadataQuery run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                IMetadataQuery newQuery = query.newMetadataQuery();
                newQuery.setName(newName);
                MetadataQueryClient.this.saveMetadataQuery(newQuery, false, monitor);
                return newQuery;
            }
        });
    }

    @Override
    public void deleteMetadataQuery(final IProjectAreaHandle projectArea, final String name, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                MetadataQueryClient.this.getService().deleteQuery(projectArea.getItemId().getUuidValue(), name);
                return null;
            }
        });
    }

    @Override
    public void deleteMetadataQueries(final IProjectAreaHandle projectArea, final String[] names, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                MetadataQueryClient.this.getService().deleteQueries(projectArea.getItemId().getUuidValue(), names);
                return null;
            }
        });
    }

    @Override
    public void renameMetadataQuery(final IProjectAreaHandle projectArea, final String name, final String newName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                MetadataQueryClient.this.getService().renameQuery(projectArea.getItemId().getUuidValue(), name, newName);
                return null;
            }
        });
    }

    @Override
    public IScdQueryDescriptor[] getQueryScdQueryDescriptors(final IProjectAreaHandle projectArea) throws TeamRepositoryException {
        return (IScdQueryDescriptor[])this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable<IScdQueryDescriptor[]>(){

            public IScdQueryDescriptor[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                IScdQueryDescriptor[] queryDescriptors = MetadataQueryClient.this.getService().getQueryDescriptors(projectArea.getItemId().getUuidValue());
                return queryDescriptors;
            }
        });
    }

    @Override
    public List<String> getQueryNames(IProjectAreaHandle projectArea) throws TeamRepositoryException {
        ArrayList<String> queryNames = new ArrayList<String>();
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List results = parser.parse((InputStream)new ByteArrayInputStream(this.getService().runQuery(Util.getQueryNameSparql((String)projectArea.getItemId().getUuidValue())).getBytes("UTF-8")));
            for (SelectResult result : results) {
                List bindings = result.getBindings();
                for (Binding binding : bindings) {
                    if (!binding.getName().equals("queryName")) continue;
                    queryNames.add(binding.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return queryNames;
    }

    @Override
    public List<IAttribute> getCustomAttributes(ITeamRepository repository) throws TeamRepositoryException {
        try {
            this.sleep(500);
            SelectResultFeedParser parser = new SelectResultFeedParser();
            List results = parser.parse((InputStream)new ByteArrayInputStream(this.getService().runQuery(Util.getAttributeSparql()).getBytes("UTF-8")));
            return Util.parseAttributes((List)results, (String)repository.getRepositoryURI());
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public void saveCustomAttribute(final IAttribute attribute, final boolean overwrite, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(Messages.bind((String)Messages.MetadataQueryClient_saveCustomAttributeProgressLabel, (Object)attribute.getDisplayName()));
                String rdfxml = RdfXmlConverter2.toRdfXml((IAttribute)attribute);
                MetadataQueryClient.this.getService().saveAttribute(rdfxml, overwrite);
                return null;
            }
        });
    }

    @Override
    public void saveCustomAttributes(List<IAttribute> attributes, boolean overwrite, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(Messages.MetadataQueryClient_saveCustomAttributesProgressLabel);
        String[] rdfxml = new String[attributes.size()];
        int index = 0;
        for (IAttribute attribute : attributes) {
            rdfxml[index++] = RdfXmlConverter2.toRdfXml((IAttribute)attribute);
        }
        this.getService().saveAttributes(rdfxml, overwrite);
    }

    @Override
    public void modifyCustomAttribute(final IAttribute attribute, final String oldId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(Messages.bind((String)Messages.MetadataQueryClient_saveCustomAttributeProgressLabel, (Object)attribute.getDisplayName()));
                String rdfxml = RdfXmlConverter2.toRdfXml((IAttribute)attribute);
                MetadataQueryClient.this.getService().modifyAttribute(rdfxml, oldId);
                return null;
            }
        });
    }

    @Override
    public void deleteCustomAttribute(final String id, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(Messages.MetadataQueryClient_deleteCustomAttributesProgressLabel);
                MetadataQueryClient.this.getService().deleteAttribute(id);
                return null;
            }
        });
    }

    @Override
    public void deleteCustomAttributes(final String[] ids, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(Messages.MetadataQueryClient_deleteCustomAttributesProgressLabel);
                MetadataQueryClient.this.getService().deleteAttributes(ids);
                return null;
            }
        });
    }

    protected ITeamRepository getRepository() {
        return this.context.teamRepository();
    }

    protected IQueryService getService() throws TeamRepositoryException {
        IQueryService service = (IQueryService)this.context.getServiceInterface(IQueryService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get IQueryService");
        }
        return service;
    }

    protected String runQuery(String sparql) throws TeamRepositoryException {
        return this.getService().runQuery(sparql);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable<?> serviceRunnable) throws TeamRepositoryException {
        return this.context.callCancelableService(serviceRunnable, progressMonitor);
    }

    private void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int getMaxReturnedResults() {
        try {
            return this.getService().getMaxReturnedResults();
        }
        catch (TeamRepositoryException e) {
            return -1;
        }
    }
}

