/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.metadata.client.collection;

import com.ibm.team.enterprise.metadata.client.collection.IMetadataCollectionClient;
import com.ibm.team.enterprise.metadata.collection.common.service.IMetadataCollectionService;
import com.ibm.team.enterprise.metadata.common.collection.helper.StreamScanningStatusInfo;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class MetadataCollectionClient
extends EventSource
implements IMetadataCollectionClient {
    private final IClientLibraryContext fContext;

    public MetadataCollectionClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    @Override
    public String getSourceFileMetadata(final String streamUUID, final String componentUUID, final String fileItemUUID, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String metadataString = (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String result = MetadataCollectionClient.this.getService().getSourceFileMetadata(streamUUID, componentUUID, fileItemUUID);
                return result;
            }
        });
        return metadataString;
    }

    @Override
    public void setSourceFileMetadata(final String streamUUID, final String componentUUID, final String fileItemUUID, final String metadataString, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                MetadataCollectionClient.this.getService().setSourceFileMetadata(streamUUID, componentUUID, fileItemUUID, metadataString);
                return null;
            }
        });
    }

    @Override
    public String reset2(final String[] streamUUIDs, final int resetType, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String resetId = (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String result = MetadataCollectionClient.this.getService().reset2(streamUUIDs, resetType);
                return result;
            }
        });
        return resetId;
    }

    @Override
    public String update(final String[] streamUUIDs, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String updateId = (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String result = MetadataCollectionClient.this.getService().update(streamUUIDs);
                return result;
            }
        });
        return updateId;
    }

    @Override
    public String[] getResetOrUpdateStatus(final String resetId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String[] messages = (String[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] result = MetadataCollectionClient.this.getService().getResetOrUpdateStatus(resetId);
                return result;
            }
        });
        return messages;
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public void updateAllMetadata(IProgressMonitor progressMonitor) {
        try {
            this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    MetadataCollectionClient.this.getService().updateAllMetadata();
                    return null;
                }
            });
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    @Override
    public String getScanningStatusForStreams(final IProjectAreaHandle projectHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        String jsonString = (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String result = MetadataCollectionClient.this.getService(IMetadataCollectionService.class).getScanningStatusForStreams(projectHandle);
                return result;
            }
        });
        return jsonString;
    }

    @Override
    public void updateScanningStatusForStreams(final String jsonString, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                MetadataCollectionClient.this.getService(IMetadataCollectionService.class).updateScanningStatusForStreams(jsonString);
                return null;
            }
        });
    }

    protected IMetadataCollectionService getService() {
        return this.getService(IMetadataCollectionService.class);
    }

    @Override
    public void updateMetadata(final IWorkspaceHandle[] streams, final boolean force) throws Exception {
        try {
            this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        MetadataCollectionClient.this.getService().updateMetadata(streams, force);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    @Override
    public boolean isScanningSet(IWorkspace stream) {
        return Boolean.parseBoolean((String)stream.getProperties().get("team.enterprise.scan.stream"));
    }

    @Override
    public void setScanningStatus(IWorkspace stream, boolean status, IProgressMonitor monitor) throws TeamRepositoryException {
        Map scanningStatusStreamMap;
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)stream.getOwner();
        String jsonString = this.getScanningStatusForStreams(projectAreaHandle, monitor);
        JSONArray jsonArray = null;
        try {
            jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        Object scanningStatusStreamMaps = jsonArray;
        boolean dirty = false;
        String targetStreamUuid = stream.getItemId().getUuidValue();
        if (scanningStatusStreamMaps == null) {
            if (status) {
                scanningStatusStreamMaps = new ArrayList(1);
                HashMap<String, String> scanningStatusStreamMap2 = new HashMap<String, String>();
                scanningStatusStreamMap2.put("UUID", targetStreamUuid);
                scanningStatusStreamMap2.put("name", stream.getName());
                scanningStatusStreamMap2.put("scanFlag", Boolean.TRUE.toString());
                scanningStatusStreamMaps.add(scanningStatusStreamMap2);
                dirty = true;
            }
        } else {
            int size = scanningStatusStreamMaps.size();
            int i = 0;
            while (i < size) {
                scanningStatusStreamMap = (Map)scanningStatusStreamMaps.get(i);
                if (((String)scanningStatusStreamMap.get("UUID")).equals(targetStreamUuid)) {
                    boolean scanFlag = Boolean.parseBoolean((String)scanningStatusStreamMap.get("scanFlag"));
                    if (scanFlag == status) break;
                    scanningStatusStreamMap.put("scanFlag", Boolean.toString(status));
                    dirty = true;
                    break;
                }
                ++i;
            }
        }
        if (dirty) {
            JSONArray resultJsonArray = new JSONArray();
            Iterator iterator = scanningStatusStreamMaps.iterator();
            while (iterator.hasNext()) {
                scanningStatusStreamMap = (Map)iterator.next();
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll(scanningStatusStreamMap);
                resultJsonArray.add((Object)jsonObject);
            }
            this.updateScanningStatusForStreams(resultJsonArray.toString(), monitor);
        }
    }

    @Override
    public List<StreamScanningStatusInfo> getStreamScanningStatusInfos(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        String jsonString = this.getScanningStatusForStreams(projectAreaHandle, monitor);
        try {
            JSONArray jsonArray;
            JSONArray scanningStatusStreamMaps = jsonArray = JSONArray.parse((Reader)new StringReader(jsonString));
            ArrayList<StreamScanningStatusInfo> scanningStatusInfos = new ArrayList<StreamScanningStatusInfo>();
            for (Map scanningStatusStreamMap : scanningStatusStreamMaps) {
                UUID uuid = UUID.valueOf((String)((String)scanningStatusStreamMap.get("UUID")));
                String name = (String)scanningStatusStreamMap.get("name");
                boolean scanFlag = Boolean.parseBoolean((String)scanningStatusStreamMap.get("scanFlag"));
                scanningStatusInfos.add(new StreamScanningStatusInfo(uuid, name, scanFlag));
            }
            return scanningStatusInfos;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public void updateStreamScanningStatusInfos(List<StreamScanningStatusInfo> scanningStatusInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> map = new HashMap<String, String>();
        for (StreamScanningStatusInfo scanningStatusInfo : scanningStatusInfos) {
            map.clear();
            map.put("UUID", scanningStatusInfo.getStreamUUID().getUuidValue());
            map.put("name", scanningStatusInfo.getStreamName());
            map.put("scanFlag", Boolean.toString(scanningStatusInfo.isSetForScanning()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(map);
            jsonArray.add((Object)jsonObject);
        }
        this.updateScanningStatusForStreams(jsonArray.toString(), monitor);
    }
}

