/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPathHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SearchPathSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchPathEntryDialog
extends TitleAreaDialog {
    protected String fTitle;
    protected Text fSearchPathText;
    protected Text fPropertyText;
    private Button fBrowseButton;
    protected Button fSearchPathEntryKindButtonSearchPath;
    protected Button fSearchPathEntryKindButtonProperty;
    protected String fSearchPath;
    protected String fSearchPathName;
    protected String fSearchPathUUID;
    private final String SEARCH_PATH_BUILD_PROPERTY = "${com.ibm.team.enterprise.ibmi.build.searchPath}";
    protected ITeamRepository fTeamRepository;
    protected IProjectAreaHandle fProjectArea;
    protected boolean fIsNew;
    protected Shell fParentShell;
    protected Composite fComposite;

    public SearchPathEntryDialog(Shell parentShell, String title, String searchPath, ITeamRepository repo, IProjectAreaHandle projectArea) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fSearchPath = searchPath;
        this.fTeamRepository = repo;
        this.fProjectArea = projectArea;
        if (this.isValidUUID(this.fSearchPath)) {
            try {
                IIBMiSearchPathHandle handle = (IIBMiSearchPathHandle)IIBMiSearchPath.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fSearchPath), null);
                ISystemDefinition sysDef = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.fTeamRepository).fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY), null);
                if (sysDef != null) {
                    this.fSearchPathName = sysDef.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled((this.fSearchPathEntryKindButtonSearchPath.getSelection() || this.fSearchPathEntryKindButtonProperty.getSelection()) && errorMessage == null);
    }

    protected Control createDialogArea(Composite parent) {
        this.fComposite = (Composite)super.createDialogArea(parent);
        this.fComposite.setLayout((Layout)new GridLayout(2, false));
        this.setTitle(this.fTitle);
        this.setMessage(Messages.SearchPathEntryDialog_Description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.fSearchPathEntryKindButtonSearchPath = this.createKindRadioButton(this.fComposite, Messages.SearchPathEntryDialog_SearchPathLabel, 16400);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fSearchPathEntryKindButtonSearchPath.setLayoutData((Object)gridData);
        this.fSearchPathText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fSearchPathText.setLayoutData((Object)gridData);
        this.fSearchPathText.setEditable(false);
        this.fBrowseButton = new Button(this.fComposite, 0);
        this.fBrowseButton.setText(Messages.TranslatorEntryDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
        this.fBrowseButton.setEnabled(false);
        this.fSearchPathEntryKindButtonProperty = this.createKindRadioButton(this.fComposite, Messages.TranslatorEntryDialog_KIND_SUB_PARAM, 16400);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fSearchPathEntryKindButtonProperty.setLayoutData((Object)gridData);
        this.fPropertyText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fPropertyText.setLayoutData((Object)gridData);
        this.fPropertyText.setEnabled(false);
        this.fPropertyText.setEditable(false);
        SearchPathEntryKind kind = this.getSearchPathEntryKind();
        if (kind == null) {
            this.fSearchPathEntryKindButtonSearchPath.setSelection(true);
            this.fSearchPathEntryKindButtonSearchPath.setFocus();
        } else if (kind.equals((Object)SearchPathEntryKind.searchPath)) {
            this.fSearchPathEntryKindButtonSearchPath.setSelection(true);
            if (this.fSearchPathName != null) {
                this.fSearchPathText.setText(this.fSearchPathName);
            }
            this.fBrowseButton.setFocus();
        } else if (kind.equals((Object)SearchPathEntryKind.property)) {
            this.fSearchPathEntryKindButtonProperty.setSelection(true);
            if (this.fSearchPath != null) {
                this.fPropertyText.setText(this.fSearchPath);
            }
            this.fPropertyText.setFocus();
            this.fPropertyText.selectAll();
        }
        this.updateControlEnablement();
        this.fPropertyText.addModifyListener(this.getPropertyModifiedListener());
        SearchPathEntryDialog.applyDialogFont((Control)this.fComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, null);
        return this.fComposite;
    }

    private Button createKindRadioButton(Composite parent, String text, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPathEntryDialog.this.updateControlEnablement();
                SearchPathEntryDialog.this.updateSearchPathValue();
                SearchPathEntryDialog.this.validate(false);
            }
        });
        return radioButton;
    }

    private void updateControlEnablement() {
        this.fSearchPathText.setEnabled(this.fSearchPathEntryKindButtonSearchPath.getSelection());
        this.fPropertyText.setEnabled(this.fSearchPathEntryKindButtonProperty.getSelection());
        this.fPropertyText.setEditable(this.fSearchPathEntryKindButtonProperty.getSelection());
        this.fBrowseButton.setEnabled(this.fSearchPathEntryKindButtonSearchPath.getSelection());
    }

    private void updateSearchPathValue() {
        this.validate(false);
        if (this.fSearchPathEntryKindButtonProperty.getSelection()) {
            if (AbstractSystemDefinitionEditor.isValidBuildProperty((String)this.fPropertyText.getText().trim())) {
                this.fSearchPath = this.fPropertyText.getText().trim();
            }
        } else if (this.fSearchPathEntryKindButtonSearchPath.getSelection()) {
            if (this.isValidUUID(this.fSearchPath)) {
                this.fSearchPathUUID = this.fSearchPath;
            } else {
                this.fSearchPath = this.fSearchPathUUID;
            }
        }
    }

    private ModifyListener getPropertyModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPathEntryDialog.this.updateSearchPathValue();
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public String getErrorMessage() {
        if (this.fSearchPathEntryKindButtonSearchPath.getSelection()) {
            String value = this.fSearchPathText.getText().trim();
            if (value == null || value.equals("")) {
                return Messages.SearchPathEntryDialog_ErrorSearchPathRequired;
            }
            return null;
        }
        if (this.fSearchPathEntryKindButtonProperty.getSelection()) {
            String value = this.fPropertyText.getText().trim();
            if (value == null || value.equals("")) {
                return Messages.TranslatorEntryDialog_PROPERTY_REQUIRED;
            }
            if (value.indexOf(32) > -1) {
                return Messages.Common_NO_SPACES_IN_BUILD_PROPERTY;
            }
            if (!AbstractSystemDefinitionEditor.isValidBuildProperty((String)value)) {
                return Messages.Common_INVALID_BUILD_PROPERTY_NAME;
            }
            return null;
        }
        return null;
    }

    private SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPathEntryDialog.this.editSearchPath();
                SearchPathEntryDialog.this.validate(false);
            }
        };
    }

    private void editSearchPath() {
        try {
            ISystemDefinition searchPath;
            SearchPathSelectionDialog dialog = new SearchPathSelectionDialog(this.fComposite.getShell(), this.fTeamRepository, null);
            if (dialog.open() == 0 && (searchPath = dialog.getSelectedSystemDefinition()) != null) {
                this.fSearchPathUUID = this.fSearchPath = searchPath.getItemId().getUuidValue();
                this.fSearchPathText.setText(searchPath.getName());
                this.fSearchPathName = searchPath.getName();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private SearchPathEntryKind getSearchPathEntryKind() {
        if (this.fSearchPath == null || this.fSearchPath.isEmpty() || this.fSearchPath.equals("${com.ibm.team.enterprise.ibmi.build.searchPath}")) {
            return null;
        }
        if (AbstractSystemDefinitionEditor.isValidBuildProperty((String)this.fSearchPath)) {
            return SearchPathEntryKind.property;
        }
        if (this.isValidUUID(this.fSearchPath)) {
            return SearchPathEntryKind.searchPath;
        }
        return null;
    }

    private boolean isValidUUID(String uuid) {
        try {
            UUID.valueOf((String)this.fSearchPath);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getSearchPathEntryValue() {
        return this.fSearchPath;
    }

    private String getContextHelpId() {
        return "com.ibm.team.build.ui.dialog_searchpathentryselection";
    }

    private static enum SearchPathEntryKind {
        searchPath,
        property;

    }
}

