/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionContext;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.LangDefJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class ResourceDefinitionLabelHelper {
    public void labelAvailable(String label, String resourceDefUUID) {
    }

    public void getResourceDefinitionLabelInBackground(final ISystemDefinitionContext context) {
        LangDefJob job = new LangDefJob(com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages.ResourceDefinitionLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String resourceDefUuid;
                String label = resourceDefUuid = context.getSystemDefinitionUUID();
                if (resourceDefUuid.length() > 0) {
                    ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)context.getTeamRepository());
                    IIBMiResourceDefinitionHandle handle = (IIBMiResourceDefinitionHandle)IIBMiResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)resourceDefUuid), null);
                    IResourceDefinition resourceDef = (IResourceDefinition)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY, ISystemDefinition.ARCHIVED_PROPERTY), monitor);
                    label = resourceDef.getName();
                    if (resourceDef.isArchived()) {
                        label = String.valueOf(label) + Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                }
                ResourceDefinitionLabelHelper.this.asyncLabelAvailable(label, resourceDefUuid);
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException || status.getException() instanceof NullPointerException) {
                    ResourceDefinitionLabelHelper.this.asyncLabelAvailable(com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages.LabelHelper_MissingLibrary, context.getSystemDefinitionUUID());
                } else if (status.getSeverity() == 4) {
                    ResourceDefinitionLabelHelper.this.asyncLabelAvailable(com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages.LabelHelper_EXCEPTION_OCCURRED, context.getSystemDefinitionUUID());
                }
            }
        };
        job.schedule();
    }

    protected void asyncLabelAvailable(final String label, final String resourceDefUUID) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceDefinitionLabelHelper.this.labelAvailable(label, resourceDefUUID);
            }
        });
    }
}

