/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.wizards;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.ResourceDefinitionEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.wizards.Messages;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.wizards.ResourceDefinitionTypeSelectionPage;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractSystemDefinitionWizard;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewResourceDefinitionWizard
extends AbstractSystemDefinitionWizard
implements ISystemDefinitionWizard {
    private ResourceDefinitionTypeSelectionPage fResourceTypeSelectionPage;
    private int resourceDefinitionType = 1;

    protected IWizardPage getResourceTypeSelectionPage() {
        if (this.fResourceTypeSelectionPage == null) {
            this.fResourceTypeSelectionPage = new ResourceDefinitionTypeSelectionPage(Messages.NewResourceDefinitionWizard_0, Messages.NewResourceDefinitionWizard_1, false);
        }
        return this.fResourceTypeSelectionPage;
    }

    public void setResourceDefinitionType(int resourceDefinitionType) {
        this.resourceDefinitionType = resourceDefinitionType;
    }

    private Action getNewResourceDefinitionAction(final IProjectAreaHandle projArea) {
        return new Action(Messages.NewResourceDefinitionWizard_2){

            public void run() {
                IWorkbenchPage fPage = NewResourceDefinitionWizard.this.getWorkbenchPage();
                if (fPage != null) {
                    try {
                        EnterpriseExtensionsDomainRegistry eeRegistry = EnterpriseExtensionsDomainRegistry.getInstance();
                        AbstractEnterpriseExtensionsNode parentNode = (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projArea, "SystemDefinitions/POS/ResourceDefinitions");
                        ResourceDefinitionEditorInput input = new ResourceDefinitionEditorInput(null, NewResourceDefinitionWizard.this.resourceDefinitionType, projArea, parentNode);
                        fPage.openEditor((IEditorInput)input, "com.ibm.team.enterprise.ibmi.systemdefinition.ui.editors.resourceDefinitionEditor");
                    }
                    catch (PartInitException exception) {
                        DefUIPlugin.log(exception);
                    }
                    catch (TeamRepositoryException exception) {
                        DefUIPlugin.log(exception);
                    }
                }
            }

            public String getId() {
                return "new.resource.definition";
            }
        };
    }

    protected String getDefinitionPluginID() {
        return DefUIPlugin.getUniqueIdentifier();
    }

    protected Action getDefinitionWizardAction(IProjectAreaHandle projectArea) {
        return this.getNewResourceDefinitionAction(projectArea);
    }

    protected String getDefinitionWizardImagePath() {
        return "icons/wizban/libdef_wiz.gif";
    }

    protected IWizardPage[] getDefinitionWizardPages() {
        return new IWizardPage[]{this.getProjectAreaSelectionPage(), this.getResourceTypeSelectionPage()};
    }

    protected String getDefinitionWizardTitle() {
        return Messages.NewResourceDefinitionWizard_6;
    }
}

