/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.helper;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPathHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.ibmi.IBMiSystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.helper.SystemDefHistoryHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;

public class IBMiSystemDefHistoryHelper
extends SystemDefHistoryHelper {
    static {
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_INTROSPECTION_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_INTROSPECTION);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_TYPE_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_OBJECTTYPE);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_OUTPUT_KIND);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_PATTERNORVARIABLE);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_SEARCHPATH);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_EXISTS_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_COMMAND_OBJECT_EXITS);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_IS_SAME_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_IS_SAME_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_COMMAND_IS_SAME);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ITRANSLATOR_COMMAND_OBJECT_DOESNT_EXIST_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_IBMITRANSLATOR_COMMAND_OBJECT_NOTEXITS);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ISEARCHPATH_LIBRARY_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ISEARCHPATH_LIBRARY_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_Library);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ISEARCHPATH_REFERENCED_LIBRARY_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ISEARCHPATH_REFERENCED_LIBRARY_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_Referenced_Library);
        }
        if (!tagsToLabels.containsKey(IBMiSystemDefinitionUtil.ISEARCHPATH_OBJECT_LIBRARY_TAG.getWholeTagName())) {
            tagsToLabels.put(IBMiSystemDefinitionUtil.ISEARCHPATH_OBJECT_LIBRARY_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_Object_Library);
        }
    }

    public IBMiSystemDefHistoryHelper(ISystemDefinitionCache systemDefinitionCache, ITeamRepository repository) {
        super(systemDefinitionCache, repository);
    }

    protected String getLanguageCodesLabel(String value) {
        String result = null;
        if (value == null || value.length() == 0) {
            return result;
        }
        if ("CLLE".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_CL_ILE;
        } else if ("CL".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_CL_OPM;
        } else if ("COB".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_COBOL;
        } else if ("DSPF".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_DSPF;
        } else if ("LF".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_LF;
        } else if ("OTH".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_OTHER;
        } else if ("PF".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PF;
        } else if ("PGM".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PGM;
        } else if ("PRTF".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PRTF;
        } else if ("RPGLE".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_RPG_ILE;
        } else if ("SRVPGM".equals(value)) {
            result = Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_SRVPGM;
        }
        return result;
    }

    protected void generateClientHTMLContent(StringBuilder htmlBuilder, DeltaType type, String id, String oldValue, String newValue) throws TeamRepositoryException {
        super.generateClientHTMLContent(htmlBuilder, type, id, oldValue, newValue);
        if (IBMiSystemDefinitionUtil.ITRANSLATOR_OUTPUT_NAME_KIND_TAG.getWholeTagName().equals(id)) {
            this.generateValuesContent(htmlBuilder, this.getOutputKindLabel(oldValue), this.getOutputKindLabel(newValue), type, null, null);
        } else if (IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName().equals(id)) {
            this.generateValuesContent(htmlBuilder, this.getSearchPath(oldValue), this.getSearchPath(newValue), type, null, null);
        }
    }

    private String getSearchPath(String value) throws TeamRepositoryException {
        String result = null;
        if (value == null || value.length() == 0) {
            return result;
        }
        result = value.startsWith("${") && value.endsWith("}") ? value : this.getReferenceObjectName(IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName(), value);
        return result;
    }

    protected String getReferenceObjectName(String id, String uuid) throws TeamRepositoryException {
        String result = super.getReferenceObjectName(id, uuid);
        if (result == null && this.sysDefCache != null) {
            ISearchPathHandle handle;
            ISystemDefinition sysDef = null;
            if (IBMiSystemDefinitionUtil.ITRANSLATOR_SEARCH_PATH_TAG.getWholeTagName().equals(id)) {
                handle = (ISearchPathHandle)ISearchPath.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                sysDef = this.sysDefCache.getSystemDefinition((ISystemDefinitionHandle)handle, null);
            }
            if (IBMiSystemDefinitionUtil.ISEARCHPATH_OBJECT_LIBRARY_TAG.getWholeTagName().equals(id) || IBMiSystemDefinitionUtil.ISEARCHPATH_REFERENCED_LIBRARY_TAG.getWholeTagName().equals(id)) {
                handle = (IResourceDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                sysDef = this.sysDefCache.getSystemDefinition((ISystemDefinitionHandle)handle, null);
            }
            if (sysDef != null) {
                result = sysDef.getName();
            }
        }
        return result;
    }

    private String getOutputKindLabel(String value) {
        String result = null;
        if (value == null || value.length() == 0) {
            return result;
        }
        if (OutputNameKind.SAME_AS_INPUT_LITERAL.toString().equals(value)) {
            result = Messages.SystemDefinitionHistory_IBMITRANSLATOR_OUTPUT_KIND_SAME;
        } else if (OutputNameKind.USE_PATTERN_LITERAL.toString().equals(value)) {
            result = Messages.SystemDefinitionHistory_IBMITRANSLATOR_OUTPUT_KIND_PATTERN;
        } else if (OutputNameKind.USE_VARIABLE_LITERAL.toString().equals(value)) {
            result = Messages.SystemDefinitionHistory_IBMITRANSLATOR_OUTPUT_KIND_VARIABLE;
        }
        return result;
    }
}

