/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.IBMiTranslatorValidator;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs.SearchPathEntryDialog;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.client.SystemDefinitionHandleCache;
import com.ibm.team.enterprise.systemdefinition.common.MemberNamePattern;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPathHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.VariableUtils;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.CreateVariableDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class TranslatorEditorGeneralPage
extends AbstractSystemDefinitionEditorPage {
    private IIBMiTranslator fTranslatorWorkingCopy;
    private FormToolkit fToolkit;
    private Section fGeneralSection;
    private Section fVariablesSection;
    private Section fCommandSection;
    private Section fOutputsSection;
    private Section fSearchPathSection;
    private Button fIntrospection;
    private Text fDescriptionText;
    private Button fNonImpactingCheckbox;
    private Button fOverrideSearchPathButton;
    private Button fSearchPathBrowseButton;
    private Text fSearchPathText;
    private Label fSearchPathLabel;
    private final String SEARCH_PATH_BUILD_PROPERTY = "${com.ibm.team.enterprise.ibmi.build.searchPath}";
    private String fLastSpecifiedSearchPath;
    private Button fAddVariableButton;
    private Button fRemoveVariableButton;
    private Button fEditVariableButton;
    private TableViewer fVariableTableViewer;
    private Text fExistCommandText;
    private Text fNonExistCommandText;
    private Button fUseSameCommand;
    private Text fObjectNameText;
    private Button fRenameOutputObject;
    private Label fNameLabel;
    private Label fExampleLabel;
    private final String EXAMPLE_OBJECT = "ORDENTR";
    private final char AMPERSAND = (char)38;
    private Combo objTypeCombo;
    private final String[] objTypes = new String[]{"*ALRTBL", "*AUTL", "*BNDDIR", "*CFGL", "*CHTFMT", "*CLD", "*CLS", "*CMD", "*CNNL", "*COSD", "*CSI", "*CSPMAP", "*CSPTBL", "*CTLD", "*CRG", "*CRQD", "*DEVD", "*DOC", "*DTAARA", "*DTAQ", "*EDTD", "*EXITRG", "*FCT", "*FILE", "*FLR", "*FNTTBL", "*FNTSRC", "*FORMDF", "*FTR", "*GSS", "*IMGCLG", "*IPXD", "*JOBD", "*JOBQ", "*JOBSCD", "*JRN", "*JRNRCV", "*LIB", "*LIND", "*LOCALE", "*MEDDFN", "*MENU", "*MODD", "*MODULE", "*MSGF", "*MSGQ", "*MGTCOL", "*M36", "*M36CFG", "*NODL", "*NODGRP", "*NWID", "*NWSD", "*NTBD", "*OUTQ", "*OVL", "*PAGDFN", "*PAGSEG", "*PDG", "*PGM", "*PNLGRP", "*PRDDFN", "*PRDLOD", "*PSFCFG", "*QMFORM", "*QMQRY", "*QRYDFN", "*RCT", "*SBSD", "*SCHIDX", "*SPADCT", "*SQLPKG", "*SQLUDT", "*SRVPGM", "*SVRSTG", "*SSND", "*S36", "*TBL", "*USRIDX", "*USRPRF", "*USRQ", "*USRSPC", "*VLDL", "*WSCST"};
    private Text fDeployTypeText = null;
    private Button fVariableBrowseButton = null;
    private Button fRenameVBrowseButton = null;
    private Button fFailOnErrorButton;
    private Button fFailOnErrorCommandButton;
    private Label fFailOnErrorSeverityLabel;
    private Label fFailOnErrorCommandSeverityLabel;
    protected Combo fFailOnErrorCommandLevelCombo;
    protected Combo fFailOnErrorLevelCombo;

    public TranslatorEditorGeneralPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        if (item instanceof IIBMiTranslator) {
            this.fTranslatorWorkingCopy = (IIBMiTranslator)item;
        }
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        SystemDefinitionHandleCache.getInstance().deleteCache(this.getTeamRepository(), ISearchPath.ITEM_TYPE);
        this.createGeneralSection(parent);
        this.createOutputsSection(parent);
        this.createVariablesSection(parent);
        this.createCommandSection(parent);
        this.createSearchPathSection(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 256);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralSection.setText(Messages.SystemDefinitionEditor_General);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fGeneralSection.setClient((Control)composite);
        Label label = this.fToolkit.createLabel(composite, Messages.TranslatorEditorGeneralPage_DESCRIPTION_LABEL);
        label.setToolTipText(Messages.TranslatorEditorGeneralPage_DESCRIPTION_TOOLTIP);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)label);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fTranslatorWorkingCopy.getDescription(), 2626);
        GridDataFactory.fillDefaults().span(2, -1).hint(-1, 60).grab(true, false).applyTo((Control)this.fDescriptionText);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setDescription(TranslatorEditorGeneralPage.this.fDescriptionText.getText().trim());
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fIntrospection = this.fToolkit.createButton(composite, Messages.TranslatorEditorGeneralPage_IntrospectionButton, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.fIntrospection.setLayoutData((Object)gridData);
        if (this.fTranslatorWorkingCopy != null) {
            this.fIntrospection.setSelection(this.fTranslatorWorkingCopy.isIntrospection());
        }
        this.fIntrospection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy != null) {
                    TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setIntrospection(TranslatorEditorGeneralPage.this.fIntrospection.getSelection());
                }
                TranslatorEditorGeneralPage.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        this.fNonImpactingCheckbox.setToolTipText(Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fNonImpactingCheckbox);
        this.fNonImpactingCheckbox.setSelection(this.fTranslatorWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setNonImpacting(TranslatorEditorGeneralPage.this.fNonImpactingCheckbox.getSelection());
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
    }

    private void createSearchPathSection(Composite parent) {
        this.fSearchPathSection = this.fToolkit.createSection(parent, 384);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fSearchPathSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment((Control)this.fGeneralSection, 10);
        data.right = new FormAttachment(100, 10);
        this.fSearchPathSection.setLayoutData((Object)data);
        this.fSearchPathSection.setLayout((Layout)new GridLayout(1, false));
        this.fSearchPathSection.setText(Messages.TranslatorEditorGeneralPage_SearchPathSectionTitle);
        this.fSearchPathSection.setDescription(Messages.TranslatorEditorGeneralPage_SearchPathSectionDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fSearchPathSection);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fSearchPathSection.setClient((Control)composite);
        this.fOverrideSearchPathButton = this.fToolkit.createButton(composite, Messages.TranslatorEditorGeneralPage_OverrideSearchPathFromBD, 32);
        this.fOverrideSearchPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TranslatorEditorGeneralPage.this.fOverrideSearchPathButton.getSelection()) {
                    TranslatorEditorGeneralPage.this.fLastSpecifiedSearchPath = TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.getSearchPath();
                    TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setSearchPath("${com.ibm.team.enterprise.ibmi.build.searchPath}");
                } else if (!TranslatorEditorGeneralPage.this.fLastSpecifiedSearchPath.equals("${com.ibm.team.enterprise.ibmi.build.searchPath}")) {
                    TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setSearchPath(TranslatorEditorGeneralPage.this.fLastSpecifiedSearchPath);
                }
                TranslatorEditorGeneralPage.this.updateSearchPathButtonEnablement();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.addControlDecorator((Control)this.fOverrideSearchPathButton, Messages.TranslatorEditorGeneralPage_OverrideSearchPathHover, 131072);
        Composite searchPathComposite = this.fToolkit.createComposite(composite);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 15;
        searchPathComposite.setLayoutData((Object)gd);
        searchPathComposite.setLayout((Layout)new GridLayout(3, false));
        this.fSearchPathLabel = this.createLabel(this.fToolkit, searchPathComposite, Messages.TranslatorEditorGeneralPage_SearchPathLabel, "");
        if (this.fTranslatorWorkingCopy.getSearchPath() != null && !this.fTranslatorWorkingCopy.getSearchPath().isEmpty() && !this.fTranslatorWorkingCopy.getSearchPath().equals("${com.ibm.team.enterprise.ibmi.build.searchPath}")) {
            this.fLastSpecifiedSearchPath = this.fTranslatorWorkingCopy.getSearchPath();
            if (AbstractSystemDefinitionEditor.isValidBuildProperty((String)this.fTranslatorWorkingCopy.getSearchPath())) {
                this.fSearchPathText = this.createText(this.fToolkit, searchPathComposite, this.fTranslatorWorkingCopy.getSearchPath(), 1);
            } else {
                ISystemDefinition searchPath = this.fetchSearchPath(this.fTranslatorWorkingCopy.getSearchPath());
                if (searchPath != null) {
                    String label = searchPath.getName();
                    if (searchPath.isArchived()) {
                        label = String.valueOf(label) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                    this.fSearchPathText = this.createText(this.fToolkit, searchPathComposite, label, 1);
                } else {
                    this.fSearchPathText = this.createText(this.fToolkit, searchPathComposite, Messages.TranslatorEditorGeneralPage_searchPathMissing, 1);
                }
            }
        } else {
            this.fSearchPathText = this.createText(this.fToolkit, searchPathComposite, null, 1);
            this.fLastSpecifiedSearchPath = "${com.ibm.team.enterprise.ibmi.build.searchPath}";
        }
        this.fSearchPathText.setEditable(false);
        this.fSearchPathText.setEnabled(false);
        this.fSearchPathBrowseButton = this.fToolkit.createButton(searchPathComposite, Messages.SystemDefinitionEditor_BrowseButton, 8);
        this.fSearchPathBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String searchPath = TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.getSearchPath();
                SearchPathEntryDialog dialog = new SearchPathEntryDialog(TranslatorEditorGeneralPage.this.getSite().getShell(), Messages.TranslatorEditorGeneralPage_SelectSearchPathDialogTitle, searchPath, TranslatorEditorGeneralPage.this.getTeamRepository(), null);
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    String searchPathEntryValue = dialog.getSearchPathEntryValue();
                    if (AbstractSystemDefinitionEditor.isValidBuildProperty((String)searchPathEntryValue)) {
                        TranslatorEditorGeneralPage.this.fSearchPathText.setText(searchPathEntryValue);
                        TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setSearchPath(searchPathEntryValue);
                        TranslatorEditorGeneralPage.this.fLastSpecifiedSearchPath = searchPathEntryValue;
                    } else {
                        ISystemDefinition resultSearchPath = TranslatorEditorGeneralPage.this.fetchSearchPath(searchPathEntryValue);
                        if (resultSearchPath != null) {
                            String searchPathName = resultSearchPath.getName();
                            TranslatorEditorGeneralPage.this.fSearchPathText.setText(searchPathName);
                            TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setSearchPath(resultSearchPath.getItemId().getUuidValue());
                            TranslatorEditorGeneralPage.this.fLastSpecifiedSearchPath = resultSearchPath.getItemId().getUuidValue();
                        }
                    }
                    TranslatorEditorGeneralPage.this.setDirty(true);
                }
                TranslatorEditorGeneralPage.this.updateSearchPathButtonEnablement();
            }
        });
        if (this.fTranslatorWorkingCopy.getSearchPath() == null || this.fTranslatorWorkingCopy.getSearchPath().isEmpty()) {
            this.fOverrideSearchPathButton.setSelection(false);
            this.fTranslatorWorkingCopy.setSearchPath("${com.ibm.team.enterprise.ibmi.build.searchPath}");
        } else if (this.fTranslatorWorkingCopy.getSearchPath().equals("${com.ibm.team.enterprise.ibmi.build.searchPath}")) {
            this.fOverrideSearchPathButton.setSelection(false);
        } else {
            this.fOverrideSearchPathButton.setSelection(true);
        }
        this.updateSearchPathButtonEnablement();
    }

    private ISystemDefinition fetchSearchPath(final String uuid) {
        final ISystemDefinition[] searchPath = new ISystemDefinition[1];
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)TranslatorEditorGeneralPage.this.getTeamRepository());
                    IIBMiSearchPathHandle handle = (IIBMiSearchPathHandle)IIBMiSearchPath.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                    searchPath[0] = client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY, ISystemDefinition.ARCHIVED_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return searchPath[0];
    }

    private void createVariablesSection(Composite parent) {
        this.fVariablesSection = this.fToolkit.createSection(parent, 384);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fVariablesSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fSearchPathSection, 150);
        data.left = new FormAttachment((Control)this.fOutputsSection, 10);
        data.right = new FormAttachment(100, 10);
        this.fVariablesSection.setLayoutData((Object)data);
        this.fVariablesSection.setLayout((Layout)new GridLayout(1, false));
        this.fVariablesSection.setText(Messages.TranslatorEditorGeneralPage_VariablesText);
        this.fVariablesSection.setDescription(Messages.TranslatorEditorGeneralPage_VariablesDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fVariablesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fVariablesSection.setClient((Control)composite);
        this.createVariableTable(composite);
    }

    private void createVariableTable(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 66304);
        GridDataFactory.fillDefaults().hint(-1, table.getItemHeight() * 10).grab(true, false).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnHeaders = new String[]{Messages.TranslatorEditorGeneralPage_NameCol, Messages.TranslatorEditorGeneralPage_ValueCol};
        int[] columnWeights = new int[]{50, 50};
        TableColumnLayout tcl = new TableColumnLayout();
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        this.fVariableTableViewer = new TableViewer(table);
        this.fVariableTableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.fVariableTableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.fVariableTableViewer.setInput((Object)this.fTranslatorWorkingCopy.getVariables());
        if (this.isEditable()) {
            this.fVariableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TranslatorEditorGeneralPage.this.updateVariableButtonEnablement();
                }
            });
            this.fVariableTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IVariable) {
                        IVariable variable = (IVariable)element;
                        TranslatorEditorGeneralPage.this.editVariable(variable);
                    }
                }
            });
        }
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(buttonComposite);
        this.fAddVariableButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_AddButton, 8);
        this.fAddVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                CreateVariableDialog dialog = new CreateVariableDialog(TranslatorEditorGeneralPage.this.getSite().getShell(), null, TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.getVariables(), Messages.TranslatorEditorGeneralPage_CreateVariableTitle, Messages.TranslatorEditorGeneralPage_CreateVariableDescription);
                if (dialog.open() == 0) {
                    IVariable newVariable = dialog.getVariable();
                    List currentList = ((VariableContentProvider)TranslatorEditorGeneralPage.this.fVariableTableViewer.getContentProvider()).getVariableList();
                    if (currentList != null) {
                        currentList.add(newVariable);
                        TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.getVariables().add(newVariable);
                    }
                    TranslatorEditorGeneralPage.this.fVariableTableViewer.refresh();
                    TranslatorEditorGeneralPage.this.setDirty(true);
                }
            }
        });
        this.fEditVariableButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_EditButton, 8);
        this.fEditVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                IVariable initialVariable = null;
                Object tableSelection = ((StructuredSelection)TranslatorEditorGeneralPage.this.fVariableTableViewer.getSelection()).getFirstElement();
                if (tableSelection instanceof IVariable) {
                    initialVariable = (IVariable)tableSelection;
                }
                if (initialVariable != null) {
                    TranslatorEditorGeneralPage.this.editVariable(initialVariable);
                }
            }
        });
        this.fRemoveVariableButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_RemoveButton, 8);
        this.fRemoveVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = TranslatorEditorGeneralPage.this.fVariableTableViewer.getSelection();
                Object selectionObject = ((StructuredSelection)selection).getFirstElement();
                if (selectionObject instanceof IVariable) {
                    IVariable variableObject = (IVariable)selectionObject;
                    List variableList = ((VariableContentProvider)TranslatorEditorGeneralPage.this.fVariableTableViewer.getContentProvider()).getVariableList();
                    if (variableList.contains(variableObject)) {
                        variableList.remove(variableObject);
                        TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.getVariables().remove(variableObject);
                        TranslatorEditorGeneralPage.this.fVariableTableViewer.refresh();
                        TranslatorEditorGeneralPage.this.updateVariableButtonEnablement();
                        TranslatorEditorGeneralPage.this.setDirty(true);
                    }
                }
            }
        });
        this.updateVariableButtonEnablement();
        GC gc = new GC((Drawable)this.fAddVariableButton);
        gc.setFont(this.fAddVariableButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditVariableButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddVariableButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveVariableButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditVariableButton.setLayoutData((Object)gridData);
    }

    private void updateSearchPathButtonEnablement() {
        this.fSearchPathLabel.setEnabled(this.fOverrideSearchPathButton.getSelection());
        this.fSearchPathBrowseButton.setEnabled(this.fOverrideSearchPathButton.getSelection());
    }

    private void updateVariableButtonEnablement() {
        if (this.fEditVariableButton == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fVariableTableViewer.getSelection();
        this.fAddVariableButton.setEnabled(true);
        this.fEditVariableButton.setEnabled(selection.size() == 1);
        this.fRemoveVariableButton.setEnabled(!selection.isEmpty());
    }

    private void editVariable(IVariable variable) {
        CreateVariableDialog dialog = new CreateVariableDialog(this.getSite().getShell(), variable, this.fTranslatorWorkingCopy.getVariables(), Messages.TranslatorEditorGeneralPage_EditVariableTitle, Messages.TranslatorEditorGeneralPage_EditVariableDescription);
        if (dialog.open() == 0) {
            variable = dialog.getVariable();
            this.fVariableTableViewer.refresh();
            this.setDirty(true);
        }
    }

    private void createCommandSection(Composite parent) {
        this.fCommandSection = this.fToolkit.createSection(parent, 384);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fCommandSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fOutputsSection, 15);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fCommandSection.setLayoutData((Object)data);
        this.fCommandSection.setLayout((Layout)new GridLayout(1, false));
        this.fCommandSection.setText(Messages.TranslatorEditorGeneralPage_CommandsText);
        this.fCommandSection.setDescription(Messages.TranslatorEditorGeneralPage_CommandsDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fCommandSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fCommandSection.setClient((Control)composite);
        this.createLabel(this.fToolkit, composite, Messages.TranslatorEditorGeneralPage_ExistCommandLabel, null);
        this.fExistCommandText = this.createText(this.fToolkit, composite, this.fTranslatorWorkingCopy.getCommandIfObjectExists(), 2);
        this.fExistCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setCommandIfObjectExists(TranslatorEditorGeneralPage.this.fExistCommandText.getText().trim());
                if (TranslatorEditorGeneralPage.this.fUseSameCommand.getSelection()) {
                    TranslatorEditorGeneralPage.this.fNonExistCommandText.setText(TranslatorEditorGeneralPage.this.fExistCommandText.getText().trim());
                }
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.createSpacer(this.fToolkit, composite, 5, 4);
        this.createLabel(this.fToolkit, composite, Messages.TranslatorEditorGeneralPage_NonExistCommandLabel, null);
        this.fUseSameCommand = this.fToolkit.createButton(composite, Messages.TranslatorEditorGeneralPage_NonExistSameCommandLabel, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.fUseSameCommand.setLayoutData((Object)gridData);
        String existCommand = this.fTranslatorWorkingCopy.getCommandIfObjectExists();
        String nonExistCommand = this.fTranslatorWorkingCopy.getCommandIfObjectDoesntExist();
        if (existCommand != null && nonExistCommand != null) {
            this.fUseSameCommand.setSelection(existCommand.equals(nonExistCommand));
        }
        this.fUseSameCommand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TranslatorEditorGeneralPage.this.fUseSameCommand.getSelection()) {
                    TranslatorEditorGeneralPage.this.fNonExistCommandText.setText(TranslatorEditorGeneralPage.this.fExistCommandText.getText());
                    TranslatorEditorGeneralPage.this.fNonExistCommandText.setEnabled(false);
                } else {
                    TranslatorEditorGeneralPage.this.fNonExistCommandText.setEnabled(true);
                }
                TranslatorEditorGeneralPage.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fNonExistCommandText = this.createText(this.fToolkit, composite, this.fTranslatorWorkingCopy.getCommandIfObjectDoesntExist(), 2);
        if (this.fUseSameCommand.getSelection()) {
            this.fNonExistCommandText.setEnabled(false);
        }
        this.fNonExistCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setCommandIfObjectDoesntExist(TranslatorEditorGeneralPage.this.fNonExistCommandText.getText().trim());
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
    }

    private void createOutputsSection(Composite parent) {
        this.fOutputsSection = this.fToolkit.createSection(parent, 384);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fOutputsSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection, 15);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50);
        this.fOutputsSection.setLayoutData((Object)data);
        this.fOutputsSection.setLayout((Layout)new GridLayout(1, false));
        this.fOutputsSection.setText(Messages.TranslatorEditorGeneralPage_OutputsText);
        this.fOutputsSection.setDescription(Messages.TranslatorEditorGeneralPage_OutputsDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fOutputsSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.fOutputsSection.setClient((Control)composite);
        this.createLabel(this.fToolkit, composite, Messages.TranslatorEditorGeneralPage_ObjectTypeLabel, null);
        this.objTypeCombo = new Combo(composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.objTypeCombo.setLayoutData((Object)gd);
        this.objTypeCombo.setItems(this.objTypes);
        this.objTypeCombo.setText(this.fTranslatorWorkingCopy.getOutputType() != null ? this.fTranslatorWorkingCopy.getOutputType() : "");
        this.objTypeCombo.setTextLimit(11);
        this.objTypeCombo.setEnabled(true);
        new ControlDecoration((Control)this.objTypeCombo, 16512);
        this.objTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setOutputType(TranslatorEditorGeneralPage.this.objTypeCombo.getText().trim());
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.createLabel(this.fToolkit, composite, Messages.TranslatorEditorGeneralPage_DeployTypeLabel, null);
        this.fDeployTypeText = new Text(composite, 2052);
        GridData gdDeploy = new GridData(768);
        gdDeploy.horizontalSpan = 1;
        this.fDeployTypeText.setLayoutData((Object)gdDeploy);
        this.fDeployTypeText.setText(this.fTranslatorWorkingCopy.getDeployType() != null ? this.fTranslatorWorkingCopy.getDeployType() : "");
        this.fDeployTypeText.setTextLimit(25);
        this.fDeployTypeText.setEnabled(true);
        this.addControlDecorator((Control)this.fDeployTypeText, Messages.TranslatorEditorGeneralPage_DeployType_DECORATORTEXT, 131072);
        this.fDeployTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setDeployType(TranslatorEditorGeneralPage.this.fDeployTypeText.getText().trim());
                TranslatorEditorGeneralPage.this.validate();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fVariableBrowseButton = new Button(composite, 8);
        this.fVariableBrowseButton.setText(Messages.SearchPathEditorGeneralPage_BrowseButton);
        this.fVariableBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String newVariableName = TranslatorEditorGeneralPage.this.openVariableSelectionDialog();
                if (newVariableName != null) {
                    TranslatorEditorGeneralPage.this.fDeployTypeText.setText(newVariableName);
                }
            }
        });
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)this.fVariableBrowseButton);
        this.fRenameOutputObject = this.fToolkit.createButton(composite, Messages.TranslatorEditorGeneralPage_RenameCheckbox, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fRenameOutputObject.setLayoutData((Object)gridData);
        this.fRenameOutputObject.setSelection(this.fTranslatorWorkingCopy.getOutputNameKind() != OutputNameKind.SAME_AS_INPUT_LITERAL);
        this.fRenameOutputObject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!TranslatorEditorGeneralPage.this.fRenameOutputObject.getSelection()) {
                    TranslatorEditorGeneralPage.this.fTranslatorWorkingCopy.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
                }
                TranslatorEditorGeneralPage.this.updateRenameControlEnablement();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fNameLabel = this.createLabel(this.fToolkit, composite, Messages.TranslatorEditorGeneralPage_PatternOrVariable, "");
        GridData gd2 = (GridData)this.fNameLabel.getLayoutData();
        gd2.horizontalIndent = 15;
        if (this.fTranslatorWorkingCopy.getOutputNameKind() == OutputNameKind.USE_VARIABLE_LITERAL) {
            String name = VariableUtils.getVariableNameWithPrefix((String)this.fTranslatorWorkingCopy.getOutputName());
            if (name != null) {
                this.fObjectNameText = this.createText(this.fToolkit, composite, name, 1);
            }
        } else {
            this.fObjectNameText = this.createText(this.fToolkit, composite, this.fTranslatorWorkingCopy.getOutputName(), 1);
        }
        this.fObjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TranslatorEditorGeneralPage.this.updateOutputNameOrPattern();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        });
        this.addControlDecorator((Control)this.fObjectNameText, Messages.TranslatorEditorGeneralPage_HoverControlInfo, 131072);
        this.fRenameVBrowseButton = new Button(composite, 8);
        this.fRenameVBrowseButton.setText(Messages.SearchPathEditorGeneralPage_BrowseButton);
        this.fRenameVBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String newVariableName = TranslatorEditorGeneralPage.this.openVariableSelectionDialog();
                if (newVariableName != null) {
                    TranslatorEditorGeneralPage.this.fObjectNameText.setText(newVariableName);
                }
            }
        });
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)this.fRenameVBrowseButton);
        this.fToolkit.createLabel(composite, "").setLayoutData((Object)GridDataFactory.fillDefaults().create());
        String dummyExampleString = NLS.bind((String)Messages.TranslatorEditorGeneralPage_RenameExampleLabel, (Object)"ORDENTR", (Object)"1234567890");
        this.fExampleLabel = this.fToolkit.createLabel(composite, dummyExampleString, 64);
        this.fExampleLabel.setVisible(false);
        this.fExampleLabel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        this.fToolkit.createLabel(composite, "").setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.updateOutputNameOrPattern();
        this.updateRenameControlEnablement();
    }

    private String openVariableSelectionDialog() {
        Object[] dialogSelections;
        VariableSelectionDialog dialog = new VariableSelectionDialog(this.fVariableBrowseButton.getShell(), ((VariableContentProvider)this.fVariableTableViewer.getContentProvider()).getVariableList());
        if (dialog.open() == 0 && (dialogSelections = dialog.getResult()) != null && dialogSelections.length > 0) {
            Object selectedItem = dialogSelections[0];
            return "&" + ((IVariable)selectedItem).getName();
        }
        return null;
    }

    private void addControlDecorator(Control targetControl, String descriptionText, int style) {
        final ControlDecoration dec = new ControlDecoration(targetControl, style);
        if (targetControl instanceof Text) {
            dec.setMarginWidth(2);
        }
        dec.setDescriptionText(descriptionText);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    dec.show();
                }
                if (event.type == 27) {
                    dec.hide();
                }
            }
        };
        targetControl.addListener(26, listener);
        targetControl.addListener(27, listener);
    }

    private void updateOutputNameOrPattern() {
        if (!this.fRenameOutputObject.getSelection()) {
            this.fTranslatorWorkingCopy.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
        } else {
            try {
                String nameOrPattern = this.fObjectNameText.getText().trim();
                IStatus status = this.validateNameOrPattern(false);
                if (status.getSeverity() < 4) {
                    if (nameOrPattern.length() != 0 && nameOrPattern.charAt(0) == '&') {
                        if (status.isOK()) {
                            this.updateExampleText(VariableUtils.getVariableValue((String)nameOrPattern, (List)this.fTranslatorWorkingCopy.getVariables()));
                        } else {
                            this.fExampleLabel.setText(status.getMessage());
                            this.fExampleLabel.setVisible(true);
                        }
                        this.fTranslatorWorkingCopy.setOutputNameKind(OutputNameKind.USE_VARIABLE_LITERAL);
                        String name = VariableUtils.getVariableNameWithoutPrefix((String)nameOrPattern);
                        if (name != null) {
                            this.fTranslatorWorkingCopy.setOutputName(name);
                        }
                    } else {
                        if (status.isOK()) {
                            this.updateExampleText(nameOrPattern);
                        } else {
                            this.fExampleLabel.setText(status.getMessage());
                            this.fExampleLabel.setVisible(true);
                        }
                        this.fTranslatorWorkingCopy.setOutputNameKind(OutputNameKind.USE_PATTERN_LITERAL);
                        this.fTranslatorWorkingCopy.setOutputName(nameOrPattern);
                    }
                } else {
                    this.fExampleLabel.setVisible(false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updateExampleText(String pattern) {
        if (pattern != null) {
            if (this.fExampleLabel != null) {
                try {
                    MemberNamePattern mnp = new MemberNamePattern(IIBMiPlatformObject.class);
                    String result = mnp.convert(pattern, "ORDENTR");
                    if (result != null && !result.isEmpty()) {
                        this.fExampleLabel.setText(NLS.bind((String)Messages.TranslatorEditorGeneralPage_RenameExampleLabel, (Object)"ORDENTR", (Object)result));
                        this.fExampleLabel.setVisible(true);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.fExampleLabel.setVisible(false);
                }
            }
        } else {
            this.fExampleLabel.setVisible(false);
        }
    }

    private void updateRenameControlEnablement() {
        boolean isChecked = this.fRenameOutputObject.getSelection();
        if (this.fObjectNameText != null) {
            this.fObjectNameText.setEnabled(isChecked);
        }
        if (this.fRenameVBrowseButton != null) {
            this.fRenameVBrowseButton.setEnabled(isChecked);
        }
        if (this.fNameLabel != null) {
            this.fNameLabel.setEnabled(isChecked);
        }
        if (this.fExampleLabel != null) {
            this.fExampleLabel.setEnabled(isChecked);
        }
    }

    protected SelectionListener getFailOnErrorLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEditorGeneralPage.this.validate();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEditorGeneralPage.this.validate();
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEditorGeneralPage.this.validate();
                if (TranslatorEditorGeneralPage.this.fFailOnErrorButton.getSelection()) {
                    TranslatorEditorGeneralPage.this.fFailOnErrorLevelCombo.setEnabled(true);
                    TranslatorEditorGeneralPage.this.fFailOnErrorSeverityLabel.setEnabled(true);
                } else {
                    TranslatorEditorGeneralPage.this.fFailOnErrorLevelCombo.setEnabled(false);
                    TranslatorEditorGeneralPage.this.fFailOnErrorSeverityLabel.setEnabled(false);
                }
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TranslatorEditorGeneralPage.this.validate();
                if (TranslatorEditorGeneralPage.this.fFailOnErrorCommandButton.getSelection()) {
                    TranslatorEditorGeneralPage.this.fFailOnErrorCommandLevelCombo.setEnabled(true);
                    TranslatorEditorGeneralPage.this.fFailOnErrorCommandSeverityLabel.setEnabled(true);
                } else {
                    TranslatorEditorGeneralPage.this.fFailOnErrorCommandLevelCombo.setEnabled(false);
                    TranslatorEditorGeneralPage.this.fFailOnErrorCommandSeverityLabel.setEnabled(false);
                }
                TranslatorEditorGeneralPage.this.setDirty(true);
            }
        };
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.getToolkit().createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    @Override
    public boolean validate() {
        return this.validateCommands(true) && this.validateDeployType(true) && this.validateNameOrPattern(true).getSeverity() < 4 && this.validateSearchPath(true);
    }

    private boolean validateSearchPath(boolean showErrors) {
        boolean isValid = true;
        this.removeErrorMessage("BlankSearchPath", (Control)this.fSearchPathText);
        if (this.fOverrideSearchPathButton.getSelection() && this.fSearchPathText.getText().isEmpty()) {
            isValid = false;
            this.addErrorMessage((Object)"BlankSearchPath", Messages.TranslatorEditorGeneralPage_EmptySearchPathError, (Control)this.fSearchPathText);
        }
        return isValid;
    }

    private boolean validateCommands(boolean showErrors) {
        ArrayList undefinedNonExistVars;
        boolean isValid = true;
        this.removeErrorMessage("ExistCommandTextUndefinedVariable", (Control)this.fExistCommandText);
        this.removeErrorMessage("NonExistCommandTextUndefinedVariable", (Control)this.fNonExistCommandText);
        List vars = this.fTranslatorWorkingCopy.getVariables();
        ArrayList undefinedExistVars = VariableUtils.undefinedVariablesUsed((String)this.fExistCommandText.getText(), (List)vars);
        if (undefinedExistVars != null) {
            isValid = false;
            if (showErrors) {
                String errorMessage = NLS.bind((String)Messages.TranslatorEditorGeneralPage_UndefinedVariable, (Object)this.presentableList(undefinedExistVars));
                this.addErrorMessage((Object)"ExistCommandTextUndefinedVariable", errorMessage, (Control)this.fExistCommandText);
            }
        }
        if ((undefinedNonExistVars = VariableUtils.undefinedVariablesUsed((String)this.fNonExistCommandText.getText(), (List)vars)) != null) {
            isValid = false;
            if (showErrors) {
                String errorMessage = NLS.bind((String)Messages.TranslatorEditorGeneralPage_UndefinedVariable, (Object)this.presentableList(undefinedNonExistVars));
                this.addErrorMessage((Object)"NonExistCommandTextUndefinedVariable", errorMessage, (Control)this.fNonExistCommandText);
            }
        }
        if (showErrors) {
            this.setPageErrorIndicator(!isValid);
        }
        return isValid;
    }

    private IStatus validateNameOrPattern(boolean showErrors) {
        boolean isValid = true;
        IStatus result = Status.OK_STATUS;
        this.removeErrorMessage("PatternOrVariableError", (Control)this.fObjectNameText);
        if (this.fRenameOutputObject.getSelection()) {
            result = IBMiTranslatorValidator.getInstance().validatePatternOrVariable(this.fObjectNameText.getText(), this.fTranslatorWorkingCopy.getVariables());
            boolean bl = isValid = result.getSeverity() < 4;
            if (!isValid && showErrors) {
                this.addErrorMessage((Object)"PatternOrVariableError", result.getMessage(), (Control)this.fObjectNameText);
            }
        }
        this.setPageErrorIndicator(!isValid);
        return result;
    }

    private boolean validateDeployType(boolean showErrors) {
        boolean isValid = true;
        this.removeErrorMessage("DeployTypeError", (Control)this.fDeployTypeText);
        String errorMsg = IBMiTranslatorValidator.getInstance().getErrorMsgVariableInDeployType(this.fDeployTypeText.getText(), this.fTranslatorWorkingCopy.getVariables(), true);
        if (errorMsg != null) {
            isValid = false;
        }
        if (!isValid && showErrors) {
            this.addErrorMessage((Object)"DeployTypeError", errorMsg, (Control)this.fDeployTypeText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private String presentableList(ArrayList<String> vars) {
        String s = "";
        for (String v : vars) {
            s = String.valueOf(s) + v + ", ";
        }
        if ((s = s.trim()).endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_ibmitranslator";
    }

    class AdditionalPathContentProvider
    implements IStructuredContentProvider {
        List<String> pathList = null;

        AdditionalPathContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.pathList != null) {
                return this.pathList.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
            if (this.pathList != null && !this.pathList.isEmpty()) {
                this.pathList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                if (this.pathList == null) {
                    this.pathList = new ArrayList<String>();
                }
                if (!this.pathList.isEmpty()) {
                    this.pathList.clear();
                }
                this.pathList.addAll((Collection)newInput);
            }
        }

        public List<String> getPathList() {
            return this.pathList;
        }
    }

    class AdditionalPathLabelProvider
    extends LabelProvider {
        AdditionalPathLabelProvider() {
        }

        public String getText(Object element) {
            String libraryName = "";
            String libraryUUID = (String)element;
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)TranslatorEditorGeneralPage.this.getTeamRepository());
            try {
                IIBMiResourceDefinitionHandle handle = (IIBMiResourceDefinitionHandle)IIBMiResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)libraryUUID), null);
                IIBMiResourceDefinition libraryResource = (IIBMiResourceDefinition)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY), null);
                if (libraryResource != null) {
                    libraryName = libraryResource.getName();
                }
            }
            catch (TeamRepositoryException e) {
                System.out.println(String.valueOf(Messages.SystemDefinitionEditor_LibraryNotFound) + e.getLocalizedMessage());
            }
            return libraryName;
        }
    }
}

