/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LanguageDefinitionEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.ResourceDefinitionEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SearchPathEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.TranslatorEditorInput;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;

public class SystemDefinitionEditorInputFactory {
    public static final String TAN_PATH_IBMI_RESOURCE_DEFINITIONS = "SystemDefinitions/POS/ResourceDefinitions";
    public static final String TAN_PATH_IBMI_SEARCH_PATH_DEFINITIONS = "SystemDefinitions/POS/SearchPathDefinitions";
    public static final String TAN_PATH_IBMI_LANGUAGE_DEFINITIONS = "SystemDefinitions/POS/LanguageDefinitions";

    private SystemDefinitionEditorInputFactory() {
    }

    public static AbstractEditorInput getSystemDefinitionEditorInput(ISystemDefinition definition, IProjectAreaHandle projectAreaHandle) throws TeamRepositoryException {
        EnterpriseExtensionsDomainRegistry eeRegistry = EnterpriseExtensionsDomainRegistry.getInstance();
        if (definition instanceof IIBMiLanguageDefinition) {
            return new LanguageDefinitionEditorInput((ISystemDefinition)((IIBMiLanguageDefinition)definition), projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_IBMI_LANGUAGE_DEFINITIONS));
        }
        if (definition instanceof IIBMiResourceDefinition) {
            return new ResourceDefinitionEditorInput((IIBMiResourceDefinition)definition, ((IIBMiResourceDefinition)definition).getUsageType(), projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_IBMI_RESOURCE_DEFINITIONS));
        }
        if (definition instanceof IIBMiSearchPath) {
            return new SearchPathEditorInput((IIBMiSearchPath)definition, projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_IBMI_SEARCH_PATH_DEFINITIONS));
        }
        if (definition instanceof IIBMiTranslator) {
            return new TranslatorEditorInput((IIBMiTranslator)definition, projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_IBMI_LANGUAGE_DEFINITIONS));
        }
        return null;
    }
}

