/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs.ResourceDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SearchPathUtils;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class SearchPathEditorGeneralPage
extends AbstractSystemDefinitionEditorPage {
    private IIBMiSearchPath fSearchPathWorkingCopy;
    private FormToolkit fToolkit;
    private Section fGeneralSection;
    private Text fDescriptionText;
    private Button fNonImpactingCheckbox;
    private Text fObjectLibrary;
    private Text fSourceLibrary;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private Button fBrowseObjectLibrary;
    private Button fClearObjectLibrary;
    private Button fBrowseSourceLibrary;
    private Button fClearSourceLibrary;
    private TableViewer fTableViewer;
    private ViewerFilter referencedLibrariesFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IIBMiResourceDefinition) {
                IResourceDefinition definitionHandle = (IResourceDefinition)element;
                return !definitionHandle.isArchived() && !SearchPathUtils.getReferencedLibrariesUUIDs((ISearchPath)SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy).contains(definitionHandle.getItemId().getUuidValue());
            }
            return true;
        }
    };
    private ViewerFilter objectOrSourceLibrariesFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IIBMiResourceDefinition) {
                IIBMiResourceDefinition definition = (IIBMiResourceDefinition)element;
                return !definition.isArchived();
            }
            return true;
        }
    };
    private ISelectionChangedListener fSearchableDatasetTableListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SearchPathEditorGeneralPage.this.updateButtonEnablement();
        }
    };

    public SearchPathEditorGeneralPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        if (item instanceof IIBMiSearchPath) {
            this.fSearchPathWorkingCopy = (IIBMiSearchPath)item;
        }
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.createGeneralSection(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 384);
        if (this.fSearchPathWorkingCopy != null && this.fSearchPathWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(60);
        this.fGeneralSection.setLayoutData((Object)data);
        int numColumns = 6;
        this.fGeneralSection.setLayout((Layout)new GridLayout(numColumns, false));
        this.fGeneralSection.setText(Messages.SystemDefinitionEditor_General);
        this.fGeneralSection.setDescription(Messages.SearchPathEditorGeneralPage_GeneralDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        this.fGeneralSection.setClient((Control)composite);
        this.createObjectLibraryControls(composite);
        this.createSourceLibraryControls(composite);
        this.createSpacer(this.fToolkit, composite, 1, numColumns);
        this.createLabel(this.fToolkit, composite, Messages.SearchPathEditorGeneralPage_ReferencedLibrariesLable, null);
        this.createSearchableDatasetTable(composite);
        this.updateButtonEnablement();
        this.createSpacer(this.fToolkit, composite, 1, numColumns);
        Label label = this.fToolkit.createLabel(composite, Messages.SearchPathEditorGeneralPage_DESCRIPTION_LABEL);
        label.setToolTipText(Messages.SearchPathEditorGeneralPage_DESCRIPTION_TOOLTIP);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)label);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fSearchPathWorkingCopy.getDescription(), 2626);
        GridDataFactory.fillDefaults().span(2, -1).hint(-1, 60).grab(true, false).applyTo((Control)this.fDescriptionText);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy.setDescription(SearchPathEditorGeneralPage.this.fDescriptionText.getText().trim());
                SearchPathEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        this.fNonImpactingCheckbox.setToolTipText(Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION);
        GridDataFactory.fillDefaults().span(numColumns, 1).grab(true, false).applyTo((Control)this.fNonImpactingCheckbox);
        this.fNonImpactingCheckbox.setSelection(this.fSearchPathWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy.setNonImpacting(SearchPathEditorGeneralPage.this.fNonImpactingCheckbox.getSelection());
                SearchPathEditorGeneralPage.this.setDirty(true);
            }
        });
    }

    private void createObjectLibraryControls(Composite parent) {
        this.createLabel(this.fToolkit, parent, Messages.SearchPathEditorGeneralPage_ObjectLibraryLabel, null);
        String innerText = Messages.SearchPathEditorGeneralPage_DefaultIProjectObjectLibrary;
        String libUuid = SearchPathUtils.getObjectLibraryUUID((ISearchPath)this.fSearchPathWorkingCopy);
        if (libUuid != null && !libUuid.isEmpty()) {
            String libName = this.getLibraryName(libUuid);
            innerText = libName != null && !libName.isEmpty() ? libName : Messages.SearchPathEditorGeneralPage_libraryMissing;
        } else {
            this.fSearchPathWorkingCopy.getProperties().put("object.library.key", "");
        }
        this.fObjectLibrary = this.createText(this.fToolkit, parent, innerText, 3);
        this.fObjectLibrary.setEditable(false);
        this.fObjectLibrary.setEnabled(false);
        this.fBrowseObjectLibrary = this.fToolkit.createButton(parent, Messages.SearchPathEditorGeneralPage_BrowseButton, 8);
        this.fBrowseObjectLibrary.addSelectionListener(this.getAddBrowseSelectionListener());
        this.fClearObjectLibrary = this.fToolkit.createButton(parent, Messages.SearchPathEditorGeneralPage_ClearButton, 8);
        this.fClearObjectLibrary.addSelectionListener(this.getClearSelectionListener());
    }

    private void createSourceLibraryControls(Composite parent) {
        this.createLabel(this.fToolkit, parent, Messages.SearchPathEditorGeneralPage_SourceLibraryLabel, null);
        String innerText = Messages.SearchPathEditorGeneralPage_DefaultIProjectSourceLibrary;
        String libUuid = SearchPathUtils.getSourceLibraryUUID((ISearchPath)this.fSearchPathWorkingCopy);
        if (libUuid != null && !libUuid.isEmpty()) {
            String libName = this.getLibraryName(libUuid);
            innerText = libName != null && !libName.isEmpty() ? libName : Messages.SearchPathEditorGeneralPage_libraryMissing;
        } else {
            this.fSearchPathWorkingCopy.getProperties().put("source.library.key", "");
        }
        this.fSourceLibrary = this.createText(this.fToolkit, parent, innerText, 3);
        this.fSourceLibrary.setEditable(false);
        this.fSourceLibrary.setEnabled(false);
        this.fBrowseSourceLibrary = this.fToolkit.createButton(parent, Messages.SearchPathEditorGeneralPage_BrowseButton, 8);
        this.fBrowseSourceLibrary.addSelectionListener(this.getAddBrowseSelectionListener());
        this.fBrowseSourceLibrary.setVisible(false);
        this.fClearSourceLibrary = this.fToolkit.createButton(parent, Messages.SearchPathEditorGeneralPage_ClearButton, 8);
        this.fClearSourceLibrary.addSelectionListener(this.getClearSelectionListener());
    }

    private String getLibraryName(String uuid) {
        if (uuid != null && !uuid.isEmpty()) {
            IResourceDefinition lib = null;
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
                IResourceDefinitionHandle handle = (IResourceDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                lib = (IResourceDefinition)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY, ISystemDefinition.ARCHIVED_PROPERTY), null);
                if (lib != null) {
                    if (lib.isArchived()) {
                        return String.valueOf(lib.getName()) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                    return lib.getName();
                }
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
                return null;
            }
            catch (NullPointerException e) {
                return Messages.SearchPathEditorGeneralPage_libraryMissing;
            }
            catch (ClassCastException e) {
                return Messages.SearchPathEditorGeneralPage_ErrorNotAValidLibrary;
            }
        }
        return null;
    }

    private void createSearchableDatasetTable(Composite parent) {
        Table table = this.fToolkit.createTable(parent, 66306);
        GridDataFactory.fillDefaults().hint(-1, table.getItemHeight() * 10).grab(true, false).span(3, 1).applyTo((Control)table);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new SearchPathContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fTableViewer.setInput((Object)SearchPathUtils.getReferencedLibrariesUUIDs((ISearchPath)this.fSearchPathWorkingCopy));
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttonComposite);
        this.fAddButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_AddButton, 8);
        this.fAddButton.addSelectionListener(this.getAddBrowseSelectionListener());
        this.fRemoveButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_RemoveButton, 8);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = SearchPathEditorGeneralPage.this.fTableViewer.getSelection();
                List path = SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy.getPath();
                List<String> libraryList = ((SearchPathContentProvider)SearchPathEditorGeneralPage.this.fTableViewer.getContentProvider()).getPathList();
                for (Object selectionObject : ((StructuredSelection)selection).toList()) {
                    String libraryObject;
                    if (!(selectionObject instanceof String) || !libraryList.contains(libraryObject = (String)selectionObject)) continue;
                    libraryList.remove(libraryObject);
                    SystemDefinitionUtil.remove((List)path, (String)libraryObject);
                }
                SearchPathEditorGeneralPage.this.updateButtonEnablement();
                SearchPathEditorGeneralPage.this.setDirty(true);
                SearchPathEditorGeneralPage.this.fTableViewer.refresh();
            }
        });
        this.fMoveUpButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_UpButton, 8);
        this.fMoveUpButton.setEnabled(false);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SearchPathEditorGeneralPage.this.moveEntries(true);
            }
        });
        this.fMoveDownButton = this.fToolkit.createButton(buttonComposite, Messages.SystemDefinitionEditor_DownButton, 8);
        this.fMoveDownButton.setEnabled(false);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPathEditorGeneralPage.this.moveEntries(false);
            }
        });
        if (this.isEditable()) {
            this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
            this.fTableViewer.addOpenListener(this.getOpenListener());
        }
        this.setButtonLayoutData();
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return this.fSearchableDatasetTableListener;
    }

    private void moveEntries(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int offset = up ? -1 : 1;
        List path = SearchPathUtils.getReferencedLibrariesUUIDs((ISearchPath)this.fSearchPathWorkingCopy, (boolean)true);
        Object[] selectionArray = selection.toArray();
        int i = up ? 0 : selectionArray.length - 1;
        while (!(up ? i >= selectionArray.length : i < 0)) {
            String entry = (String)selectionArray[i];
            int index = path.indexOf(entry);
            if (index > -1) {
                path.remove(entry);
                if (index + offset > -1) {
                    path.add(index + offset, entry);
                }
            }
            int n = i = up ? i + 1 : i - 1;
        }
        SearchPathUtils.setReferencedLibrariesByUUIDs((ISearchPath)this.fSearchPathWorkingCopy, (List)path);
        this.fTableViewer.setInput((Object)path);
        this.setDirty(true);
        this.updateButtonEnablement();
    }

    private void updateButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fClearSourceLibrary.setEnabled(!this.fSourceLibrary.getText().equalsIgnoreCase(Messages.SearchPathEditorGeneralPage_DefaultIProjectSourceLibrary));
        this.fClearObjectLibrary.setEnabled(!this.fObjectLibrary.getText().equalsIgnoreCase(Messages.SearchPathEditorGeneralPage_DefaultIProjectObjectLibrary));
        this.fSourceLibrary.setEnabled(this.fClearSourceLibrary.getEnabled());
        this.fObjectLibrary.setEnabled(this.fClearObjectLibrary.getEnabled());
        if (!selection.isEmpty()) {
            String library;
            int size = selection.size();
            List<String> libraryList = ((SearchPathContentProvider)this.fTableViewer.getContentProvider()).getPathList();
            if (libraryList.indexOf(library = selection.getFirstElement().toString()) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (libraryList.indexOf(library) + size == libraryList.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){
            IResourceDefinition resource = null;

            public void open(OpenEvent event) {
                Object selectionObject;
                IStructuredSelection selection = (IStructuredSelection)SearchPathEditorGeneralPage.this.fTableViewer.getSelection();
                if (selection.size() == 1 && (selectionObject = ((StructuredSelection)selection).getFirstElement()) instanceof String) {
                    try {
                        this.resource = null;
                        this.fetchResourceDefinition((String)selectionObject);
                        if (this.resource != null) {
                            EditSystemDefinitionActionDelegate.run((ISystemDefinition)this.resource, this.resource.getProjectArea(), SearchPathEditorGeneralPage.this.getSite().getPage(), true, true);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }

            private void fetchResourceDefinition(final String resourceUUID) {
                Job fetchResourceEditorJob = new Job(Messages.LanguageDefinitionEditorGeneralPage_FetchResourceJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)SearchPathEditorGeneralPage.this.getTeamRepository());
                        try {
                            resource = (IResourceDefinition)client.findSystemDefinitionComplete(resourceUUID, null, IIBMiResourceDefinition.ITEM_TYPE, monitor);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                fetchResourceEditorJob.schedule();
                try {
                    fetchResourceEditorJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private SelectionListener getAddBrowseSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ResourceDefinitionSelectionDialog dialog;
                    Object eventSource = event.getSource();
                    List<String> currentList = ((SearchPathContentProvider)SearchPathEditorGeneralPage.this.fTableViewer.getContentProvider()).getPathList();
                    if (eventSource == SearchPathEditorGeneralPage.this.fBrowseObjectLibrary || eventSource == SearchPathEditorGeneralPage.this.fBrowseSourceLibrary) {
                        dialog = new ResourceDefinitionSelectionDialog(SearchPathEditorGeneralPage.this.getSite().getShell(), SearchPathEditorGeneralPage.this.getTeamRepository(), null, SearchPathEditorGeneralPage.this.objectOrSourceLibrariesFilter, false);
                        dialog.setTitle(Messages.SearchPathEditorGeneralPage_SelectLibraryTitle);
                    } else {
                        dialog = new ResourceDefinitionSelectionDialog(SearchPathEditorGeneralPage.this.getSite().getShell(), SearchPathEditorGeneralPage.this.getTeamRepository(), null, SearchPathEditorGeneralPage.this.referencedLibrariesFilter, true);
                        dialog.setTitle(Messages.SearchPathEditorGeneralPage_SelectLibrariesDialogTitle);
                    }
                    if (dialog.open() == 0) {
                        IResourceDefinition library;
                        Object[] dialogResult = dialog.getSelectedSystemDefinitions();
                        if (eventSource == SearchPathEditorGeneralPage.this.fAddButton) {
                            if (currentList != null) {
                                Object[] objectArray = dialogResult;
                                int n = dialogResult.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    if (o instanceof IResourceDefinition) {
                                        StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
                                        helper.setValue(((IResourceDefinition)o).getItemId().getUuidValue());
                                        currentList.add(helper.getValue());
                                        SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy.getPath().add(helper);
                                    }
                                    ++n2;
                                }
                            }
                            SearchPathEditorGeneralPage.this.fTableViewer.refresh();
                        } else if (eventSource == SearchPathEditorGeneralPage.this.fBrowseObjectLibrary) {
                            IResourceDefinition library2;
                            if (dialogResult.length != 0 && (library2 = (IResourceDefinition)dialogResult[0]) != null) {
                                SearchPathEditorGeneralPage.this.fObjectLibrary.setText(library2.getName());
                                SearchPathUtils.setObjectLibrary((ISearchPath)SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy, (IResourceDefinitionHandle)library2);
                            }
                        } else if (eventSource == SearchPathEditorGeneralPage.this.fBrowseSourceLibrary && dialogResult.length != 0 && (library = (IResourceDefinition)dialogResult[0]) != null) {
                            SearchPathEditorGeneralPage.this.fSourceLibrary.setText(library.getName());
                            SearchPathUtils.setSourceLibrary((ISearchPath)SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy, (IResourceDefinitionHandle)library);
                        }
                        SearchPathEditorGeneralPage.this.updateButtonEnablement();
                        SearchPathEditorGeneralPage.this.setDirty(true);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        };
    }

    private SelectionListener getClearSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() == SearchPathEditorGeneralPage.this.fClearSourceLibrary) {
                    SearchPathEditorGeneralPage.this.fSourceLibrary.setText(Messages.SearchPathEditorGeneralPage_DefaultIProjectSourceLibrary);
                    SearchPathUtils.setSourceLibrary((ISearchPath)SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy, null);
                } else if (event.getSource() == SearchPathEditorGeneralPage.this.fClearObjectLibrary) {
                    SearchPathEditorGeneralPage.this.fObjectLibrary.setText(Messages.SearchPathEditorGeneralPage_DefaultIProjectObjectLibrary);
                    SearchPathUtils.setObjectLibrary((ISearchPath)SearchPathEditorGeneralPage.this.fSearchPathWorkingCopy, null);
                }
                SearchPathEditorGeneralPage.this.setDirty(true);
                SearchPathEditorGeneralPage.this.updateButtonEnablement();
            }
        };
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddButton);
        gc.setFont(this.fAddButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fMoveUpButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fMoveDownButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fBrowseObjectLibrary.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveUpButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveDownButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fBrowseObjectLibrary.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fBrowseSourceLibrary.setLayoutData((Object)gridData);
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_searchPath";
    }

    class LibraryLabelProvider
    extends LabelProvider {
        LibraryLabelProvider() {
        }

        public String getText(Object element) {
            String libraryName = "";
            String libraryUUID = (String)element;
            if (libraryUUID != null && !libraryUUID.isEmpty()) {
                String libName = SearchPathEditorGeneralPage.this.getLibraryName(libraryUUID);
                libraryName = libName != null && !libName.isEmpty() ? libName : Messages.SearchPathEditorGeneralPage_libraryMissing;
            }
            return libraryName;
        }
    }

    class SearchPathContentProvider
    implements IStructuredContentProvider {
        List<String> pathList = null;

        SearchPathContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.pathList != null) {
                return this.pathList.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
            if (this.pathList != null && !this.pathList.isEmpty()) {
                this.pathList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                if (this.pathList == null) {
                    this.pathList = new ArrayList<String>();
                }
                if (!this.pathList.isEmpty()) {
                    this.pathList.clear();
                }
                this.pathList.addAll((Collection)newInput);
            }
        }

        public List<String> getPathList() {
            return this.pathList;
        }
    }
}

