/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorIBMi;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SearchPathEditorGeneralPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SearchPathEditorInput;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SearchPathEditor
extends AbstractSystemDefinitionEditorIBMi {
    private ScrolledForm fForm;
    private SearchPathEditorInput fEditorInput;
    private SearchPathEditorGeneralPage genEd;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (SearchPathEditorInput)input;
        this.fTeamRepository = this.fEditorInput.getTeamRepository();
        this.fIsNewSystemDefinition = this.fEditorInput.isNewSystemDefinition();
        this.fSystemDefinition = (ISystemDefinition)this.fEditorInput.getSystemDefinition().getWorkingCopy();
    }

    protected Image getHeaderTitleImage() {
        return DefUIPlugin.getImage("icons/obj16/searchpth.gif");
    }

    protected String getHeaderTitleText() {
        return Messages.SearchPathEditor_SearchPath;
    }

    protected void updatePageWorkingCopies(ISystemDefinition sysDef) {
        for (Object page : this.pages) {
            AbstractSystemDefinitionEditorPage editorPage = (AbstractSystemDefinitionEditorPage)((Object)page);
            editorPage.setWorkingCopy(sysDef);
        }
    }

    protected void addPages() {
        try {
            this.genEd = new SearchPathEditorGeneralPage("general", Messages.SystemDefinitionEditor_General);
            this.genEd.initialize(this);
            this.genEd.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.genEd);
            this.addHistoryPage();
        }
        catch (PartInitException exception) {
            DefUIPlugin.log(exception);
        }
    }

    protected boolean validate() {
        boolean isValid = this.genEd.validate();
        if (this.fSystemDefinitionIdText.getText().trim().equals("")) {
            this.addErrorMessage(this.fSystemDefinitionIdText, com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.LanguageDefinitionEditor_ID_MUST_NOT_BE_EMPTY, (Control)this.fSystemDefinitionIdText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fSystemDefinitionIdText, (Control)this.fSystemDefinitionIdText);
        }
        return isValid;
    }

    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.SystemDefinitionEditor_SavingResourceDefinition, 2);
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
            ISystemDefinitionHandle savedHandle = client.saveSystemDefinition(this.fSystemDefinition, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fSystemDefinition = (ISystemDefinition)client.fetchSystemDefinitionComplete(savedHandle, true, monitor).getWorkingCopy();
            this.fEditorInput.initializeEditorInput(this.fSystemDefinition);
            this.updatePageWorkingCopies(this.fSystemDefinition);
            if (this.fIsNewSystemDefinition || this.fNameChanged) {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                this.refreshSystemDefinitionNode(node);
            }
            this.fNameChanged = false;
            this.fIsNewSystemDefinition = false;
        }
        finally {
            monitor.done();
        }
    }

    public void refreshSystemDefinitionItem(IProgressMonitor monitor) {
        if (!this.fIsNewSystemDefinition) {
            this.fSystemDefinition = this.fEditorInput.getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
                this.fSystemDefinition = (ISystemDefinition)client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.fSystemDefinition, true, monitor).getWorkingCopy();
                if (this.genEd != null) {
                    this.genEd.setWorkingCopy(this.fSystemDefinition);
                }
                this.setWorkingCopyForHistory();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    protected void handleRefreshComplete() {
        this.fSystemDefinitionIdText.removeModifyListener(this.fIdModifiedListener);
        this.fSystemDefinitionIdText.setText(this.fSystemDefinition.getName());
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.updatePageWorkingCopies(this.fSystemDefinition);
        this.handleArchived();
        for (Object page : this.pages) {
            AbstractSystemDefinitionEditorPage editorPage = (AbstractSystemDefinitionEditorPage)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (this.fForm != null) {
            this.fForm.reflow(true);
        }
        this.setPartName();
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
    }

    protected String getHelpId() {
        return null;
    }
}

