/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ResourceDefinitionEditorGeneralPage
extends AbstractSystemDefinitionEditorPage {
    private IIBMiResourceDefinition fResourceDefWorkingCopy;
    private FormToolkit fToolkit;
    private Composite fParent;
    private Section fGeneralSection;
    private Text fDescriptionText;
    private Text fLibraryNameText;
    private Label fLibraryNameLabel;
    private Button fNonImpactingCheckbox;

    public ResourceDefinitionEditorGeneralPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        if (item instanceof IIBMiResourceDefinition) {
            this.fResourceDefWorkingCopy = (IIBMiResourceDefinition)item;
        }
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fParent = parent;
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.createGeneralSection(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 384);
        if (this.fResourceDefWorkingCopy != null && this.fResourceDefWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralSection.setText(Messages.SystemDefinitionEditor_General);
        if (this.fResourceDefWorkingCopy.getUsageType() == 1) {
            this.fGeneralSection.setDescription(Messages.ResourceDefinitionEditorGeneralPage_GeneralDescriptionExistingLibrary);
        } else {
            this.fGeneralSection.setDescription(Messages.ResourceDefinitionEditorGeneralPage_GeneralDescriptionTargetLibrary);
        }
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fGeneralSection.setClient((Control)composite);
        this.fLibraryNameLabel = this.createLabel(this.fToolkit, composite, Messages.ResourceDefinitionEditorGeneralPage_LibraryNameLabel, Messages.ResourceDefinitionEditorGeneralPage_LibraryNameDescription);
        this.fLibraryNameText = this.createText(this.fToolkit, composite, this.fResourceDefWorkingCopy.getResourceName(), 3);
        if (this.fResourceDefWorkingCopy.getUsageType() == 1) {
            this.fLibraryNameText.setTextLimit(10);
        } else {
            this.fLibraryNameText.setTextLimit(9);
        }
        this.fLibraryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceDefinitionEditorGeneralPage.this.validate();
                if (ResourceDefinitionEditorGeneralPage.this.fLibraryNameText.getText().indexOf(34) < 0) {
                    ResourceDefinitionEditorGeneralPage.this.fResourceDefWorkingCopy.setResourceName(ResourceDefinitionEditorGeneralPage.this.fLibraryNameText.getText().toUpperCase().trim());
                } else {
                    ResourceDefinitionEditorGeneralPage.this.fResourceDefWorkingCopy.setResourceName(ResourceDefinitionEditorGeneralPage.this.fLibraryNameText.getText().trim());
                }
                ResourceDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
        Label label = this.fToolkit.createLabel(composite, Messages.SystemDefinitionEditor_DescriptionText);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fResourceDefWorkingCopy.getDescription(), 2626);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.fDescriptionText.setLayoutData((Object)gridData);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceDefinitionEditorGeneralPage.this.fResourceDefWorkingCopy.setDescription(ResourceDefinitionEditorGeneralPage.this.fDescriptionText.getText().trim());
                ResourceDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        this.fNonImpactingCheckbox.setToolTipText(Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fNonImpactingCheckbox);
        this.fNonImpactingCheckbox.setSelection(this.fResourceDefWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceDefinitionEditorGeneralPage.this.fResourceDefWorkingCopy.setNonImpacting(ResourceDefinitionEditorGeneralPage.this.fNonImpactingCheckbox.getSelection());
                ResourceDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
    }

    @Override
    public boolean validate() {
        String errorMessage;
        boolean isValid = true;
        String proposedName = this.fLibraryNameText.getText().trim();
        if (proposedName.equals("")) {
            isValid = false;
            errorMessage = Messages.ResourceDefinitionEditorGeneralPage_ErrorNoLibraryName;
            this.addErrorMessage((Object)"ResourceDefinitionNoLibraryName", errorMessage, (Control)this.fLibraryNameText);
        } else {
            this.removeErrorMessage("ResourceDefinitionNoLibraryName", (Control)this.fLibraryNameText);
        }
        if (this.fResourceDefWorkingCopy.getUsageType() == 1) {
            if (!proposedName.isEmpty() && !IBMiLibraryValidator.isValidLibraryName((String)proposedName)) {
                isValid = false;
                errorMessage = NLS.bind((String)Messages.ResourceDefinitionEditorGeneralPage_ErrorLibraryNameNonConformance, (Object)proposedName);
                this.addErrorMessage((Object)"ResourceDefinitionInvalidIBMiLibraryName", errorMessage, (Control)this.fLibraryNameText);
            } else {
                this.removeErrorMessage("ResourceDefinitionInvalidIBMiLibraryName", (Control)this.fLibraryNameText);
            }
        } else if (this.fResourceDefWorkingCopy.getUsageType() == 0) {
            if (proposedName.indexOf(34) > -1) {
                if (!proposedName.endsWith("\"") || proposedName.indexOf(34) != proposedName.lastIndexOf(34)) {
                    isValid = false;
                    errorMessage = Messages.ResourceDefinitionEditorGeneralPage_WRONG_QUOTE_LOCATION;
                    this.addErrorMessage((Object)"ResourceDefinitionInvalidQuoteLocation", errorMessage, (Control)this.fLibraryNameText);
                } else {
                    this.removeErrorMessage("ResourceDefinitionInvalidQuoteLocation", (Control)this.fLibraryNameText);
                }
                if (proposedName.endsWith("\"") && IBMiLibraryValidator.containsBadCharacters((String)proposedName.substring(0, proposedName.length() - 1), (StringBuffer)new StringBuffer("'?*"), (int)0)) {
                    isValid = false;
                    errorMessage = Messages.ResourceDefinitionEditorGeneralPage_INVALID_CHARACTERS_QUOTED;
                    this.addErrorMessage((Object)"ResourceDefinitionInvalidIBMiQuotedLibraryName", errorMessage, (Control)this.fLibraryNameText);
                } else {
                    this.removeErrorMessage("ResourceDefinitionInvalidIBMiQuotedLibraryName", (Control)this.fLibraryNameText);
                }
                this.removeErrorMessage("ResourceDefinitionInvalidIBMiLibraryNameSuffix", (Control)this.fLibraryNameText);
            } else {
                if (!IBMiLibraryValidator.onlyContains((String)proposedName, (StringBuffer)IBMiLibraryValidator.VALIDCHARS_ENDPOS, (int)0)) {
                    isValid = false;
                    errorMessage = Messages.ResourceDefinitionEditorGeneralPage_INVALID_CHARACTERS;
                    this.addErrorMessage((Object)"ResourceDefinitionInvalidIBMiLibraryNameSuffix", errorMessage, (Control)this.fLibraryNameText);
                } else {
                    this.removeErrorMessage("ResourceDefinitionInvalidIBMiLibraryNameSuffix", (Control)this.fLibraryNameText);
                }
                this.removeErrorMessage("ResourceDefinitionInvalidQuoteLocation", (Control)this.fLibraryNameText);
                this.removeErrorMessage("ResourceDefinitionInvalidIBMiQuotedLibraryName", (Control)this.fLibraryNameText);
            }
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    protected String getContextHelpId() {
        if (this.fResourceDefWorkingCopy.getUsageType() == 1) {
            return "com.ibm.team.build.ui.editor_existinglibraryDefinition";
        }
        return "com.ibm.team.build.ui.editor_targetlibraryDefinition";
    }
}

