/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class MetadataScannerLabelProvider
extends LabelProvider {
    private ITeamRepository repository;
    private Map labelCache;

    public MetadataScannerLabelProvider(ITeamRepository repository) {
        this.repository = repository;
        if (repository != null) {
            this.labelCache = new HashMap();
        }
    }

    protected abstract ScannerLabelHelper getLabelHelper(Object var1);

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IFileMetadataScanner) {
            String label = ((IFileMetadataScanner)element).getLabel();
            return label;
        }
        if (element instanceof IStringHelper) {
            element = ((IStringHelper)element).getValue();
        }
        if (element instanceof String) {
            String scannerName = (String)element;
            String label = (String)this.labelCache.get(scannerName);
            if (label != null) {
                return label;
            }
            ScannerLabelHelper labelHelper = this.getLabelHelper(element);
            labelHelper.getScannerLabelInBackground(scannerName);
            return Messages.MetadataScannerLabelProvider_Pending;
        }
        return super.getText(element);
    }

    public class ScannerLabelHelper {
        public void labelAvailable(String label, String scannerUUID) {
        }

        public void getScannerLabelInBackground(final String scannerName) {
            FoundationJob job = new FoundationJob(Messages.MetadataScannerLabelProvider_JobLabel){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    String label = Messages.MetadataScannerLabelProvider_ItemNotFoundLabel;
                    IFileMetadataScanner scanner = this.fetchScanner(scannerName);
                    if (scanner != null) {
                        label = scanner.getLabel();
                        MetadataScannerLabelProvider.this.labelCache.put(scannerName, label);
                    }
                    ScannerLabelHelper.this.asyncLabelAvailable(label, scannerName);
                    return Status.OK_STATUS;
                }

                private IFileMetadataScanner fetchScanner(String scannerName2) throws TeamRepositoryException {
                    IMetadataScannerClientLibrary scannerClient = (IMetadataScannerClientLibrary)MetadataScannerLabelProvider.this.repository.getClientLibrary(IMetadataScannerClientLibrary.class);
                    return scannerClient.getMetadataScanner(scannerName2);
                }
            };
            job.schedule();
        }

        protected void asyncLabelAvailable(final String label, final String scannerName) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScannerLabelHelper.this.labelAvailable(label, scannerName);
                }
            });
        }
    }
}

