/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LanguageDefinitionEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.MetadataScannerLabelProvider;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.jobs.LongRunningJob;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.jobs.LongRunningJobListener;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DependencyType;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.IGenericListener;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ScannerSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.DependencyTypesControl;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LanguageDefinitionEditorScannerPage
extends AbstractSystemDefinitionEditorPage
implements ITranslatorEntryConsumer {
    private IIBMiLanguageDefinition fLanguageDefinitionWorkingCopy;
    private FormToolkit fToolkit;
    private Composite fParent;
    private IFileMetadataScanner[] scanners;
    private Section fMetadataScannersSection;
    private Section fDependencyTypesSection;
    private TableViewer fMetadataScannersViewer;
    private Button fAddScannerButton;
    private Button fRemoveScannerButton;
    private Button fMoveScannerUpButton;
    private Button fMoveScannerDownButton;
    private DependencyTypesControl fDependencyTypesControl;
    private AbstractEditorInput editorInput;
    private IGenericListener fDependencyTypesListener = this.getDependencyTypesListener();

    public LanguageDefinitionEditorScannerPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fParent = parent;
        this.resolveSystemDefinitionCaches();
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.editorInput = (AbstractEditorInput)this.getEditorInput();
        this.createMetadataScannersSection(parent);
        this.createDependencyTypesSection(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    private void createMetadataScannersSection(Composite parent) {
        this.fMetadataScannersSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fMetadataScannersSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fMetadataScannersSection.setLayoutData((Object)data);
        this.fMetadataScannersSection.setLayout((Layout)new GridLayout(1, false));
        this.fMetadataScannersSection.setText(Messages.LanguageDefinitionEditorScannerPage_ScannersText);
        this.fMetadataScannersSection.setDescription(Messages.LanguageDefinitionEditorScannerPage_ScannersDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fMetadataScannersSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fToolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Table table = this.fToolkit.createTable(composite, 66304);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.heightHint = table.getItemHeight() * 10;
        table.setLayoutData((Object)gridData);
        this.fMetadataScannersViewer = new TableViewer(table);
        this.fMetadataScannersViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fMetadataScannersViewer.setLabelProvider((IBaseLabelProvider)new MetadataScannerLabelProvider(this.getTeamRepository()){

            @Override
            protected MetadataScannerLabelProvider.ScannerLabelHelper getLabelHelper(Object element) {
                return new MetadataScannerLabelProvider.ScannerLabelHelper(this){

                    @Override
                    public void labelAvailable(String label, String scannerName) {
                        if (!LanguageDefinitionEditorScannerPage.this.fMetadataScannersViewer.getTable().isDisposed()) {
                            LanguageDefinitionEditorScannerPage.this.fMetadataScannersViewer.refresh(true);
                        }
                    }
                };
            }
        });
        this.fMetadataScannersViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners());
        if (this.editorInput.isLatest()) {
            this.fMetadataScannersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    LanguageDefinitionEditorScannerPage.this.updateScannerButtonEnablement();
                }
            });
        }
        this.createScannerEditingButtons(composite);
        this.fMetadataScannersSection.setClient((Control)composite);
    }

    private void createScannerEditingButtons(Composite parent) {
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fAddScannerButton = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_AddButton, 8);
        this.fAddScannerButton.setEnabled(true);
        this.fAddScannerButton.setData("name", (Object)"add.scanner.button");
        this.fAddScannerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorScannerPage.this.addScanners();
            }
        });
        this.fRemoveScannerButton = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_RemoveButton, 8);
        this.fRemoveScannerButton.setEnabled(false);
        this.fRemoveScannerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorScannerPage.this.removeScanners();
                LanguageDefinitionEditorScannerPage.this.updateScannerButtonEnablement();
            }
        });
        this.fMoveScannerUpButton = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_UpButton, 8);
        this.fMoveScannerUpButton.setEnabled(false);
        this.fMoveScannerUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorScannerPage.this.moveScanners(true);
                LanguageDefinitionEditorScannerPage.this.updateScannerButtonEnablement();
            }
        });
        this.fMoveScannerDownButton = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_DownButton, 8);
        this.fMoveScannerDownButton.setEnabled(false);
        this.fMoveScannerDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorScannerPage.this.moveScanners(false);
                LanguageDefinitionEditorScannerPage.this.updateScannerButtonEnablement();
            }
        });
        this.resizeButtons(new Button[]{this.fAddScannerButton, this.fRemoveScannerButton, this.fMoveScannerUpButton, this.fMoveScannerDownButton});
    }

    private void addScanners() {
        try {
            ITeamRepository repository = (ITeamRepository)this.fLanguageDefinitionWorkingCopy.getProjectArea().getOrigin();
            final IMetadataScannerClientLibrary library = (IMetadataScannerClientLibrary)repository.getClientLibrary(IMetadataScannerClientLibrary.class);
            this.scanners = new IFileMetadataScanner[0];
            IProjectArea projectArea = (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)this.fLanguageDefinitionWorkingCopy.getProjectArea(), 0, null);
            final ScannerSelectionDialog dialog = new ScannerSelectionDialog(this.getSite().getShell(), projectArea);
            LongRunningJobListener listener = new LongRunningJobListener(this.getSite().getShell()){

                @Override
                protected void onEnd() {
                    dialog.setElements((Object[])LanguageDefinitionEditorScannerPage.this.scanners);
                    if (dialog.open() == 0) {
                        Object[] selectedScanners;
                        Object[] objectArray = selectedScanners = dialog.getSelectedScanners();
                        int n = selectedScanners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFileMetadataScanner scanner = objectArray[n2];
                            StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
                            helper.setValue(scanner.getName());
                            LanguageDefinitionEditorScannerPage.this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().add(helper);
                            String scannerList = scanner.getDependencyTypes();
                            StringTokenizer scannerTokenizer = new StringTokenizer(scannerList, ",");
                            ArrayList<String> newDependencyTypes = new ArrayList<String>();
                            while (scannerTokenizer.hasMoreTokens()) {
                                newDependencyTypes.add(scannerTokenizer.nextToken());
                            }
                            List types = LanguageDefinitionEditorScannerPage.this.fLanguageDefinitionWorkingCopy.getDependencyTypes();
                            for (String typeString : newDependencyTypes) {
                                boolean exists = false;
                                for (IDependencyType type : types) {
                                    if (!type.getName().equals(typeString)) continue;
                                    exists = true;
                                    break;
                                }
                                if (exists) continue;
                                DependencyType t = ModelFactory.eINSTANCE.createDependencyType();
                                t.setLevel(0);
                                t.setName(typeString.trim());
                                types.add(t);
                            }
                            ++n2;
                        }
                        LanguageDefinitionEditorScannerPage.this.fMetadataScannersViewer.refresh();
                        LanguageDefinitionEditorScannerPage.this.fDependencyTypesControl.refreshDependencyTypesViewer();
                        StructuredSelection selection = new StructuredSelection(selectedScanners);
                        LanguageDefinitionEditorScannerPage.this.fMetadataScannersViewer.setSelection((ISelection)selection);
                        LanguageDefinitionEditorScannerPage.this.setDirty(true);
                    }
                }
            };
            LongRunningJob job = new LongRunningJob(listener){

                @Override
                protected void doTheWork(IProgressMonitor monitor) throws CoreException {
                    try {
                        LanguageDefinitionEditorScannerPage.this.scanners = library.getMetadataScannerByCategories(new String[]{"ibmi", "all"});
                        LanguageDefinitionEditorScannerPage.this.scanners = LanguageDefinitionEditorScannerPage.this.filterExistingScannerInLangDef(LanguageDefinitionEditorScannerPage.this.scanners);
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, "", e.getLocalizedMessage(), (Throwable)e));
                    }
                }
            };
            job.run(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IFileMetadataScanner[] filterExistingScannerInLangDef(IFileMetadataScanner[] scanners) {
        ArrayList<IFileMetadataScanner> result = new ArrayList<IFileMetadataScanner>();
        IFileMetadataScanner[] iFileMetadataScannerArray = scanners;
        int n = scanners.length;
        int n2 = 0;
        while (n2 < n) {
            IFileMetadataScanner scanner = iFileMetadataScannerArray[n2];
            if (!this.existInLangDef(scanner)) {
                result.add(scanner);
            }
            ++n2;
        }
        return result.toArray(new IFileMetadataScanner[0]);
    }

    private boolean existInLangDef(IFileMetadataScanner scanner) {
        List scanners = this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners();
        int i = 0;
        while (i < scanners.size()) {
            if (((IStringHelper)scanners.get(i)).getValue().equals(scanner.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeScanners() {
        int newSelectionIndex = -1;
        IStructuredSelection selection = (IStructuredSelection)this.fMetadataScannersViewer.getSelection();
        for (IStringHelper scanner : selection) {
            int index = this.indexOfScanner(scanner);
            this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().remove(index);
            newSelectionIndex = index + 1;
        }
        if (!selection.isEmpty()) {
            this.fMetadataScannersViewer.refresh();
            this.setDirty(true);
            int remainingItems = this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().size();
            if (remainingItems > 0) {
                this.fMetadataScannersViewer.getTable().setSelection(newSelectionIndex %= remainingItems);
            }
        }
    }

    private int indexOfScanner(IStringHelper scanner) {
        List list = this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners();
        int i = 0;
        while (i < list.size()) {
            IStringHelper next = (IStringHelper)list.get(i);
            if (next.getValue().equals(scanner.getValue())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createDependencyTypesSection(Composite parent) {
        this.fDependencyTypesSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fDependencyTypesSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fMetadataScannersSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fDependencyTypesSection.setLayoutData((Object)data);
        this.fDependencyTypesSection.setLayout((Layout)new GridLayout(1, false));
        this.fDependencyTypesSection.setText(Messages.LanguageDefinitionEditorScannerPage_DependencyTypesText);
        this.fDependencyTypesSection.setDescription(Messages.LanguageDefinitionEditorScannerPage_DependencyTypesDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fDependencyTypesSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite composite1 = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).hint(100, -1).applyTo((Control)composite1);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(5, 5).applyTo(composite1);
        this.fDependencyTypesSection.setClient((Control)composite);
        this.fDependencyTypesControl = new DependencyTypesControl(composite1, this.fToolkit, (ILanguageDefinition)this.fLanguageDefinitionWorkingCopy, this.getTeamRepository(), this.fLanguageDefinitionWorkingCopy.getProjectArea(), (TeamFormPage)this, this.editorInput.isLatest());
        this.fDependencyTypesControl.addListener(this.fDependencyTypesListener);
        this.fDependencyTypesControl.setTranslators(this.fLanguageDefinitionWorkingCopy.getTranslators());
        this.fDependencyTypesControl.setDependencyTypes(this.fLanguageDefinitionWorkingCopy.getDependencyTypes());
    }

    protected IGenericListener getDependencyTypesListener() {
        return new IGenericListener(){

            public void contentsModified() {
                LanguageDefinitionEditorScannerPage.this.setDirty(true);
            }
        };
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        if (item instanceof IIBMiLanguageDefinition) {
            this.fLanguageDefinitionWorkingCopy = (IIBMiLanguageDefinition)item;
        }
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_languageDefinitionIBMiScanners";
    }

    private void moveScanners(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.fMetadataScannersViewer.getSelection();
        if (up) {
            for (IStringHelper scanner : selection) {
                int index = this.indexOfScanner(scanner);
                this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().remove(index);
                this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().add(index - 1, scanner);
            }
        } else {
            for (IStringHelper scanner : selection) {
                int index = this.indexOfScanner(scanner);
                this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().remove(index);
                this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().add(index + 1, scanner);
            }
        }
        this.fMetadataScannersViewer.refresh();
        this.setDirty(true);
    }

    private void updateScannerButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.fMetadataScannersViewer.getSelection();
        boolean isEmptySelection = selection.isEmpty();
        this.fRemoveScannerButton.setEnabled(isEmptySelection);
        if (isEmptySelection) {
            this.fRemoveScannerButton.setEnabled(false);
            this.fMoveScannerUpButton.setEnabled(false);
            this.fMoveScannerDownButton.setEnabled(false);
        } else {
            this.fRemoveScannerButton.setEnabled(true);
            IStringHelper scanner = (IStringHelper)selection.getFirstElement();
            int index = this.indexOfScanner(scanner);
            this.fMoveScannerUpButton.setEnabled(index > 0);
            this.fMoveScannerDownButton.setEnabled(index + selection.size() < this.fLanguageDefinitionWorkingCopy.getSourceCodeDataScanners().size());
        }
    }

    private void resizeButtons(Button[] buttons) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        Button nextButton = buttons[0];
        GC gc = new GC((Drawable)nextButton);
        gc.setFont(nextButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        int i = 0;
        while (i < buttons.length) {
            nextButton = buttons[i];
            Point minSize = nextButton.computeSize(-1, -1, true);
            maxWidth = Math.max(maxWidth, minSize.x);
            ++i;
        }
        int i2 = 0;
        while (i2 < buttons.length) {
            nextButton = buttons[i2];
            GridData gridData = new GridData(128);
            gridData.widthHint = maxWidth;
            nextButton.setLayoutData((Object)gridData);
            ++i2;
        }
    }

    private void resolveSystemDefinitionCaches() {
        ITeamRepository fRepository = this.getTeamRepository();
        final LanguageDefinitionEditor fParentEditor = (LanguageDefinitionEditor)this.getEditor();
        if (fParentEditor.getTranslatorCache().isEmpty()) {
            final List translatorEntryList = this.fLanguageDefinitionWorkingCopy.getTranslators();
            SystemDefinitionJob job = new SystemDefinitionJob(Messages.LanguageDefinitionEditorGeneralPage_FetchTranslatorJob, false, fRepository){
                private Map<String, String> fTranslatorCache;
                {
                    super($anonymous0, $anonymous1, $anonymous2);
                    this.fTranslatorCache = new HashMap<String, String>();
                }

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    for (ITranslatorEntry entry : translatorEntryList) {
                        String translatorUuid;
                        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                            this.fTranslatorCache.put(entry.getValue(), entry.getValue());
                            continue;
                        }
                        String label = translatorUuid = entry.getValue();
                        if (translatorUuid.length() <= 0) continue;
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getJobTeamRepository());
                        ITranslatorHandle translatorHandle = (ITranslatorHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)translatorUuid), null);
                        ITranslator translator = (ITranslator)client.fetchSystemDefinition((ISystemDefinitionHandle)translatorHandle, Arrays.asList(ITranslator.NAME_PROPERTY), monitor);
                        label = translator != null ? translator.getName() : Messages.LanguageDefinitionEditorGeneralPage_translatorMissing;
                        this.fTranslatorCache.put(translatorUuid, label);
                    }
                    return Status.OK_STATUS;
                }

                protected void jobFinished(IStatus status) {
                    fParentEditor.setTranslatorCache(this.fTranslatorCache);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (LanguageDefinitionEditorScannerPage.this.fDependencyTypesControl != null) {
                                LanguageDefinitionEditorScannerPage.this.fDependencyTypesControl.refreshDependencyTypesViewer();
                            }
                        }
                    });
                }
            };
            job.schedule();
        }
    }

    public Map<String, String> getTranslatorCache() {
        return ((LanguageDefinitionEditor)this.getEditor()).getTranslatorCache();
    }

    public void refreshDependencyTypesControl() {
        if (this.fDependencyTypesControl != null) {
            this.fDependencyTypesControl.refreshDependencyTypesViewer();
        }
    }
}

