/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.client.scanner.MetadataScannerUtil;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.metadata.scanner.common.service.IMetadataScannerService;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DependencyType;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class LanguageDefinitionEditorInput
extends AbstractEditorInput {
    private IIBMiLanguageDefinition fLanguageDefinition;
    private IFileMetadataScanner fDefaultScanner;

    public LanguageDefinitionEditorInput(ISystemDefinition languageDefinition, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        super(languageDefinition, projectArea);
    }

    public LanguageDefinitionEditorInput(ISystemDefinition languageDefinition, IProjectAreaHandle projectArea, AbstractEnterpriseExtensionsNode node) throws TeamRepositoryException {
        super(languageDefinition, projectArea, node);
    }

    public String getEditorId() {
        return "com.ibm.team.enterprise.ibmi.systemdefinition.ui.editors.languageDefinitionEditor";
    }

    public ISystemDefinition getSystemDefinition() {
        return this.fLanguageDefinition;
    }

    public void initializeEditorInput(ISystemDefinition systemDefinition) {
        this.fLanguageDefinition = (IIBMiLanguageDefinition)systemDefinition;
        if (this.fLanguageDefinition == null) {
            this.fIsNewSystemDefinition = true;
            this.fLanguageDefinition = (IIBMiLanguageDefinition)IIBMiLanguageDefinition.ITEM_TYPE.createItem();
            this.fLanguageDefinition.setProjectArea(this.getProjectArea());
            this.addDefaultScanner();
        } else {
            this.fIsNewSystemDefinition = false;
        }
    }

    private void addDefaultScanner() {
        ITeamRepository fTeamRepository = this.getTeamRepository();
        if (this.fLanguageDefinition != null && fTeamRepository != null) {
            this.fDefaultScanner = null;
            this.fetchDefaultScannerInBackground();
            if (this.fDefaultScanner != null) {
                StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
                helper.setValue(this.fDefaultScanner.getName());
                this.fLanguageDefinition.getSourceCodeDataScanners().add(helper);
                List defaultDependencyTypes = MetadataScannerUtil.getDependencyTypes((IFileMetadataScanner)this.fDefaultScanner);
                List types = this.fLanguageDefinition.getDependencyTypes();
                if (defaultDependencyTypes != null) {
                    for (String type : defaultDependencyTypes) {
                        DependencyType t = ModelFactory.eINSTANCE.createDependencyType();
                        t.setLevel(0);
                        t.setName(type);
                        if (types == null) continue;
                        types.add(t);
                    }
                }
            }
        }
    }

    private void fetchDefaultScannerInBackground() {
        Job fetchScannerJob = new Job(Messages.LanguageDefinitionEditorInput_FetchingScanner){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IMetadataScannerClientLibrary library = (IMetadataScannerClientLibrary)LanguageDefinitionEditorInput.this.getTeamRepository().getClientLibrary(IMetadataScannerClientLibrary.class);
                    LanguageDefinitionEditorInput.this.fDefaultScanner = library.getDefaultMetadataScanner(IMetadataScannerService.Platform.ibmi);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        fetchScannerJob.schedule();
        try {
            fetchScannerJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

