/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LanguageDefinitionEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.ScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.TranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ScopedPropertyDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.TranslatorEntryDialog;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.util.ScopedPropertiesLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.util.TranslatorEntryLabelProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LanguageDefinitionEditorGeneralPage
extends AbstractSystemDefinitionEditorPage
implements ITranslatorEntryConsumer {
    private final String[] languageConstants = new String[]{"COB", "RPGLE", "RPG", "CLLE", "CL", "DSPF", "PF", "LF", "PRTF", "PGM", "SRVPGM", "OTH"};
    private final String[] languageStrings = new String[]{Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_COBOL, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_RPG_ILE, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_RPG_OPM, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_CL_ILE, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_CL_OPM, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_DSPF, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PF, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_LF, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PRTF, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_PGM, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_SRVPGM, Messages.LanguageDefinitionEditorGeneralPage_LANGUAGE_OTHER};
    private IIBMiLanguageDefinition fLanguageDefinitionWorkingCopy;
    private FormToolkit fToolkit;
    private Section fGeneralSection;
    private Section fTranslatorsSection;
    private Section fPropertiesSection;
    private Combo fLanguageCombo;
    private Text fDescriptionText;
    private Text fPatternsText;
    private TableViewer fTranslatorTableViewer;
    private TableViewer fPropertiesViewer;
    private Button fNonImpactingCheckbox;
    private Button fDontCalculateImpactsCheckbox;
    private static final int ADD_BUTTON = 0;
    private static final int EDIT_BUTTON = 1;
    private static final int REMOVE_BUTTON = 2;
    private static final int UP_BUTTON = 3;
    private static final int DOWN_BUTTON = 4;
    private static final int PROPERTIES_OFFSET = 5;
    private final Button[] buttons = new Button[10];
    private final ISelectionChangedListener fTranslatorTableListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LanguageDefinitionEditorGeneralPage.this.updateButtonEnablement();
        }
    };

    public LanguageDefinitionEditorGeneralPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        if (item instanceof IIBMiLanguageDefinition) {
            this.fLanguageDefinitionWorkingCopy = (IIBMiLanguageDefinition)item;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer != null && !LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer.getControl().isDisposed()) {
                        LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer.setInput((Object)LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.getTranslators());
                    }
                    if (LanguageDefinitionEditorGeneralPage.this.fPropertiesViewer != null && !LanguageDefinitionEditorGeneralPage.this.fPropertiesViewer.getControl().isDisposed()) {
                        LanguageDefinitionEditorGeneralPage.this.fPropertiesViewer.setInput((Object)LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                    }
                }
            });
        }
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.resolveSystemDefinitionCaches();
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 10;
        parent.setLayout((Layout)formLayout);
        this.createGeneralSection(parent);
        this.createTranslatorsSection(parent);
        this.createPropertiesSection(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout(1, false));
        this.fGeneralSection.setText(Messages.SystemDefinitionEditor_General);
        this.fGeneralSection.setDescription(Messages.LanguageDefinitionEditorGeneralPage_GeneralDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fGeneralSection.setClient((Control)composite);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.createLabel(this.fToolkit, composite, Messages.LanguageDefinitionEditorGeneralPage_LanguageLabel, null);
        this.fLanguageCombo = new Combo(composite, 12);
        this.fLanguageCombo.setItems(this.languageStrings);
        this.fLanguageCombo.select(this.getLanguageIndex(this.fLanguageDefinitionWorkingCopy.getLanguageCode()));
        this.fLanguageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.handleLanguageSelected();
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fLanguageCombo);
        this.createSpacer(this.fToolkit, composite, 5, 4);
        this.createLabel(this.fToolkit, composite, Messages.LanguageDefinitionEditorGeneralPage_PatternLabel, null);
        this.fPatternsText = this.createText(this.fToolkit, composite, SystemDefinitionUtil.joinStringHelper((List)this.fLanguageDefinitionWorkingCopy.getDefaultPatterns(), (String)","), 3);
        this.createLabel(this.fToolkit, composite, "", "");
        Text descriptionLabel = new Text(composite, 72);
        descriptionLabel.setText(Messages.LanguageDefinitionEditorGeneralPage_PatternDescription);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)descriptionLabel);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.fPatternsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LanguageDefinitionEditorGeneralPage.this.validateFileExtension()) {
                    LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.getDefaultPatterns().clear();
                    LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.getDefaultPatterns().addAll(SystemDefinitionUtil.splitStringHelper((String)LanguageDefinitionEditorGeneralPage.this.fPatternsText.getText().trim(), (String)","));
                }
                LanguageDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
        this.createSpacer(this.fToolkit, composite, 5, 4);
        this.createLabel(this.fToolkit, composite, Messages.SystemDefinitionEditor_DescriptionText, Messages.SystemDefinitionEditor_ResourceDescriptionTooltip);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fLanguageDefinitionWorkingCopy.getDescription(), 2626);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.fDescriptionText.setLayoutData((Object)gridData);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.setDescription(LanguageDefinitionEditorGeneralPage.this.fDescriptionText.getText().trim());
                LanguageDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        this.fNonImpactingCheckbox.setToolTipText(Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fNonImpactingCheckbox);
        this.fNonImpactingCheckbox.setSelection(this.fLanguageDefinitionWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.setNonImpacting(LanguageDefinitionEditorGeneralPage.this.fNonImpactingCheckbox.getSelection());
                LanguageDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
        this.fDontCalculateImpactsCheckbox = this.fToolkit.createButton(composite, Messages.LanguageDefinitionEditorGeneralPage_DONT_CALCULATE_IMPACTS_LABEL, 32);
        this.fDontCalculateImpactsCheckbox.setToolTipText(Messages.LanguageDefinitionEditorGeneralPage_DONT_CALCULATE_IMPACTS_DESCRIPTION);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fDontCalculateImpactsCheckbox);
        this.fDontCalculateImpactsCheckbox.setSelection(!this.fLanguageDefinitionWorkingCopy.isCalculateImpacts());
        this.fDontCalculateImpactsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.fLanguageDefinitionWorkingCopy.setCalculateImpacts(!LanguageDefinitionEditorGeneralPage.this.fDontCalculateImpactsCheckbox.getSelection());
                LanguageDefinitionEditorGeneralPage.this.setDirty(true);
            }
        });
    }

    private int getLanguageIndex(String languageCode) {
        int i = 0;
        while (i < this.languageConstants.length) {
            if (this.languageConstants[i].equals(languageCode)) break;
            ++i;
        }
        return i;
    }

    private void handleLanguageSelected() {
        int i = this.fLanguageCombo.getSelectionIndex();
        this.fLanguageDefinitionWorkingCopy.setLanguageCode(this.languageConstants[i]);
        this.setDirty(true);
    }

    private void createTranslatorsSection(Composite parent) {
        this.fTranslatorsSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fTranslatorsSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.fGeneralSection, 0, 131072);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.fGeneralSection, 0, 1024);
        this.fTranslatorsSection.setLayoutData((Object)data);
        this.fTranslatorsSection.setLayout((Layout)new GridLayout(1, false));
        this.fTranslatorsSection.setText(Messages.LanguageDefinitionEditorGeneralPage_TranslatorsText);
        this.fTranslatorsSection.setDescription(Messages.LanguageDefinitionEditorGeneralPage_TranslatorsDescription);
        Composite composite = this.fToolkit.createComposite((Composite)this.fTranslatorsSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fToolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.grabExcessVerticalSpace = true;
        Table table = this.fToolkit.createTable(tableComposite, 66304);
        table.setHeaderVisible(true);
        gridData.heightHint = table.getItemHeight() * 10;
        gridData.widthHint = 100;
        tableComposite.setLayoutData((Object)gridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_TranslatorsTableColumnTranslator);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_TranslatorsTableColumnCondition);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_TranslatorsTableColumnStepName);
        tableComposite.setLayout((Layout)tableLayout);
        this.fTranslatorTableViewer = new TableViewer(table);
        this.fTranslatorTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fTranslatorTableViewer.setLabelProvider((IBaseLabelProvider)new TranslatorEntryLabelProvider(this.fTranslatorTableViewer, (ITeamRepository)this.fLanguageDefinitionWorkingCopy.getProjectArea().getOrigin(), this.fLanguageDefinitionWorkingCopy.getProjectArea(), (ITranslatorEntryConsumer)this));
        this.fTranslatorTableViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
        this.fTranslatorTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        if (this.isEditable()) {
            this.fTranslatorTableViewer.addOpenListener(this.getOpenListener());
        }
        this.createButtonBar(composite, this.fTranslatorTableViewer);
        this.fTranslatorsSection.setClient((Control)composite);
    }

    private void createButtonBar(Composite parent, final TableViewer viewer) {
        int offset = 0;
        if (viewer.equals(this.fPropertiesViewer)) {
            offset = 5;
        }
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.buttons[offset + 0] = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_AddButton, 8);
        this.buttons[offset + 0].setEnabled(true);
        this.buttons[offset + 0].setData("name", (Object)"add.translator.button");
        this.buttons[offset + 0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageDefinitionEditorGeneralPage.this.addEntry(viewer);
            }
        });
        this.buttons[offset + 1] = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_EditButton, 8);
        this.buttons[offset + 1].setEnabled(false);
        this.buttons[offset + 1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.editEntry(viewer);
            }
        });
        this.buttons[offset + 2] = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_RemoveButton, 8);
        this.buttons[offset + 2].setEnabled(false);
        this.buttons[offset + 2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.removeSelectedEntries(viewer);
            }
        });
        this.buttons[offset + 3] = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_UpButton, 8);
        this.buttons[offset + 3].setEnabled(false);
        this.buttons[offset + 3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageDefinitionEditorGeneralPage.this.moveEntries(true, viewer);
            }
        });
        this.buttons[offset + 4] = this.fToolkit.createButton(buttonBar, Messages.SystemDefinitionEditor_DownButton, 8);
        this.buttons[offset + 4].setEnabled(false);
        this.buttons[offset + 4].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageDefinitionEditorGeneralPage.this.moveEntries(false, viewer);
            }
        });
        this.setButtonLayoutData(this.buttons[offset + 0], this.buttons[offset + 1], this.buttons[offset + 2], this.buttons[offset + 3], this.buttons[offset + 4]);
    }

    private void addEntry(TableViewer tableViewer) {
        if (tableViewer == this.fTranslatorTableViewer) {
            try {
                IProjectArea projArea = null;
                projArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fLanguageDefinitionWorkingCopy.getProjectArea(), 0, null);
                TranslatorEntry translatorEntry = ModelFactory.eINSTANCE.createTranslatorEntry();
                TranslatorEntryDialog dialog = new TranslatorEntryDialog(this.getSite().getShell(), com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.ADD_TRANSLATOR_TITLE, (ITranslatorEntry)translatorEntry, true, IIBMiTranslator.ITEM_TYPE, this.getTeamRepository(), (IProjectAreaHandle)projArea, this.getTranslatorCache());
                if (dialog.open() == 0) {
                    String translatorEntryValue = dialog.getTranslatorEntryValue();
                    Map<String, String> translatorCache = this.getTranslatorCache();
                    translatorEntry.setKind(dialog.getTranslatorEntryKind());
                    translatorEntry.setValue(translatorEntryValue);
                    translatorEntry.setCondition(dialog.getTranslatorEntryCondition());
                    translatorEntry.setStepName(dialog.getTranslatorEntryStepName());
                    this.fLanguageDefinitionWorkingCopy.getTranslators().add(translatorEntry);
                    if (!translatorCache.containsKey(translatorEntryValue)) {
                        translatorCache.put(translatorEntryValue, dialog.getTranslatorEntryName());
                    }
                    this.fTranslatorTableViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorTableViewer.refresh();
                    this.fTranslatorTableViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getTranslators().indexOf(translatorEntry));
                    this.setDirty(true);
                }
            }
            catch (TeamRepositoryException ex) {
                ex.printStackTrace();
            }
        } else if (tableViewer == this.fPropertiesViewer) {
            ScopedProperty property = ModelFactory.eINSTANCE.createScopedProperty();
            ScopedPropertyDialog dialog = new ScopedPropertyDialog(this.getSite().getShell(), (IScopedProperty)property, com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.ADD_SCOPED_PROPERTY_TITLE, this.fLanguageDefinitionWorkingCopy.getScopedProperties());
            if (dialog.open() == 0) {
                this.fLanguageDefinitionWorkingCopy.getScopedProperties().add(property);
                this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                this.fPropertiesViewer.refresh();
                this.fPropertiesViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getScopedProperties().indexOf(property));
                this.setDirty(true);
            }
        }
    }

    private void editEntry(TableViewer tableViewer) {
        try {
            if (tableViewer == this.fTranslatorTableViewer && this.getSelectedTranslatorEntry() != null) {
                ITranslatorEntry translatorEntry = this.getSelectedTranslatorEntry();
                IProjectArea projArea = null;
                projArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fLanguageDefinitionWorkingCopy.getProjectArea(), 0, null);
                TranslatorEntryDialog dialog = new TranslatorEntryDialog(this.getSite().getShell(), com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.EDIT_TRANSLATOR_TITLE, translatorEntry, true, IIBMiTranslator.ITEM_TYPE, this.getTeamRepository(), (IProjectAreaHandle)projArea, this.getTranslatorCache());
                if (dialog.open() == 0) {
                    String translatorEntryValue = dialog.getTranslatorEntryValue();
                    Map<String, String> translatorCache = this.getTranslatorCache();
                    translatorEntry.setKind(dialog.getTranslatorEntryKind());
                    translatorEntry.setValue(translatorEntryValue);
                    translatorEntry.setCondition(dialog.getTranslatorEntryCondition());
                    translatorEntry.setStepName(dialog.getTranslatorEntryStepName());
                    if (!translatorCache.containsKey(translatorEntryValue)) {
                        translatorCache.put(translatorEntryValue, dialog.getTranslatorEntryName());
                    }
                    this.fTranslatorTableViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorTableViewer.refresh();
                    this.fTranslatorTableViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getTranslators().indexOf(translatorEntry));
                    this.setDirty(true);
                }
            } else if (tableViewer == this.fPropertiesViewer) {
                IScopedProperty property = (IScopedProperty)((IStructuredSelection)this.fPropertiesViewer.getSelection()).getFirstElement();
                ScopedProperty tmp = ModelFactory.eINSTANCE.createScopedProperty();
                tmp.setCondition(property.getCondition());
                tmp.setName(property.getName());
                tmp.setValue(property.getValue());
                String title = com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.EDIT_SCOPED_PROPERTY_TITLE;
                ScopedPropertyDialog dialog = new ScopedPropertyDialog(this.getSite().getShell(), (IScopedProperty)tmp, title, this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                if (dialog.open() == 0) {
                    property.setCondition(tmp.getCondition());
                    property.setName(tmp.getName());
                    property.setValue(tmp.getValue());
                    this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                    this.fPropertiesViewer.refresh();
                    this.fPropertiesViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getScopedProperties().indexOf(property));
                    this.setDirty(true);
                }
            }
        }
        catch (TeamRepositoryException ex) {
            ex.printStackTrace();
        }
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return this.fTranslatorTableListener;
    }

    private void moveEntries(boolean up, TableViewer tableViewer) {
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        int offset = up ? -1 : 1;
        List workingCopyList = null;
        workingCopyList = tableViewer == this.fTranslatorTableViewer ? this.fLanguageDefinitionWorkingCopy.getTranslators() : this.fLanguageDefinitionWorkingCopy.getScopedProperties();
        for (Object entry : selection) {
            int index = workingCopyList.indexOf(entry);
            if (index <= -1) continue;
            workingCopyList.remove(index);
            workingCopyList.add(index + offset, entry);
            tableViewer.setInput((Object)workingCopyList);
        }
        this.updateButtonEnablement();
        tableViewer.refresh();
        this.setDirty(true);
    }

    private ITranslatorEntry getSelectedTranslatorEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.fTranslatorTableViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ITranslatorEntry) {
            return (ITranslatorEntry)element;
        }
        return null;
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){
            ITranslator translator = null;

            public void open(OpenEvent event) {
                ITranslatorEntry translatorEntry;
                IStructuredSelection selection = (IStructuredSelection)LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer.getSelection();
                if (selection.size() == 1 && (translatorEntry = LanguageDefinitionEditorGeneralPage.this.getSelectedTranslatorEntry()).getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) {
                    String translatorUUID = translatorEntry.getValue();
                    try {
                        this.translator = null;
                        this.fetchTranslator(translatorUUID);
                        if (this.translator != null) {
                            EditSystemDefinitionActionDelegate.run((ISystemDefinition)this.translator, this.translator.getProjectArea(), LanguageDefinitionEditorGeneralPage.this.getSite().getPage(), true, true);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }

            private void fetchTranslator(final String translatorUUID) {
                Job fetchTranslatorEditorJob = new Job(Messages.LanguageDefinitionEditorGeneralPage_FetchTranslatorJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)LanguageDefinitionEditorGeneralPage.this.getTeamRepository());
                        try {
                            translator = (ITranslator)client.findSystemDefinitionComplete(translatorUUID, null, IIBMiTranslator.ITEM_TYPE, monitor);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                fetchTranslatorEditorJob.schedule();
                try {
                    fetchTranslatorEditorJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void updateButtonEnablement() {
        TableViewer[] tableViewerArray = new TableViewer[]{this.fTranslatorTableViewer, this.fPropertiesViewer};
        int n = tableViewerArray.length;
        int n2 = 0;
        while (n2 < n) {
            List workingList;
            TableViewer tv = tableViewerArray[n2];
            int offset = 0;
            if (tv.equals(this.fPropertiesViewer)) {
                offset = 5;
                workingList = this.fLanguageDefinitionWorkingCopy.getScopedProperties();
            } else {
                workingList = this.fLanguageDefinitionWorkingCopy.getTranslators();
            }
            IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
            if (!selection.isEmpty()) {
                int size = selection.size();
                Object first = selection.getFirstElement();
                this.buttons[offset + 2].setEnabled(true);
                this.buttons[offset + 1].setEnabled(true);
                if (workingList.indexOf(first) == 0) {
                    this.buttons[offset + 3].setEnabled(false);
                } else {
                    this.buttons[offset + 3].setEnabled(true);
                }
                if (workingList.indexOf(first) + size == workingList.size()) {
                    this.buttons[offset + 4].setEnabled(false);
                } else {
                    this.buttons[offset + 4].setEnabled(true);
                }
            } else {
                this.buttons[offset + 4].setEnabled(false);
                this.buttons[offset + 3].setEnabled(false);
                this.buttons[offset + 2].setEnabled(false);
                this.buttons[offset + 1].setEnabled(false);
            }
            ++n2;
        }
    }

    private void removeSelectedEntries(TableViewer tableViewer) {
        ISelection selection;
        boolean deleteConfirmed;
        if (tableViewer == this.fTranslatorTableViewer) {
            ISelection selection2;
            boolean deleteConfirmed2 = MessageDialog.openQuestion((Shell)this.fTranslatorsSection.getShell(), (String)Messages.LanguageDefinitionEditorGeneralPage_TRANSLATOR_DELETE_CONFIRM_TITLE, (String)Messages.LanguageDefinitionEditorGeneralPage_TRANSLATOR_DELETE_CONFIRM);
            if (deleteConfirmed2 && (selection2 = this.fTranslatorTableViewer.getSelection()) instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection2;
                ArrayList<ITranslatorEntry> entriesRemoved = new ArrayList<ITranslatorEntry>();
                for (ITranslatorEntry translator : structuredSelection) {
                    this.fLanguageDefinitionWorkingCopy.getTranslators().remove(translator);
                    for (IDependencyType dt : this.fLanguageDefinitionWorkingCopy.getDependencyTypes()) {
                        ArrayList<ITranslatorEntry> toRemove = new ArrayList<ITranslatorEntry>();
                        for (ITranslatorEntry te : dt.getTranslators()) {
                            if (!te.getValue().equals(translator.getValue())) continue;
                            toRemove.add(te);
                        }
                        if (!toRemove.isEmpty()) {
                            dt.getTranslators().removeAll(toRemove);
                        }
                        if (dt.getLevel() != 2 || dt.getTranslators().size() != 0) continue;
                        dt.setLevel(1);
                    }
                    entriesRemoved.add(translator);
                }
                if (!entriesRemoved.isEmpty()) {
                    this.fTranslatorTableViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorTableViewer.refresh();
                    this.setDirty(true);
                    this.updateButtonEnablement();
                }
            }
        } else if (tableViewer == this.fPropertiesViewer && (deleteConfirmed = MessageDialog.openQuestion((Shell)this.fTranslatorsSection.getShell(), (String)Messages.LanguageDefinitionEditorGeneralPage_PROPERTY_DELETE_CONFIRM_TITLE, (String)Messages.LanguageDefinitionEditorGeneralPage_PROPERTY_DELETE_CONFIRM)) && (selection = this.fPropertiesViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            boolean propsRemoved = false;
            for (IScopedProperty property : structuredSelection) {
                if (!this.fLanguageDefinitionWorkingCopy.getScopedProperties().remove(property)) continue;
                propsRemoved = true;
            }
            if (propsRemoved) {
                this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                this.fPropertiesViewer.refresh();
                this.setDirty(true);
                this.updateButtonEnablement();
            }
        }
    }

    private void setButtonLayoutData(Button ... buttons) {
        GC gc = new GC((Drawable)buttons[0]);
        gc.setFont(buttons[0].getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            Point minSize = b.computeSize(-1, -1, true);
            maxWidth = Math.max(maxWidth, minSize.x);
            ++n2;
        }
        Button[] buttonArray2 = buttons;
        int n3 = buttons.length;
        n = 0;
        while (n < n3) {
            Button b = buttonArray2[n];
            GridData gridData = new GridData(128);
            gridData.widthHint = maxWidth;
            b.setLayoutData((Object)gridData);
            ++n;
        }
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (!this.validateFileExtension()) {
            isValid = false;
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateFileExtension() {
        boolean isValid = true;
        String extension = this.fPatternsText.getText().trim();
        String[] exts = extension.trim().split(",");
        boolean passed = true;
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (!Pattern.matches("[a-zA-Z0-9]*", e.trim())) {
                passed = false;
                break;
            }
            ++n2;
        }
        if (!passed) {
            this.addErrorMessage((Object)this.fPatternsText, Messages.LanguageDefinitionEditorGeneralPage_INVALID_FILE_EXTENSION, (Control)this.fPatternsText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fPatternsText, (Control)this.fPatternsText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_languageDefinitionIBMiGeneral";
    }

    private void resolveSystemDefinitionCaches() {
        ITeamRepository fRepository = this.getTeamRepository();
        final LanguageDefinitionEditor fParentEditor = (LanguageDefinitionEditor)this.getEditor();
        if (fParentEditor.getTranslatorCache().isEmpty()) {
            final List translatorEntryList = this.fLanguageDefinitionWorkingCopy.getTranslators();
            SystemDefinitionJob job = new SystemDefinitionJob(Messages.LanguageDefinitionEditorGeneralPage_FetchTranslatorJob, false, fRepository){
                private final Map<String, String> fTranslatorCache;
                {
                    super($anonymous0, $anonymous1, $anonymous2);
                    this.fTranslatorCache = new HashMap<String, String>();
                }

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    for (ITranslatorEntry entry : translatorEntryList) {
                        String translatorUuid;
                        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                            this.fTranslatorCache.put(entry.getValue(), entry.getValue());
                            continue;
                        }
                        String label = translatorUuid = entry.getValue();
                        if (translatorUuid.length() <= 0) continue;
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getJobTeamRepository());
                        IIBMiTranslatorHandle handle = (IIBMiTranslatorHandle)IIBMiTranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)translatorUuid), null);
                        ITranslator translator = (ITranslator)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ITranslator.NAME_PROPERTY, ITranslator.ARCHIVED_PROPERTY), monitor);
                        if (translator != null) {
                            label = translator.getName();
                            if (translator.isArchived()) {
                                label = String.valueOf(label) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                            }
                        } else {
                            label = Messages.LanguageDefinitionEditorGeneralPage_translatorMissing;
                        }
                        this.fTranslatorCache.put(translatorUuid, label);
                    }
                    return Status.OK_STATUS;
                }

                protected void jobFinished(IStatus status) {
                    fParentEditor.setTranslatorCache(this.fTranslatorCache);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer != null && !LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer.getControl().isDisposed()) {
                                LanguageDefinitionEditorGeneralPage.this.fTranslatorTableViewer.refresh(true);
                            }
                        }
                    });
                }
            };
            job.schedule();
        }
    }

    public Map<String, String> getTranslatorCache() {
        return ((LanguageDefinitionEditor)this.getEditor()).getTranslatorCache();
    }

    protected void createPropertiesSection(Composite parent) {
        this.fPropertiesSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fPropertiesSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.fPropertiesSection.setLayoutData((Object)data);
        this.fPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        this.fPropertiesSection.setText(Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_HEADER);
        this.fPropertiesSection.setDescription(Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fPropertiesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fToolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.grabExcessVerticalSpace = true;
        Table table = this.fToolkit.createTable(tableComposite, 66304);
        table.setHeaderVisible(true);
        gridData.heightHint = table.getItemHeight() * 10;
        gridData.widthHint = 100;
        tableComposite.setLayoutData((Object)gridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(30, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_TABLE_COLUMN_PROPERTY);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(30, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_TABLE_COLUMN_VALUE);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(40, true));
        tc.setText(Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_TABLE_COLUMN_CONDITION);
        tableComposite.setLayout((Layout)tableLayout);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible a = (Accessible)e.getSource();
                if (a.getControl() instanceof Table && ((Table)a.getControl()).getItemCount() == 0) {
                    e.result = Messages.LanguageDefinitionEditorGeneralPage_PROPERTIES_DESCRIPTION;
                }
            }
        });
        this.fPropertiesViewer = new TableViewer(table);
        this.fPropertiesViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new ScopedPropertiesLabelProvider());
        this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
        this.fPropertiesViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.createButtonBar(composite, this.fPropertiesViewer);
        this.fPropertiesSection.setClient((Control)composite);
    }
}

