/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LanguageDefinitionEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.ResourceDefinitionEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SearchPathEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.TranslatorEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.helper.IBMiSystemDefHistoryHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISysDefUIObserver;
import com.ibm.team.enterprise.systemdefinition.ui.editors.pages.SysDefHistoryPage;
import com.ibm.team.enterprise.systemdefinition.ui.helper.SystemDefHistoryHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LangDefHistoryPageAdapter
extends AbstractSystemDefinitionEditorPage {
    private SysDefHistoryPage historyPage = null;
    private IWorkbenchPart editor = null;
    private ISysDefUIObserver observer = null;

    public LangDefHistoryPageAdapter(String elementId, String title) {
        super(elementId, title);
        this.historyPage = new SysDefHistoryPage(elementId, title);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        this.historyPage.setWorkingCopy(item);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.historyPage.createContent(parent, toolkit, this.getSite());
        this.editor = this.getSite().getPart();
        this.observer = (ISysDefUIObserver)this.editor.getAdapter(ISysDefUIObserver.class);
        this.observer.addListener(this.historyPage.getHistoryLogListener());
    }

    @Override
    public boolean validate() {
        return this.historyPage.validate();
    }

    @Override
    public String getContextHelpId() {
        if (this.editor instanceof TranslatorEditor) {
            return "com.ibm.team.build.ui.editor_ibmitranslator_history";
        }
        if (this.editor instanceof SearchPathEditor) {
            return "com.ibm.team.build.ui.editor_searchPath_history";
        }
        if (this.editor instanceof ResourceDefinitionEditor) {
            return "com.ibm.team.build.ui.editor_existinglibraryDefinition_history";
        }
        if (this.editor instanceof LanguageDefinitionEditor) {
            return "com.ibm.team.build.ui.editor_languageDefinitionIBMiHistory";
        }
        return "com.ibm.team.build.ui.editor_languageDefinitionIBMiHistory";
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.historyPage.init(site, input);
        this.historyPage.setHistoryHelper((SystemDefHistoryHelper)new IBMiSystemDefHistoryHelper(this.getSystemDefinitionCache(), this.getTeamRepository()));
    }

    public void dispose() {
        if (this.editor != null && this.observer != null) {
            this.editor = this.getSite().getPart();
            this.observer.removeListener(this.historyPage.getHistoryLogListener());
            this.historyPage.dispose();
        }
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.historyPage.getToolkit();
    }
}

