/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LangDefHistoryPageAdapter;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractSystemDefinitionEditorPage
extends TeamFormPage {
    private ITeamRepository fTeamRepository;
    private IManagedForm fManagedForm;
    private Composite fContentContainer;
    private boolean fDirty;
    private AbstractSystemDefinitionEditor fEditor;

    public AbstractSystemDefinitionEditorPage(String elementId, String title) {
        super(elementId, title);
    }

    public abstract void setWorkingCopy(ISystemDefinition var1);

    public abstract void createContent(Composite var1, FormToolkit var2);

    protected abstract FormToolkit getToolkit();

    public abstract boolean validate();

    public Control getFocusControl() {
        return null;
    }

    public void initialize(AbstractSystemDefinitionEditor editor) {
        super.initialize((FormEditor)editor);
        this.fEditor = editor;
        this.fTeamRepository = editor.getTeamRepository();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        managedForm.getToolkit().setBorderStyle(2048);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        this.fContentContainer = this.createContentContainer(this.fManagedForm);
        this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
        this.handleReadOnlyMode(this.fContentContainer);
    }

    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected ISystemDefinitionCache getSystemDefinitionCache() {
        return ((AbstractSystemDefinitionEditor)this.getEditor()).getSystemDefinitionCache();
    }

    public void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.fEditor.setDirty(isDirty);
        this.fEditor.fireDirtyPropertyChangeEvent();
    }

    public void refresh() {
        if (this.fContentContainer != null && !this.fContentContainer.isDisposed()) {
            this.fContentContainer.dispose();
            this.fContentContainer = this.createContentContainer(this.fManagedForm);
            this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
            this.validate();
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private Composite createContentContainer(IManagedForm managedForm) {
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        return container;
    }

    protected void setPageErrorIndicator(boolean isError) {
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fEditor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.fEditor.isSaveAttempted()) {
            this.fEditor.addErrorMessage(id, message, control, this.getIndex());
        }
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.fEditor.addErrorMessage(id, message, status);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.fEditor.removeErrorMessage(id, control);
    }

    public void removeErrorMessage(Object id) {
        this.fEditor.removeErrorMessage(id);
    }

    public void setFocus() {
        if (this.getFocusControl() != null) {
            this.getFocusControl().setFocus();
        } else {
            ((AbstractSystemDefinitionEditor)this.getEditor()).setFocusInHeader();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), this.getContextHelpId());
        }
    }

    protected abstract String getContextHelpId();

    protected void createSpacer(FormToolkit fToolkit, Composite parent, int height, int horizontalSpan) {
        Label label = fToolkit.createLabel(parent, "");
        GridData gridData = new GridData(4, 4, true, true, horizontalSpan, 1);
        gridData.heightHint = height;
        label.setLayoutData((Object)gridData);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue) {
        return this.createLabeledText(fToolkit, parent, label, tooltip, textValue, 1);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue, int horizontalSpan) {
        Label l = fToolkit.createLabel(parent, label);
        l.setToolTipText(tooltip);
        Text text = fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256, 128, 1, horizontalSpan));
        return text;
    }

    protected Label createLabel(FormToolkit fToolkit, Composite parent, String label, String tooltip) {
        Label l = fToolkit.createLabel(parent, label);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        l.setLayoutData((Object)gridData);
        l.setToolTipText(tooltip);
        return l;
    }

    protected Text createText(FormToolkit fToolkit, Composite parent, String textValue, int horizontalSpan) {
        Text text = fToolkit.createText(parent, textValue);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void handleReadOnlyMode(Composite comp) {
        AbstractEditorInput editorInput = (AbstractEditorInput)this.getEditorInput();
        if (!editorInput.isLatest() && !this.isHistoryPage()) {
            int i = 0;
            while (i < comp.getChildren().length) {
                this.toggleChildrenControls(comp);
                ++i;
            }
        }
    }

    private void toggleChildrenControls(Composite comp) {
        int i = 0;
        while (i < comp.getChildren().length) {
            Control thisCon = comp.getChildren()[i];
            if (thisCon instanceof Button || thisCon instanceof Combo || thisCon instanceof Text || thisCon instanceof List) {
                thisCon.setEnabled(false);
            } else if (thisCon instanceof Table) {
                Listener[] listeners;
                Listener[] listenerArray = listeners = ((Table)thisCon).getListeners(13);
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener thisListener = listenerArray[n2];
                    ((Table)thisCon).removeListener(13, thisListener);
                    ++n2;
                }
            } else if (thisCon instanceof Composite) {
                this.toggleChildrenControls((Composite)thisCon);
            }
            ++i;
        }
    }

    protected boolean isHistoryPage() {
        return this instanceof LangDefHistoryPageAdapter;
    }

    protected boolean isEditable() {
        AbstractEditorInput editorInput = (AbstractEditorInput)this.getEditorInput();
        return editorInput.isLatest();
    }
}

