/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.actions.SystemDefDomainActionHelper;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.LoadObjectLibraryNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.ResourceDefinitionsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;

public class LoadObjectLibrariesNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fFetchInProgress;

    public LoadObjectLibrariesNodeEE(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot, ResourceDefinitionsNodeEE resourceDefsNodeEE, Viewer viewer) {
        this.setProjectAreaHandle(projectAreaHandle);
        this.setDomainSubtreeRoot(domainSubtreeRoot);
        this.setParent((IEnterpriseExtensionsNode)resourceDefsNodeEE);
        this.setViewer(viewer);
    }

    public Image getIcon() {
        return DefUIPlugin.getImage("icons/obj16/libdef_fldr.gif");
    }

    public String getLabel() {
        return Messages.LoadObjectLibrariesNodeEE_TargetLibraries;
    }

    public boolean hasChildren() {
        return true;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SystemDefDomainActionHelper actionHelper = new SystemDefDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        LoadObjectLibrariesNodeEE loadObjectLibrariesNodeEE = this;
        synchronized (loadObjectLibrariesNodeEE) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfLoadObjectLibraryNode(this.getDomainSubtreeRoot(), collector, monitor);
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfLoadObjectLibraryNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ArrayList<LoadObjectLibraryNodeEE> nodes = new ArrayList<LoadObjectLibraryNodeEE>();
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        try {
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            List sysDefs = client.findSystemDefinitions(IIBMiResourceDefinition.ITEM_TYPE, projectAreaHandle, 0, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition sysDef : sysDefs) {
                nodes.add(new LoadObjectLibraryNodeEE(projectAreaHandle, (IResourceDefinition)((IIBMiResourceDefinition)sysDef), treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        collector.add(nodes.toArray(), monitor);
    }

    public boolean fetchAndUpdate(LoadObjectLibraryNodeEE element) {
        SystemDefinitionJob job = this.getFetchLoadObjectLibraryJob(element);
        job.schedule();
        return true;
    }

    protected SystemDefinitionJob getFetchLoadObjectLibraryJob(final LoadObjectLibraryNodeEE element) {
        return new SystemDefinitionJob(NLS.bind((String)Messages.LangDefDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)LoadObjectLibrariesNodeEE.this.getTeamRepository());
                IResourceDefinition def = element.getSystemDefinition();
                if ((def = client.fetchSystemDefinition((ISystemDefinitionHandle)def, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor)) instanceof IResourceDefinition) {
                    element.setLoadObjectLibrary(def);
                    LoadObjectLibrariesNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final LoadObjectLibraryNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LoadObjectLibrariesNodeEE.this.getViewer() != null && !LoadObjectLibrariesNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)LoadObjectLibrariesNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }
}

