/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.actions.SystemDefDomainActionHelper;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.ExistingLibraryNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.ResourceDefinitionsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;

public class ExistingLibrariesNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fFetchInProgress;

    public ExistingLibrariesNodeEE(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot, ResourceDefinitionsNodeEE resourceDefsNodeEE, Viewer viewer) {
        this.setProjectAreaHandle(projectAreaHandle);
        this.setDomainSubtreeRoot(domainSubtreeRoot);
        this.setParent((IEnterpriseExtensionsNode)resourceDefsNodeEE);
        this.setViewer(viewer);
    }

    public Image getIcon() {
        return DefUIPlugin.getImage("icons/obj16/libdef_fldr.gif");
    }

    public String getLabel() {
        return Messages.ExistingLibrariesNodeEE_ExistingLibraries;
    }

    public boolean hasChildren() {
        return true;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SystemDefDomainActionHelper actionHelper = new SystemDefDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        ExistingLibrariesNodeEE existingLibrariesNodeEE = this;
        synchronized (existingLibrariesNodeEE) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
            this.getChildrenOfExistingLibraryNode(this.getDomainSubtreeRoot(), collector, (IProgressMonitor)sm.newChild(-1));
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
        }
    }

    private void getChildrenOfExistingLibraryNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ArrayList<ExistingLibraryNodeEE> nodes = new ArrayList<ExistingLibraryNodeEE>();
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
        DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
        try {
            List sysDefs = client.findSystemDefinitions(IIBMiResourceDefinition.ITEM_TYPE, projectAreaHandle, 1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition sysDef : sysDefs) {
                nodes.add(new ExistingLibraryNodeEE(projectAreaHandle, (IResourceDefinition)((IIBMiResourceDefinition)sysDef), treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            DefUIPlugin.log(e);
        }
        collector.add(nodes.toArray(), monitor);
    }

    public boolean fetchAndUpdate(ExistingLibraryNodeEE element) {
        SystemDefinitionJob job = this.getFetchExistingLibraryJob(element);
        job.schedule();
        return true;
    }

    protected SystemDefinitionJob getFetchExistingLibraryJob(final ExistingLibraryNodeEE element) {
        return new SystemDefinitionJob(NLS.bind((String)Messages.LangDefDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)ExistingLibrariesNodeEE.this.getTeamRepository());
                ISystemDefinition def = element.getSystemDefinition();
                if ((def = client.fetchSystemDefinition((ISystemDefinitionHandle)def, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor)) instanceof IResourceDefinition) {
                    element.setExistingLibrary((IResourceDefinition)def);
                    ExistingLibrariesNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final ExistingLibraryNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ExistingLibrariesNodeEE.this.getViewer() != null && !ExistingLibrariesNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)ExistingLibrariesNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }
}

