/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef;

import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.actions.SystemDefDomainActionHelper;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.LanguageDefinitionsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.TranslatorNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.LangDefJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;

public class TranslatorsNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fFetchInProgress;

    public TranslatorsNodeEE(IProjectAreaHandle projectAreaHandle, DomainSubtreeRoot domainSubtreeRoot, LanguageDefinitionsNodeEE langDefsNodeEE, Viewer viewer) {
        this.setProjectAreaHandle(projectAreaHandle);
        this.setDomainSubtreeRoot(domainSubtreeRoot);
        this.setParent((IEnterpriseExtensionsNode)langDefsNodeEE);
        this.setViewer(viewer);
    }

    public Image getIcon() {
        return DefUIPlugin.getImage("icons/obj16/translators_obj.gif");
    }

    public String getLabel() {
        return Messages.TranslatorsNodeEE_Translators;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SystemDefDomainActionHelper actionHelper = new SystemDefDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    public boolean hasChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        TranslatorsNodeEE translatorsNodeEE = this;
        synchronized (translatorsNodeEE) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfTranslatorsNode(this.getDomainSubtreeRoot(), collector, monitor);
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfTranslatorsNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ArrayList<TranslatorNodeEE> nodes = new ArrayList<TranslatorNodeEE>();
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        try {
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            List sysDefs = client.findSystemDefinitions(IIBMiTranslator.ITEM_TYPE, projectAreaHandle, -1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition sysDef : sysDefs) {
                nodes.add(new TranslatorNodeEE(projectAreaHandle, sysDef, treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        collector.add(nodes.toArray(), monitor);
    }

    public boolean fetchAndUpdate(TranslatorNodeEE element) {
        LangDefJob job = this.getFetchTranslatorJob(element);
        job.schedule();
        return true;
    }

    protected LangDefJob getFetchTranslatorJob(final TranslatorNodeEE element) {
        return new LangDefJob(NLS.bind((String)Messages.LangDefDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)TranslatorsNodeEE.this.getTeamRepository());
                ISystemDefinition def = element.getSystemDefinition();
                if ((def = client.fetchSystemDefinition((ISystemDefinitionHandle)def, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor)) != null) {
                    element.setTranslator(def);
                    TranslatorsNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final TranslatorNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TranslatorsNodeEE.this.getViewer() != null && !TranslatorsNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)TranslatorsNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }
}

