/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.actions.SystemDefDomainActionHelper;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.LanguageDefinitionNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.TranslatorNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.TranslatorsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.LangDefJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class LanguageDefinitionsNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fFetchInProgress;
    private TranslatorsNodeEE fTranslatorsNode;
    private ViewerSorter fViewerSorter;

    public Image getIcon() {
        return DefUIPlugin.getImage("icons/obj16/langdefs_obj.gif");
    }

    public String getLabel() {
        return Messages.LanguageDefinitionsNodeEE_LangdefLabel;
    }

    public boolean hasChildren() {
        return true;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SystemDefDomainActionHelper actionHelper = new SystemDefDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        LanguageDefinitionsNodeEE languageDefinitionsNodeEE = this;
        synchronized (languageDefinitionsNodeEE) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfLanguageDefinitionsNode(this.getDomainSubtreeRoot(), collector, monitor);
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfLanguageDefinitionsNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        collector.add((Object)this.getTranslatorsNode(parent), monitor);
        ArrayList<LanguageDefinitionNodeEE> nodes = new ArrayList<LanguageDefinitionNodeEE>();
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        try {
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            List sysDefs = client.findSystemDefinitions(IIBMiLanguageDefinition.ITEM_TYPE, projectAreaHandle, -1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition sysDef : sysDefs) {
                nodes.add(new LanguageDefinitionNodeEE(projectAreaHandle, sysDef, treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        collector.add(nodes.toArray(), monitor);
    }

    private TranslatorsNodeEE getTranslatorsNode(DomainSubtreeRoot parent) {
        if (this.fTranslatorsNode == null) {
            this.fTranslatorsNode = new TranslatorsNodeEE(this.getProjectAreaHandle(), this.getDomainSubtreeRoot(), this, this.getViewer());
        }
        return this.fTranslatorsNode;
    }

    public TranslatorsNodeEE getTranslatorsNode() {
        return this.getTranslatorsNode(this.getDomainSubtreeRoot());
    }

    public boolean fetchAndUpdate(LanguageDefinitionNodeEE element) {
        LangDefJob job = this.getFetchLanguageDefinitionJob(element);
        job.schedule();
        return true;
    }

    protected LangDefJob getFetchLanguageDefinitionJob(final LanguageDefinitionNodeEE element) {
        return new LangDefJob(NLS.bind((String)Messages.LangDefDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)LanguageDefinitionsNodeEE.this.getTeamRepository());
                ISystemDefinition def = element.getSystemDefinition();
                if ((def = client.fetchSystemDefinition((ISystemDefinitionHandle)def, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor)) != null) {
                    element.setLanguageDefinition(def);
                    LanguageDefinitionsNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final LanguageDefinitionNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LanguageDefinitionsNodeEE.this.getViewer() != null && !LanguageDefinitionsNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)LanguageDefinitionsNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }

    public ViewerSorter getSorter() {
        if (this.fViewerSorter == null) {
            this.fViewerSorter = new LangDefDomainViewerSorter();
        }
        return this.fViewerSorter;
    }

    public static class LangDefDomainViewerSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object element1, Object element2) {
            if (element1 instanceof PendingUpdateAdapter && element2 instanceof PendingUpdateAdapter) {
                return 0;
            }
            if (element1 instanceof PendingUpdateAdapter) {
                return -1;
            }
            if (element2 instanceof PendingUpdateAdapter) {
                return 1;
            }
            if (element1 instanceof LanguageDefinitionNodeEE && element2 instanceof TranslatorsNodeEE) {
                return 1;
            }
            if (element1 instanceof TranslatorsNodeEE && element2 instanceof LanguageDefinitionNodeEE) {
                return -1;
            }
            if (element1 instanceof LanguageDefinitionNodeEE && element2 instanceof LanguageDefinitionNodeEE) {
                LanguageDefinitionNodeEE node1 = (LanguageDefinitionNodeEE)((Object)element1);
                LanguageDefinitionNodeEE node2 = (LanguageDefinitionNodeEE)((Object)element2);
                return node1.getLabel().compareTo(node2.getLabel());
            }
            if (element1 instanceof TranslatorNodeEE && element2 instanceof TranslatorNodeEE) {
                TranslatorNodeEE node1 = (TranslatorNodeEE)((Object)element1);
                TranslatorNodeEE node2 = (TranslatorNodeEE)((Object)element2);
                return node1.getLabel().compareTo(node2.getLabel());
            }
            return 0;
        }
    }
}

