/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.actions;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.LanguageDefinitionsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.langdef.TranslatorsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.ExistingLibrariesNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.resourcedef.LoadObjectLibrariesNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain.searchpath.SearchPathDefinitionsNodeEE;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.LanguageDefinitionEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.ResourceDefinitionEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SearchPathEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SystemDefinitionEditorInputFactory;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.TranslatorEditorInput;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.domain.AbstractSystemDefDomainActionHelper;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.ArchiveSystemDefinitionAction;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.DuplicateSystemDefinitionAction;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.UnArchiveSystemDefinitionAction;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class SystemDefDomainActionHelper
extends AbstractSystemDefDomainActionHelper {
    public SystemDefDomainActionHelper(IMenuManager manager, IStructuredSelection selection, IWorkbenchPartSite site) {
        super(manager, selection, site);
    }

    protected Action getNewSystemDefinitionAction(final IProjectAreaHandle projectAreaHandle, final AbstractEnterpriseExtensionsNode systemDefinition) {
        String actionLabel = null;
        if (systemDefinition instanceof LanguageDefinitionsNodeEE) {
            actionLabel = Messages.LangDefDomainActionHelper_NEW_LANGUAGE_DEFINITION;
        } else if (systemDefinition instanceof TranslatorsNodeEE) {
            actionLabel = Messages.LangDefDomainActionHelper_NEW_TRANSLATOR;
        } else if (systemDefinition instanceof SearchPathDefinitionsNodeEE) {
            actionLabel = Messages.SearchPathDomainActionHelper_NEW_SEARCH_PATH;
        } else if (systemDefinition instanceof ExistingLibrariesNodeEE || systemDefinition instanceof LoadObjectLibrariesNodeEE) {
            actionLabel = Messages.LibraryDefDomainActionHelper_NEW_LIBRARY;
        }
        return new Action(actionLabel){
            AbstractEditorInput input;
            {
                super($anonymous0);
                this.input = null;
            }

            public void run() {
                IWorkbenchPage page = SystemDefDomainActionHelper.this.fPartSite.getPage();
                if (page != null) {
                    try {
                        this.input = SystemDefinitionEditorInputFactory.getSystemDefinitionEditorInput(null, projectAreaHandle);
                        if (systemDefinition instanceof LanguageDefinitionsNodeEE) {
                            this.input = new LanguageDefinitionEditorInput(null, projectAreaHandle, systemDefinition);
                        } else if (systemDefinition instanceof TranslatorsNodeEE) {
                            this.input = new TranslatorEditorInput(null, projectAreaHandle, systemDefinition);
                        } else if (systemDefinition instanceof SearchPathDefinitionsNodeEE) {
                            this.input = new SearchPathEditorInput(null, projectAreaHandle, systemDefinition);
                        } else if (systemDefinition instanceof ExistingLibrariesNodeEE) {
                            this.input = new ResourceDefinitionEditorInput(null, 1, projectAreaHandle, systemDefinition);
                        } else if (systemDefinition instanceof LoadObjectLibrariesNodeEE) {
                            this.input = new ResourceDefinitionEditorInput(null, 0, projectAreaHandle, systemDefinition);
                        }
                        if (this.input != null) {
                            page.openEditor((IEditorInput)this.input, this.input.getEditorId());
                        }
                    }
                    catch (PartInitException exception) {
                        DefUIPlugin.log(exception);
                    }
                    catch (TeamRepositoryException e) {
                        DefUIPlugin.log(e);
                    }
                }
            }

            public String getId() {
                return this.input != null ? this.input.getEditorId() : null;
            }
        };
    }

    protected Action getArchiveSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode && this.isSystemDefinitionArchived(this.fSelection)) {
            return new ArchiveSystemDefinitionAction(this.fPartSite, projectAreaHandle, (IStructuredSelection)new StructuredSelection((Object)systemDefinition));
        }
        return null;
    }

    protected Action getDuplicateSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition != null && systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
            return new DuplicateSystemDefinitionAction(this.fPartSite, projectAreaHandle, (AbstractEnterpriseExtensionsSystemDefinitionNode)systemDefinition);
        }
        return null;
    }

    protected Action getReferencesSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        return null;
    }

    protected Action getRestoreSystemDefinitionAction(IProjectAreaHandle projectAreaHandle, AbstractEnterpriseExtensionsNode systemDefinition) {
        if (systemDefinition instanceof AbstractEnterpriseExtensionsSystemDefinitionNode && this.isSystemDefinitionUnArchived(this.fSelection)) {
            return new UnArchiveSystemDefinitionAction(this.fPartSite, projectAreaHandle, (IStructuredSelection)new StructuredSelection((Object)systemDefinition));
        }
        return null;
    }

    private boolean isSystemDefinitionArchived(IStructuredSelection selection) {
        boolean result = true;
        if (selection.size() > 0) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && result) {
                Object object = iterator.next();
                if (object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                    ISystemDefinition systemDef = ((AbstractEnterpriseExtensionsSystemDefinitionNode)object).getSystemDefinition();
                    if (!systemDef.isArchived()) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    private boolean isSystemDefinitionUnArchived(IStructuredSelection selection) {
        boolean result = true;
        if (selection.size() > 0) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && result) {
                Object object = iterator.next();
                if (object instanceof AbstractEnterpriseExtensionsSystemDefinitionNode) {
                    ISystemDefinition systemDef = ((AbstractEnterpriseExtensionsSystemDefinitionNode)object).getSystemDefinition();
                    if (systemDef.isArchived()) continue;
                    result = false;
                    continue;
                }
                result = false;
            }
        }
        return result;
    }
}

