/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.domain;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.DeleteSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.node.AbstractEnterpriseExtensionsSystemDefinitionNode;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import java.util.ArrayList;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchSite;

public class SystemDefinitionMenuOperationTarget
implements IMenuOperationTarget {
    public boolean canDoOperation(String actionId, IStructuredSelection selection) {
        if (this.isSelectionOfSystemDefinitions(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                return false;
            }
            if (actionId.equals("jazz.open")) {
                return true;
            }
        }
        return false;
    }

    private boolean isSelectionOfSystemDefinitions(IStructuredSelection selection) {
        if (selection.size() > 0) {
            for (Object object : selection) {
                if (object instanceof AbstractEnterpriseExtensionsNode) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
        if (this.isSelectionOfSystemDefinitions(selection)) {
            if (actionId.equals(IMenuOperationTarget.DELETE)) {
                this.deleteSystemDefinitions(selection);
            } else if (actionId.equals("jazz.open")) {
                this.openSystemDefinitions(selection, site);
            }
        }
    }

    private void deleteSystemDefinitions(IStructuredSelection selection) {
        ArrayList<ISystemDefinition> systemDefsToDelete = new ArrayList<ISystemDefinition>();
        ArrayList<AbstractEnterpriseExtensionsNode> nodesToDelete = new ArrayList<AbstractEnterpriseExtensionsNode>();
        AbstractTreeViewer treeViewer = null;
        ITeamRepository repository = this.resolveOwningRepository((TreeSelection)selection);
        for (AbstractEnterpriseExtensionsNode node : selection) {
            if (!(node instanceof AbstractEnterpriseExtensionsSystemDefinitionNode)) continue;
            systemDefsToDelete.add(((AbstractEnterpriseExtensionsSystemDefinitionNode)node).getSystemDefinition());
            nodesToDelete.add(node);
            if (treeViewer != null) continue;
            treeViewer = ((EnterpriseExtensionsDomainContentProvider)node.getDomain().getContentProvider()).getTreeViewer();
        }
        DeleteSystemDefinitionActionDelegate delegate = new DeleteSystemDefinitionActionDelegate(repository);
        delegate.selectionChanged(null, (ISelection)new StructuredSelection(systemDefsToDelete));
        delegate.setNodeSelection((IStructuredSelection)new StructuredSelection(nodesToDelete));
        delegate.run(null);
    }

    private void openSystemDefinitions(IStructuredSelection selection, IWorkbenchSite site) {
        for (AbstractEnterpriseExtensionsNode node : selection) {
            if (!(node instanceof AbstractEnterpriseExtensionsSystemDefinitionNode)) continue;
            EditSystemDefinitionActionDelegate.run(((AbstractEnterpriseExtensionsSystemDefinitionNode)node).getSystemDefinition(), node.getProjectAreaHandle(), node.getTeamRepository(), site.getPage());
        }
    }

    public String getLabel(String actionId) {
        return null;
    }

    private ITeamRepository resolveOwningRepository(TreeSelection selection) {
        TeamRepository repo = null;
        TreePath[] path = selection.getPaths();
        int numSegments = path[0].getSegmentCount();
        int i = 0;
        while (i < numSegments) {
            Object segmentObject = path[0].getSegment(i);
            if (segmentObject instanceof IProjectAreaHandle) {
                repo = (TeamRepository)((IProjectAreaHandle)segmentObject).getOrigin();
                break;
            }
            ++i;
        }
        return repo;
    }
}

