/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions;

import com.ibm.team.enterprise.ibmi.internal.definitions.ui.DefUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.Messages;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.editors.SystemDefinitionEditorInputFactory;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class EditSystemDefinitionActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public static void run(final ISystemDefinition systemDefinition, final IProjectAreaHandle projectAreaHandle, final IWorkbenchPage workbenchPage, final boolean isLatestSysDef, final boolean isFullyResolved) {
        Job job = new Job(com.ibm.team.enterprise.ibmi.internal.definitions.ui.nls.Messages.EditSystemDefinitionActionDelegate_JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 2);
                try {
                    ISystemDefinition fullSystemDefinition;
                    if (!isFullyResolved) {
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)((ITeamRepository)systemDefinition.getOrigin()));
                        fullSystemDefinition = client.findSystemDefinitionComplete(systemDefinition.getItemId().getUuidValue(), null, systemDefinition.getItemType(), (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        fullSystemDefinition = systemDefinition;
                    }
                    IProjectAreaHandle paHandle = null;
                    paHandle = projectAreaHandle == null ? fullSystemDefinition.getProjectArea() : projectAreaHandle;
                    if (fullSystemDefinition != null) {
                        AbstractEditorInput input = null;
                        try {
                            input = SystemDefinitionEditorInputFactory.getSystemDefinitionEditorInput(fullSystemDefinition, paHandle);
                        }
                        catch (TeamRepositoryException e) {
                            DefUIPlugin.log(e);
                            Status status = new Status(4, DefUIPlugin.getUniqueIdentifier(), Messages.SystemDefinition_PROJECTAREA_ERROR, (Throwable)e);
                            monitor.done();
                            return status;
                        }
                        final AbstractEditorInput localInput = input;
                        localInput.setLatest(isLatestSysDef);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    workbenchPage.openEditor((IEditorInput)localInput, localInput.getEditorId());
                                }
                                catch (PartInitException exception) {
                                    DefUIPlugin.log(exception);
                                }
                            }
                        });
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(4, "com.ibm.team.enterprise.ibmi.systemdefinition.ui", e.getLocalizedMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void run(ISystemDefinition systemDefinition, IProjectAreaHandle projectAreaHandle, ITeamRepository repository, IWorkbenchPage workbenchPage) {
        EditSystemDefinitionActionDelegate.run(systemDefinition, projectAreaHandle, workbenchPage, true, false);
    }

    public static void run(ISystemDefinition systemDefinition, IWorkbenchPage workbenchPage) {
        EditSystemDefinitionActionDelegate.run(systemDefinition, null, null, workbenchPage);
    }
}

