/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.ref.integrity.resolvers.internal;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.ibmi.ref.integrity.Activator;
import com.ibm.team.enterprise.ibmi.ref.integrity.Utils;
import com.ibm.team.enterprise.ibmi.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.langdefs.internal.LanguageDefinitionTreeNode;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.translators.internal.TranslatorTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver2;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;

public class ReferenceResolverTranslator
implements IReferenceResolver2 {
    private ITeamRepository repository = null;

    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo) throws Exception {
        return this.extendedReferencesTo(jazzObjects, targetRepo, null);
    }

    public List<ReferenceTreeNode> extendedReferencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo, IBuildDefinition buildDefinition) throws Exception {
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        this.setRepository(targetRepo);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof ITranslator)) continue;
            ITranslator targetTranslator = (ITranslator)jazzObject;
            String targetUUID = targetTranslator.getItemId().getUuidValue();
            String targetName = targetTranslator.getName();
            TranslatorTreeNode translatorTreeNode = new TranslatorTreeNode(targetTranslator);
            List<ILanguageDefinition> languageDefinitions = this.getLanguageDefinitions();
            for (ILanguageDefinition languageDefinition : languageDefinitions) {
                List translators = languageDefinition.getTranslators();
                for (ITranslatorEntry translator : translators) {
                    String UUID2 = translator.getValue();
                    boolean bFound = false;
                    if (buildDefinition != null && UUID2.startsWith("${") && UUID2.endsWith("}")) {
                        IBuildProperty properyValue = buildDefinition.getProperty(UUID2.substring(2, UUID2.length() - 1));
                        if (properyValue != null && properyValue.getValue().equals(targetName)) {
                            bFound = true;
                        }
                    } else if (UUID2 != null && UUID2.equals(targetUUID)) {
                        bFound = true;
                    }
                    if (!bFound) continue;
                    LanguageDefinitionTreeNode languageDefinitionTreeNode = new LanguageDefinitionTreeNode(languageDefinition);
                    Utils.addChildTreeNode((TreeNode)languageDefinitionTreeNode, (TreeNode)translatorTreeNode);
                }
            }
            if (!translatorTreeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)translatorTreeNode);
        }
        return results;
    }

    private List<ILanguageDefinition> getLanguageDefinitions() {
        ArrayList<ILanguageDefinition> languageDefinitions = new ArrayList<ILanguageDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = com.ibm.team.enterprise.ref.integrity.internal.Utils.getProjectAreas((ITeamRepository)this.getRepository());
        }
        catch (TeamRepositoryException e) {
            Activator.log(Messages.ReferenceResolverTranslator_0, e);
            e.printStackTrace();
        }
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null) continue;
            languageDefinitions.addAll(this.getLanguageDefinitions(projectArea));
        }
        return languageDefinitions;
    }

    protected List<ILanguageDefinition> getLanguageDefinitions(IProjectArea projectArea) {
        ArrayList<ILanguageDefinition> languageDefinitions = new ArrayList<ILanguageDefinition>();
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
            List langdefs = client.findSystemDefinitions(IIBMiLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, null, (IProgressMonitor)new NullProgressMonitor());
            for (ISystemDefinition ld : langdefs) {
                languageDefinitions.add((ILanguageDefinition)ld);
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(Messages.ReferenceResolverTranslator_1, e);
            e.printStackTrace();
        }
        return languageDefinitions;
    }

    private void setRepository(ITeamRepository targetRepo) {
        this.repository = targetRepo;
    }

    private ITeamRepository getRepository() {
        return this.repository;
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository targetRepo) {
        this.setRepository(targetRepo);
        ArrayList<String> log = new ArrayList<String>();
        if (!(oldTarget instanceof ITranslator)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZTranslatorReferenceResolver_0);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ITranslator oldTranslator = (ITranslator)oldTarget;
        if (!(newTarget instanceof ITranslator)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZTranslatorReferenceResolver_2);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ITranslator newTranslator = (ITranslator)newTarget;
        String oldTargetIdentifier = oldTranslator.getItemId().getUuidValue();
        String newTargetIdentifier = newTranslator.getItemId().getUuidValue();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            if (!(referenceTreeNode instanceof LanguageDefinitionTreeNode)) continue;
            ILanguageDefinition languageDefinition = (ILanguageDefinition)referenceTreeNode.getValue();
            ILanguageDefinition workingCopy = (ILanguageDefinition)languageDefinition.getWorkingCopy();
            List translators = workingCopy.getTranslators();
            for (ITranslatorEntry translator : translators) {
                String UUID2 = translator.getValue();
                if (UUID2 == null || !UUID2.equals(oldTargetIdentifier)) continue;
                translator.setValue(newTargetIdentifier);
                try {
                    ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)workingCopy, (IProgressMonitor)new NullProgressMonitor());
                    languageDefinition = (ILanguageDefinition)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                    log.add(NLS.bind((String)Messages.SystemZTranslatorReferenceResolver_4, (Object[])new String[]{languageDefinition.getName(), oldTranslator.getName(), newTranslator.getName()}));
                    referenceTreeNode.setValue((Object)languageDefinition);
                }
                catch (TeamRepositoryException e) {
                    log.add(Messages.SystemZTranslatorReferenceResolver_5);
                    Activator.log(Messages.SystemZTranslatorReferenceResolver_6, e);
                    e.printStackTrace();
                }
            }
        }
        return log;
    }

    public String getLoglabel() {
        return Messages.SystemZLangDefReferenceResolver_0;
    }
}

