/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.ref.integrity.resolvers.internal;

import com.ibm.team.enterprise.ibmi.ref.integrity.Activator;
import com.ibm.team.enterprise.ibmi.ref.integrity.Utils;
import com.ibm.team.enterprise.ibmi.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.searchpath.internal.SearchPathTreeNode;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.translators.internal.TranslatorTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;

public class ReferenceResolverSearchPath
implements IReferenceResolver {
    private ITeamRepository repository = null;

    public String getLoglabel() {
        return null;
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository targetRepo) {
        this.setRepository(targetRepo);
        ArrayList<String> log = new ArrayList<String>();
        if (!(oldTarget instanceof ISearchPath)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SearchPath1);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ISearchPath oldSearchPath = (ISearchPath)oldTarget;
        if (!(newTarget instanceof ISearchPath)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SearchPath1);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ISearchPath newSearchPath = (ISearchPath)newTarget;
        String oldTargetIdentifier = oldSearchPath.getItemId().getUuidValue();
        String newTargetIdentifier = newSearchPath.getItemId().getUuidValue();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            IIBMiTranslator translator;
            IIBMiTranslator workingCopy;
            String searchPathUUID;
            if (!(referenceTreeNode instanceof TranslatorTreeNode) || !(searchPathUUID = (workingCopy = (IIBMiTranslator)(translator = (IIBMiTranslator)referenceTreeNode.getValue()).getWorkingCopy()).getSearchPath()).equals(oldTargetIdentifier)) continue;
            workingCopy.setSearchPath(newTargetIdentifier);
            try {
                ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)workingCopy, (IProgressMonitor)new NullProgressMonitor());
                translator = (IIBMiTranslator)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                log.add(NLS.bind((String)Messages.SearchPath2, (Object[])new String[]{translator.getName(), oldSearchPath.getName(), newSearchPath.getName()}));
                referenceTreeNode.setValue((Object)translator);
            }
            catch (TeamRepositoryException e) {
                log.add(Messages.SearchPath3);
                Activator.log(Messages.SearchPath4, e);
                e.printStackTrace();
            }
        }
        return log;
    }

    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo) throws Exception {
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        this.setRepository(targetRepo);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof ISearchPath)) continue;
            ISearchPath searchPath = (ISearchPath)jazzObject;
            String targetUUID = searchPath.getItemId().getUuidValue();
            SearchPathTreeNode searchPathTreeNode = new SearchPathTreeNode(searchPath);
            List<IIBMiTranslator> translators = this.getTranslators();
            for (IIBMiTranslator translator : translators) {
                String searchPathUUID = translator.getSearchPath();
                if (searchPathUUID == null || !searchPathUUID.equals(targetUUID)) continue;
                TranslatorTreeNode translatorTreeNode = new TranslatorTreeNode(translator);
                Utils.addChildTreeNode((TreeNode)translatorTreeNode, (TreeNode)searchPathTreeNode);
            }
            if (!searchPathTreeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)searchPathTreeNode);
        }
        return results;
    }

    private List<IIBMiTranslator> getTranslators() {
        ArrayList<IIBMiTranslator> translators = new ArrayList<IIBMiTranslator>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = com.ibm.team.enterprise.ref.integrity.internal.Utils.getProjectAreas((ITeamRepository)this.getRepository());
        }
        catch (TeamRepositoryException e) {
            Activator.log(Messages.ReferenceResolverTranslator_0, e);
            e.printStackTrace();
        }
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null) continue;
            translators.addAll(this.getTranslators(projectArea));
        }
        return translators;
    }

    protected List<IIBMiTranslator> getTranslators(IProjectArea projectArea) {
        ArrayList<IIBMiTranslator> translators = new ArrayList<IIBMiTranslator>();
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
            List trans = client.findSystemDefinitions(IIBMiTranslator.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, null, (IProgressMonitor)new NullProgressMonitor());
            for (ISystemDefinition t : trans) {
                translators.add((IIBMiTranslator)t);
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(Messages.ReferenceResolverTranslator_1, e);
            e.printStackTrace();
        }
        return translators;
    }

    private void setRepository(ITeamRepository targetRepo) {
        this.repository = targetRepo;
    }

    private ITeamRepository getRepository() {
        return this.repository;
    }
}

