/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.ref.integrity.resolvers.internal;

import com.ibm.team.enterprise.ibmi.ref.integrity.Activator;
import com.ibm.team.enterprise.ibmi.ref.integrity.Utils;
import com.ibm.team.enterprise.ibmi.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.library.internal.LibraryTreeNode;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.searchpath.internal.SearchPathTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.ProjectTreeNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiSearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;

public class ReferenceResolverLibrary
implements IReferenceResolver {
    private ITeamRepository repository = null;

    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo) throws Exception {
        this.setRepository(targetRepo);
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        List<IProject> projects = Utils.buildProjectList(targetRepo);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof IIBMiResourceDefinition)) continue;
            IIBMiResourceDefinition resourceDefinition = (IIBMiResourceDefinition)jazzObject;
            String targetUUID = resourceDefinition.getItemId().getUuidValue();
            LibraryTreeNode treeNode = new LibraryTreeNode(resourceDefinition);
            for (IProject project : projects) {
                String object_UUID = Utils.getArtifactVersionableProperty((IResource)project, (String)"team.enterprise.object.library");
                String source_UUID = Utils.getArtifactVersionableProperty((IResource)project, (String)"team.enterprise.source.library");
                if (!targetUUID.equals(object_UUID) && !targetUUID.equals(source_UUID)) continue;
                ProjectTreeNode projectTreeNode = new ProjectTreeNode((Object)project);
                Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)treeNode);
            }
            List<ISearchPath> searchPaths = this.getSearchPaths();
            for (ISearchPath searchPath : searchPaths) {
                List uuidStrings = searchPath.getPath();
                boolean found = false;
                Iterator iterator3 = uuidStrings.iterator();
                while (iterator3.hasNext() && !found) {
                    String libraryUUIDString = ((IStringHelper)iterator3.next()).getValue();
                    if (!targetUUID.equals(libraryUUIDString)) continue;
                    SearchPathTreeNode searchPathTreeNode = new SearchPathTreeNode(searchPath);
                    Utils.addChildTreeNode((TreeNode)searchPathTreeNode, (TreeNode)treeNode);
                    found = true;
                }
            }
            if (!treeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)treeNode);
        }
        return results;
    }

    private List<ISearchPath> getSearchPaths() {
        ArrayList<ISearchPath> searchPaths = new ArrayList<ISearchPath>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = com.ibm.team.enterprise.ref.integrity.internal.Utils.getProjectAreas((ITeamRepository)this.getRepository());
        }
        catch (TeamRepositoryException e) {
            Activator.log(Messages.ReferenceResolverTranslator_0, e);
            e.printStackTrace();
        }
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null) continue;
            searchPaths.addAll(this.getSearchPaths(projectArea));
        }
        return searchPaths;
    }

    private void setRepository(ITeamRepository targetRepo) {
        this.repository = targetRepo;
    }

    private ITeamRepository getRepository() {
        return this.repository;
    }

    protected List<ISearchPath> getSearchPaths(IProjectArea projectArea) {
        ArrayList<ISearchPath> searchPaths = new ArrayList<ISearchPath>();
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
            List paths = client.findSystemDefinitions(IIBMiSearchPath.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, null, (IProgressMonitor)new NullProgressMonitor());
            for (ISystemDefinition path : paths) {
                searchPaths.add((ISearchPath)path);
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log("Error while retriving Search Paths. See log for more details", e);
            e.printStackTrace();
        }
        return searchPaths;
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository targetRepo) {
        this.setRepository(targetRepo);
        ArrayList<String> log = new ArrayList<String>();
        if (!(oldTarget instanceof IIBMiResourceDefinition)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZLangDefReferenceResolver_1);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        IIBMiResourceDefinition oldLibrary = (IIBMiResourceDefinition)oldTarget;
        if (!(newTarget instanceof IIBMiResourceDefinition)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZLangDefReferenceResolver_3);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        IIBMiResourceDefinition newLibrary = (IIBMiResourceDefinition)newTarget;
        String oldTargetIdentifier = oldLibrary.getItemId().getUuidValue();
        String newTargetIdentifier = newLibrary.getItemId().getUuidValue();
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            if (referenceTreeNode instanceof ProjectTreeNode) {
                IStatus status;
                IResource project = (IResource)referenceTreeNode.getValue();
                String object_UUID = Utils.getArtifactVersionableProperty((IResource)project, (String)"team.enterprise.object.library");
                String source_UUID = Utils.getArtifactVersionableProperty((IResource)project, (String)"team.enterprise.source.library");
                if (oldTargetIdentifier.equals(object_UUID)) {
                    status = Utils.setArtifactVersionableProperty((IResource)project, (String)newTargetIdentifier, (String)"team.enterprise.object.library");
                    if (status.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.LibraryReRef1, (Object[])new String[]{project.getName(), oldLibrary.getName(), newLibrary.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.LibraryReRef3, (Object[])new String[]{project.getName()}));
                        Activator.log(status);
                    }
                }
                if (oldTargetIdentifier.equals(source_UUID)) {
                    status = Utils.setArtifactVersionableProperty((IResource)project, (String)newTargetIdentifier, (String)"team.enterprise.source.library");
                    if (status.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.LibraryReRef2, (Object[])new String[]{project.getName(), oldLibrary.getName(), newLibrary.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.LibraryReRef3, (Object[])new String[]{project.getName()}));
                        Activator.log(status);
                    }
                }
            }
            if (!(referenceTreeNode instanceof SearchPathTreeNode)) continue;
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getRepository());
            ISearchPath searchPath = (ISearchPath)referenceTreeNode.getValue();
            ISearchPath workingCopy = (ISearchPath)searchPath.getWorkingCopy();
            ArrayList workingCopyPath = new ArrayList();
            workingCopyPath.addAll(workingCopy.getPath());
            int index = 0;
            workingCopy.getPath().clear();
            for (IStringHelper uuid : workingCopyPath) {
                if (oldTargetIdentifier.equals(uuid.getValue())) {
                    StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
                    helper.setValue(newTargetIdentifier);
                    workingCopy.getPath().add(helper);
                } else {
                    workingCopy.getPath().add(uuid);
                }
                ++index;
            }
            try {
                ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)workingCopy, (IProgressMonitor)new NullProgressMonitor());
                searchPath = (IIBMiSearchPath)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                log.add(NLS.bind((String)Messages.LibraryReRef4, (Object[])new String[]{searchPath.getName(), oldLibrary.getName(), newLibrary.getName()}));
                referenceTreeNode.setValue((Object)searchPath);
            }
            catch (TeamRepositoryException e) {
                log.add(Messages.LibraryReRef5);
                Activator.log(Messages.LibraryReRef6, e);
                e.printStackTrace();
            }
        }
        return log;
    }

    public String getLoglabel() {
        return Messages.SystemZLangDefReferenceResolver_0;
    }
}

