/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.ref.integrity.resolvers.internal;

import com.ibm.team.enterprise.ibmi.ref.integrity.Activator;
import com.ibm.team.enterprise.ibmi.ref.integrity.Utils;
import com.ibm.team.enterprise.ibmi.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.ibmi.ref.integrity.query.langdefs.internal.LanguageDefinitionTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.FileTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.FolderTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.ProjectTreeNode;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.osgi.util.NLS;

public class ReferenceResolverLanguageDefinition
implements IReferenceResolver {
    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo) throws Exception {
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        List<IProject> projects = Utils.buildProjectList(targetRepo);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof ILanguageDefinition)) continue;
            ILanguageDefinition languageDefinition = (ILanguageDefinition)jazzObject;
            String targetUUID = languageDefinition.getItemId().getUuidValue();
            LanguageDefinitionTreeNode languageDefinitionTreeNode = new LanguageDefinitionTreeNode(languageDefinition);
            for (IProject project : projects) {
                ProjectTreeNode projectTreeNode = null;
                List<IFolder> folders = Utils.getSrcFolders(project.getName());
                for (IFolder folder : folders) {
                    FolderTreeNode folderTreeNode = null;
                    IResource[] folderChildren = folder.members();
                    int k = 0;
                    while (k < folderChildren.length) {
                        String UUID2;
                        IResource resource = folderChildren[k];
                        if (resource instanceof IFile && (UUID2 = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.language.definition")) != null && UUID2.equals(targetUUID)) {
                            if (projectTreeNode == null) {
                                projectTreeNode = new ProjectTreeNode((Object)project);
                                Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)languageDefinitionTreeNode);
                            }
                            if (folderTreeNode == null) {
                                folderTreeNode = new FolderTreeNode((Object)folder);
                                Utils.addChildTreeNode((TreeNode)folderTreeNode, (TreeNode)projectTreeNode);
                            }
                            FileTreeNode fileTreeNode = new FileTreeNode((Object)resource);
                            Utils.addChildTreeNode((TreeNode)fileTreeNode, (TreeNode)folderTreeNode);
                        }
                        ++k;
                    }
                }
            }
            if (!languageDefinitionTreeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)languageDefinitionTreeNode);
        }
        return results;
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository targetRepo) {
        ArrayList<String> log = new ArrayList<String>();
        if (!(oldTarget instanceof ILanguageDefinition)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZLangDefReferenceResolver_1);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ILanguageDefinition oldLanguageDefinition = (ILanguageDefinition)oldTarget;
        if (!(newTarget instanceof ILanguageDefinition)) {
            Status status = new Status(4, "com.ibm.team.enterprise.ibmi.ref.integrity", Messages.SystemZLangDefReferenceResolver_3);
            Activator.log((IStatus)status);
            log.add(Messages.InternalError);
            return log;
        }
        ILanguageDefinition newLanguageDefinition = (ILanguageDefinition)newTarget;
        String oldTargetIdentifier = oldLanguageDefinition.getItemId().getUuidValue();
        String newTargetIdentifier = newLanguageDefinition.getItemId().getUuidValue();
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            IResource resource;
            String currentUUID;
            if (!(referenceTreeNode instanceof FileTreeNode) || (currentUUID = Utils.getArtifactVersionableProperty((IResource)(resource = (IResource)referenceTreeNode.getValue()), (String)"team.enterprise.language.definition")) == null || !currentUUID.equals(oldTargetIdentifier)) continue;
            IStatus status = Utils.setArtifactVersionableProperty((IResource)resource, (String)newTargetIdentifier, (String)"team.enterprise.language.definition");
            if (status.getSeverity() == 0) {
                log.add(NLS.bind((String)Messages.SystemZLangDefReferenceResolver_5, (Object[])new String[]{resource.getName(), oldLanguageDefinition.getName(), newLanguageDefinition.getName()}));
                continue;
            }
            log.add(NLS.bind((String)Messages.SystemZLangDefReferenceResolver_6, (Object[])new String[]{resource.getName()}));
            Activator.log(status);
        }
        return log;
    }

    public String getLoglabel() {
        return Messages.SystemZLangDefReferenceResolver_0;
    }
}

