/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.ibmi.metadata.collection.client;

import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberBrief;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.team.enterprise.ibmi.metadata.collection.client.IIBMiMetadataCollectionClient;
import com.ibm.team.enterprise.internal.metadata.client.collection.MetadataCollectionClient;
import com.ibm.team.enterprise.rdf.query.client.ClientFactory;
import com.ibm.team.enterprise.rdf.query.client.IDependencyQueryClient;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class IBMiMetadataCollectionClient
extends MetadataCollectionClient
implements IIBMiMetadataCollectionClient {
    private IScmIClientLibrary clientLibrary;
    private final List<ISeriesAbstractFilterString> allDependencyMetadata = new ArrayList<ISeriesAbstractFilterString>();
    private IISeriesHostMemberBrief rootMember;

    public IBMiMetadataCollectionClient(IClientLibraryContext context) {
        super(context);
    }

    @Override
    public List<ISeriesAbstractFilterString> getFileDependencyMetadata(String repositoryURI, String repositoryWorkspaceUUID, String componentUUID, String projectUUID, IISeriesHostMemberBrief sourceMember, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.allDependencyMetadata.clear();
        if (this.allDependencyMetadata.isEmpty()) {
            this.rootMember = sourceMember;
        }
        return this.getAllFileDependencyMetadata(repositoryURI, repositoryWorkspaceUUID, componentUUID, projectUUID, sourceMember, progressMonitor);
    }

    private List<ISeriesAbstractFilterString> getAllFileDependencyMetadata(String repositoryURI, String repositoryWorkspaceUUID, String componentUUID, String projectUUID, IISeriesHostMemberBrief sourceMember, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        List<Object> directDependencyMetadata = new ArrayList();
        directDependencyMetadata = this.getDirectDependencyMetadata(repositoryURI, repositoryWorkspaceUUID, componentUUID, projectUUID, sourceMember, progressMonitor);
        if (directDependencyMetadata != null && directDependencyMetadata.size() > 0) {
            directDependencyMetadata = this.addDependencyMetadata(directDependencyMetadata, sourceMember);
            for (ISeriesAbstractFilterString iSeriesAbstractFilterString : directDependencyMetadata) {
                IISeriesHostMemberBrief dependMember = this.getIBMISrcMemberDependency(iSeriesAbstractFilterString, sourceMember.getLibrary(), sourceMember.getType());
                if (dependMember == null) continue;
                this.getAllFileDependencyMetadata(repositoryURI, repositoryWorkspaceUUID, componentUUID, projectUUID, dependMember, progressMonitor);
            }
        }
        return this.allDependencyMetadata;
    }

    @Override
    public List<ISeriesAbstractFilterString> getDirectDependencyMetadata(String repositoryURI, String repositoryWorkspaceUUID, String componentUUID, String projectUUID, IISeriesHostMemberBrief sourceMember, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IVersionable repoFile;
        IComponentHandle[] components;
        ITeamRepositoryService teamRepositoryService;
        ITeamRepository teamRepository;
        IWorkspaceHandle workspaceHandle = null;
        IComponentHandle componentHandle = null;
        IFolderHandle projectHandle = null;
        ArrayList<ISeriesAbstractFilterString> dependencyMetadata = new ArrayList<ISeriesAbstractFilterString>();
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        if (!(teamRepository = (teamRepositoryService = TeamPlatform.getTeamRepositoryService()).getTeamRepository(repositoryURI)).loggedIn()) {
            teamRepository.login(progressMonitor);
        }
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
        criteria.setKind(2);
        List workspaces = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).findWorkspaces(criteria, 100, progressMonitor);
        for (IWorkspaceHandle workspace : workspaces) {
            if (!workspace.getItemId().getUuidValue().equalsIgnoreCase(repositoryWorkspaceUUID)) continue;
            workspaceHandle = workspace;
        }
        IScmService fSCMService = (IScmService)this.getService(IScmService.class);
        IComponentHandle[] iComponentHandleArray = components = fSCMService.getComponentsForWorkspace(workspaceHandle, null);
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentHandle component = iComponentHandleArray[n2];
            if (component.getItemId().getUuidValue().equalsIgnoreCase(componentUUID)) {
                componentHandle = component;
            }
            ++n2;
        }
        List<IProjectToLibraryMapHandle> projectMappings = this.getProjectMappings(teamRepository, workspaceHandle, componentHandle, progressMonitor);
        projectHandle = this.getIProjectMatch(teamRepository, projectMappings, projectUUID, sourceMember, progressMonitor);
        if (projectHandle == null) {
            projectMappings = this.getProjectMappings(teamRepository, workspaceHandle, progressMonitor);
            projectHandle = this.getIProjectMatch(teamRepository, projectMappings, sourceMember, progressMonitor);
        }
        if ((repoFile = this.getRepositoryFile(teamRepository, workspaceHandle, componentHandle, projectHandle, sourceMember, progressMonitor)) != null) {
            String streamUUID;
            String[] sourceFileDependencies;
            String fileItemUUID = repoFile.getItemId().getUuidValue();
            IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getWorkspaceConnection(workspaceHandle, null);
            IFlowTable flowTable = workspaceConnection.getFlowTable();
            IFlowEntry flowEntry = flowTable.getCurrentAcceptFlow();
            IFlowNodeHandle flowNodeHandle = flowEntry.getFlowNode();
            if (flowNodeHandle instanceof IWorkspaceHandle && (sourceFileDependencies = this.getLogicalDependencies(repositoryURI, streamUUID = flowNodeHandle.getItemId().getUuidValue(), componentUUID, fileItemUUID)) != null) {
                String[] stringArray = sourceFileDependencies;
                int n3 = sourceFileDependencies.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dependency = stringArray[n4];
                    ISeriesAbstractFilterString dependencyString = ISeriesAbstractFilterString.createFilterStringObject((String)dependency);
                    dependencyMetadata.add(dependencyString);
                    ++n4;
                }
            }
        }
        return dependencyMetadata;
    }

    private List<IProjectToLibraryMapHandle> getProjectMappings(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IProgressMonitor monitor) {
        List iProjectHandles = null;
        List projectToLibraryMappings = null;
        try {
            this.clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
            iProjectHandles = FileSystemIUtil.getInstance().getIProjects(workspaceHandle, componentHandle, repository, monitor);
            IWorkspaceIHandle workspaceIHandle = this.clientLibrary.getWorkspaceI(workspaceHandle, monitor);
            projectToLibraryMappings = this.clientLibrary.getProjectToLibraryMappings(workspaceIHandle, iProjectHandles, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return projectToLibraryMappings;
    }

    private List<IProjectToLibraryMapHandle> getProjectMappings(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) {
        List iProjectHandles = null;
        List projectToLibraryMappings = null;
        try {
            iProjectHandles = FileSystemIUtil.getInstance().getIProjects(workspaceHandle, repository, monitor);
            IWorkspaceIHandle workspaceIHandle = this.clientLibrary.getWorkspaceI(workspaceHandle, monitor);
            this.clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
            projectToLibraryMappings = this.clientLibrary.getProjectToLibraryMappings(workspaceIHandle, iProjectHandles, monitor);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return projectToLibraryMappings;
    }

    private IFolderHandle getIProjectMatch(ITeamRepository repository, List<IProjectToLibraryMapHandle> mappingHandles, String projectUUID, IISeriesHostMemberBrief sourceMember, IProgressMonitor monitor) throws TeamRepositoryException {
        IFolderHandle projectHandle = null;
        if (mappingHandles == null) {
            return projectHandle;
        }
        for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
            IProjectToLibraryMap temp = (IProjectToLibraryMap)repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, monitor);
            projectHandle = temp.getFolder();
            String library = temp.getLibrary();
            String projectHandleUUID = projectHandle.getItemId().getUuidValue();
            if (!projectHandleUUID.equalsIgnoreCase(projectUUID) || !library.equalsIgnoreCase(sourceMember.getLibrary())) continue;
            return projectHandle;
        }
        return null;
    }

    private IFolderHandle getIProjectMatch(ITeamRepository repository, List<IProjectToLibraryMapHandle> mappingHandles, IISeriesHostMemberBrief sourceMember, IProgressMonitor monitor) throws TeamRepositoryException {
        IFolderHandle projectHandle = null;
        if (mappingHandles == null) {
            return projectHandle;
        }
        for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
            IProjectToLibraryMap temp = (IProjectToLibraryMap)repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, monitor);
            projectHandle = temp.getFolder();
            String library = temp.getLibrary();
            if (!library.equalsIgnoreCase(sourceMember.getLibrary())) continue;
            return projectHandle;
        }
        return null;
    }

    private IVersionable getRepositoryFile(ITeamRepository repository, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IFolderHandle projectHandle, IISeriesHostMemberBrief sourceMember, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionable repositoryFile = null;
        if (projectHandle == null) {
            return null;
        }
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection wsConn = manager.getWorkspaceConnection(workspaceHandle, monitor);
        IConfiguration configuration = wsConn.configuration(componentHandle);
        String sourceMemberName = String.valueOf(sourceMember.getName()) + "." + sourceMember.getType();
        try {
            Map<String, IVersionableHandle> folders = null;
            folders = this.findAllChildrenEntry(configuration, projectHandle, monitor);
            block2: for (String folderName : folders.keySet()) {
                IVersionableHandle versionableHandle = folders.get(folderName);
                if (!(versionableHandle instanceof IFolderHandle)) continue;
                IFolderHandle folderHandle = (IFolderHandle)versionableHandle;
                if (!sourceMember.getFile().equalsIgnoreCase(folderName)) continue;
                Map<String, IVersionableHandle> files = null;
                files = this.findAllChildrenEntry(configuration, folderHandle, monitor);
                for (String name : files.keySet()) {
                    IVersionableHandle fileHandle = files.get(name);
                    if (fileHandle == null || !(fileHandle instanceof IFileItemHandle) || !sourceMemberName.equalsIgnoreCase(name)) continue;
                    repositoryFile = configuration.fetchCompleteItem(fileHandle, monitor);
                    continue block2;
                }
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return repositoryFile;
    }

    private List<ISeriesAbstractFilterString> addDependencyMetadata(List<ISeriesAbstractFilterString> dependencies, IISeriesHostMemberBrief dependencyParent) {
        ArrayList<ISeriesAbstractFilterString> dependencyMetadata = new ArrayList<ISeriesAbstractFilterString>();
        for (ISeriesAbstractFilterString dependency : dependencies) {
            if (dependency instanceof ISeriesMemberFilterString) {
                IISeriesHostMemberBrief dependMember = this.getIBMISrcMemberDependency(dependency, dependencyParent.getLibrary(), dependencyParent.getType());
                if (dependMember == null || this.allDependencyMetadata.contains(dependency) || dependMember.toString().equals(this.rootMember.toString())) continue;
                dependencyMetadata.add(dependency);
                continue;
            }
            if (this.allDependencyMetadata.contains(dependency)) continue;
            dependencyMetadata.add(dependency);
        }
        this.allDependencyMetadata.addAll(dependencyMetadata);
        return dependencyMetadata;
    }

    private IISeriesHostMemberBrief getIBMISrcMemberDependency(ISeriesAbstractFilterString filter, String srcLibrary, String srcType) {
        ISeriesHostMemberBasic srcMember = new ISeriesHostMemberBasic();
        if (filter instanceof ISeriesMemberFilterString) {
            String lib = ((ISeriesMemberFilterString)filter).getLibrary();
            String type = ((ISeriesMemberFilterString)filter).getMemberType();
            if (lib.equalsIgnoreCase("*LIBL")) {
                srcMember.setLibrary(srcLibrary);
            } else {
                srcMember.setLibrary(lib);
            }
            srcMember.setFile(((ISeriesMemberFilterString)filter).getFile());
            srcMember.setName(((ISeriesMemberFilterString)filter).getMember());
            if (type.equalsIgnoreCase("*")) {
                srcMember.setType(srcType);
            } else {
                srcMember.setType(type);
            }
        } else {
            if (filter instanceof ISeriesObjectFilterString) {
                return null;
            }
            if (filter instanceof ISeriesLibraryFilterString) {
                return null;
            }
        }
        return srcMember;
    }

    private Map<String, IVersionableHandle> findAllChildrenEntry(IConfiguration wsConfiguration, IFolderHandle folder, IProgressMonitor monitor) throws TeamRepositoryException, ItemNotFoundException {
        return wsConfiguration.childEntries(folder, monitor);
    }

    protected String[] getLogicalDependencies(String repositoryURI, String streamUUID, String componentUUID, String fileItemUUID) throws TeamRepositoryException {
        IDependencyQueryClient dependencyQueryClient;
        String results;
        ITeamRepositoryService teamRepositoryService;
        ITeamRepository teamRepository;
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        if (!(teamRepository = (teamRepositoryService = TeamPlatform.getTeamRepositoryService()).getTeamRepository(repositoryURI)).loggedIn()) {
            teamRepository.login(null);
        }
        if ((results = (dependencyQueryClient = ClientFactory.getDependencyQueryClient((ITeamRepository)teamRepository)).executeLogicalDependenciesQuery(UUID.valueOf((String)streamUUID), UUID.valueOf((String)fileItemUUID), null)) == null) {
            return new String[0];
        }
        List logicalDependencies = null;
        ArrayList<String> dependencyNames = new ArrayList<String>();
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            logicalDependencies = parser.parse((InputStream)new ByteArrayInputStream(results.getBytes()));
            if (logicalDependencies.size() == 0) {
                return new String[0];
            }
            for (SelectResult logicalDependency : logicalDependencies) {
                List dependencyFields = logicalDependency.getBindings();
                String dependencyPath = "";
                for (Binding dependencyField : dependencyFields) {
                    if (!dependencyField.getName().equals("dependencyPath")) continue;
                    dependencyPath = dependencyField.getValue();
                }
                dependencyNames.add(dependencyPath);
            }
            return dependencyNames.toArray(new String[dependencyNames.size()]);
        }
        catch (Exception e) {
            throw new TeamRepositoryException(e.getMessage());
        }
    }

    private String generateFileResourceURI(String objectUUID, String scdURI) {
        StringBuffer slugBuffer = new StringBuffer("_itemId=");
        slugBuffer.append(objectUUID);
        return new StringBuffer(scdURI).append(slugBuffer).toString();
    }
}

