/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.ui.property.pages;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.metadata.api.IMetadata;
import com.ibm.team.enterprise.build.ui.property.pages.EnterpriseMetadataPropertiesComposite;
import com.ibm.team.enterprise.build.ui.property.pages.Utils;
import com.ibm.team.enterprise.ibmi.build.ui.TeamiBuildUIPlugin;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs.ResourceDefinitionLabelHelper;
import com.ibm.team.enterprise.ibmi.internal.langdef.ui.dialogs.ResourceDefinitionSelectionDialog;
import com.ibm.team.enterprise.ibmi.systemdefinition.common.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionContext;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.internal.enterprise.ibmi.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EnterpriseProjectMetadataPropertiesComposite
extends EnterpriseMetadataPropertiesComposite {
    private final int OBJ = 0;
    private final int SRC = 1;
    private Label pageDescription;
    private Button clearSrcLibButton;
    private Button browseSrcLibButton;
    private Button clearObjLibButton;
    private Button browseObjLibButton;
    protected Text fSrcLibrary;
    protected Text fObjLibrary;
    protected String fSrcLibUUID;
    protected String fObjLibUUID;
    private final IResource fResource;
    private final boolean fProjectShared;
    private ITeamRepository fTeamRepository;
    private IShareable fShareable;
    private IStatus errorStatus;
    private ResolveResourceDefExtensionsJob resolveSrcExtensions = null;
    private ResolveResourceDefExtensionsJob resolveObjExtensions = null;
    private Map<String, IIBMiResourceDefinition> extensionMap = null;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IResourceDefinitionHandle) {
                IResourceDefinitionHandle definition = (IResourceDefinitionHandle)element;
                return !definition.isArchived() && definition.getUsageType() == 0;
            }
            return true;
        }
    };

    public static IShareable getSharable(IProject project) {
        if (project == null) {
            return null;
        }
        return (IShareable)project.getAdapter(IShareable.class);
    }

    public static IShareable getSharable(IResource resource) {
        if (resource == null) {
            return null;
        }
        return (IShareable)resource.getAdapter(IShareable.class);
    }

    public static boolean isShared(IProject project) {
        IShareable shareable = EnterpriseProjectMetadataPropertiesComposite.getSharable(project);
        if (shareable == null) {
            return false;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return share != null;
    }

    public EnterpriseProjectMetadataPropertiesComposite(Composite parent, IResource resource) {
        super(parent);
        this.fResource = resource;
        this.fProjectShared = EnterpriseProjectMetadataPropertiesComposite.isShared(this.fResource.getProject());
        this.errorStatus = null;
        this.createContents();
    }

    public static Text createLabelledText(Composite parent, GridData layoutData, String label) {
        return EnterpriseProjectMetadataPropertiesComposite.createLabelledText(parent, layoutData, label, true);
    }

    public static Text createLabelledText(Composite parent, GridData layoutData, String labelText, boolean enabled) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Text text = new Text(parent, 2052);
        if (layoutData != null) {
            text.setLayoutData((Object)layoutData);
        }
        label.setEnabled(enabled);
        text.setEnabled(enabled);
        return text;
    }

    protected void createContents() {
        GridLayout layout = new GridLayout(4, false);
        this.setLayout((Layout)layout);
        this.pageDescription = new Label((Composite)this, 64);
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        gd.horizontalAlignment = 4;
        this.pageDescription.setText(Messages.EnterpriseMemberMetadataPropertiesPage_PAGE_DESCRIPTION);
        gd.widthHint = this.pageDescription.getBounds().width;
        gd.heightHint = this.pageDescription.getBounds().height;
        this.pageDescription.setLayoutData((Object)gd);
        this.pageDescription.setVisible(true);
        gd = new GridData(768);
        gd.verticalIndent = 10;
        this.fSrcLibrary = EnterpriseProjectMetadataPropertiesComposite.createLabelledText((Composite)this, gd, Messages.ProjectMetadataPropertiesPage_SOURCE_LIB);
        this.fSrcLibrary.setEditable(false);
        this.browseSrcLibButton = new Button((Composite)this, 0);
        this.browseSrcLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ISystemDefinition resourceDef;
                    ResourceDefinitionSelectionDialog dialog;
                    if (EnterpriseProjectMetadataPropertiesComposite.this.fProjectShared && (dialog = new ResourceDefinitionSelectionDialog(EnterpriseProjectMetadataPropertiesComposite.this.getShell(), EnterpriseProjectMetadataPropertiesComposite.this.fTeamRepository, null, EnterpriseProjectMetadataPropertiesComposite.this.filter)).open() == 0 && (resourceDef = dialog.getSelectedSystemDefinition()) != null) {
                        EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibUUID = resourceDef.getItemId().getUuidValue();
                        EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.setText(resourceDef.getName());
                        EnterpriseProjectMetadataPropertiesComposite.this.clearSrcLibButton.setEnabled(true);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        });
        this.browseSrcLibButton.setText(Messages.BUILDi_SELECTION_BUTTON_LABEL);
        if (!this.fProjectShared) {
            this.errorStatus = new Status(1, TeamiBuildUIPlugin.PLUGIN_ID, Messages.BUILDi_MEMBER_WIZARD_PROJECT_NOT_SHARED_WARNING);
            this.browseSrcLibButton.setEnabled(false);
        }
        this.clearSrcLibButton = new Button((Composite)this, 0);
        this.clearSrcLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibUUID = null;
                EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.setText("");
                EnterpriseProjectMetadataPropertiesComposite.this.updateSourceLibrary(false, new String());
            }
        });
        this.clearSrcLibButton.setText(Messages.BUILDi_CLEAR_BUTTON_LABEL);
        this.fObjLibrary = EnterpriseProjectMetadataPropertiesComposite.createLabelledText((Composite)this, new GridData(768), Messages.ProjectMetadataPropertiesPage_OBJECT_LIB);
        this.fObjLibrary.setEditable(false);
        this.browseObjLibButton = new Button((Composite)this, 0);
        this.browseObjLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ISystemDefinition resourceDef;
                    ResourceDefinitionSelectionDialog dialog;
                    if (EnterpriseProjectMetadataPropertiesComposite.this.fProjectShared && (dialog = new ResourceDefinitionSelectionDialog(EnterpriseProjectMetadataPropertiesComposite.this.getShell(), EnterpriseProjectMetadataPropertiesComposite.this.fTeamRepository, null)).open() == 0 && (resourceDef = dialog.getSelectedSystemDefinition()) != null) {
                        EnterpriseProjectMetadataPropertiesComposite.this.fObjLibUUID = resourceDef.getItemId().getUuidValue();
                        EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.setText(resourceDef.getName());
                        EnterpriseProjectMetadataPropertiesComposite.this.clearObjLibButton.setEnabled(true);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        });
        this.browseObjLibButton.setText(Messages.BUILDi_SELECTION_BUTTON_LABEL);
        if (!this.fProjectShared) {
            this.errorStatus = new Status(1, TeamiBuildUIPlugin.PLUGIN_ID, Messages.BUILDi_MEMBER_WIZARD_PROJECT_NOT_SHARED_WARNING);
            this.browseObjLibButton.setEnabled(false);
        }
        this.clearObjLibButton = new Button((Composite)this, 0);
        this.clearObjLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseProjectMetadataPropertiesComposite.this.fObjLibUUID = null;
                EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.setText("");
                EnterpriseProjectMetadataPropertiesComposite.this.updateObjectLibrary(false, new String());
            }
        });
        this.clearObjLibButton.setText(Messages.BUILDi_CLEAR_BUTTON_LABEL);
    }

    public void initialize(IMetadata metadata) {
        this.fShareable = (IShareable)this.fResource.getProject().getAdapter(IShareable.class);
        this.fTeamRepository = Utils.getTeamRepository((IShareable)this.fShareable);
        String srcLibUUID = metadata == null ? "" : metadata.getProperty("team.enterprise.source.library");
        String objLibUUID = metadata == null ? "" : metadata.getProperty("team.enterprise.object.library");
        boolean srcLibHasUUID = srcLibUUID != null && srcLibUUID.length() > 0;
        boolean objLibHasUUID = objLibUUID != null && objLibUUID.length() > 0;
        this.updateSourceLibrary(srcLibHasUUID, srcLibUUID);
        this.updateObjectLibrary(objLibHasUUID, objLibUUID);
    }

    private void updateSourceLibrary(boolean hasUUID, String currentUUID) {
        if (this.fTeamRepository == null) {
            this.errorStatus = new Status(1, TeamiBuildUIPlugin.PLUGIN_ID, Messages.BUILDi_MEMBER_WIZARD_PROJECT_NOT_SHARED_WARNING);
        } else {
            if (!hasUUID) {
                this.resolveSrcExtensions = new ResolveResourceDefExtensionsJob(hasUUID, currentUUID, 1);
                this.clearSrcLibButton.setEnabled(false);
                this.browseSrcLibButton.setEnabled(false);
                this.resolveSrcExtensions.schedule();
                return;
            }
            this.clearSrcLibButton.setEnabled(true);
            if (hasUUID) {
                this.fSrcLibUUID = currentUUID;
                this.fSrcLibrary.setText(Messages.FolderMetadataPropertiesPage_PENDING);
                ResourceDefinitionLabelHelper labelHelper = this.getLabelHelper();
                ISystemDefinitionContext context = this.getResourceDefinitionContext(currentUUID);
                labelHelper.getResourceDefinitionLabelInBackground(context);
            }
        }
    }

    private void updateObjectLibrary(boolean hasUUID, String currentUUID) {
        if (this.fTeamRepository == null) {
            this.errorStatus = new Status(1, TeamiBuildUIPlugin.PLUGIN_ID, Messages.BUILDi_MEMBER_WIZARD_PROJECT_NOT_SHARED_WARNING);
        } else {
            if (!hasUUID) {
                this.resolveObjExtensions = new ResolveResourceDefExtensionsJob(hasUUID, currentUUID, 0);
                this.clearObjLibButton.setEnabled(false);
                this.browseObjLibButton.setEnabled(false);
                this.resolveObjExtensions.schedule();
                return;
            }
            this.clearObjLibButton.setEnabled(true);
            if (hasUUID) {
                this.fObjLibUUID = currentUUID;
                this.fObjLibrary.setText(Messages.FolderMetadataPropertiesPage_PENDING);
                ResourceDefinitionLabelHelper labelHelper = this.getLabelHelper();
                ISystemDefinitionContext context = this.getResourceDefinitionContext(currentUUID);
                labelHelper.getResourceDefinitionLabelInBackground(context);
            }
        }
    }

    private void setExtensionMap(Map<String, IIBMiResourceDefinition> newMap) {
        this.extensionMap = newMap;
    }

    protected ResourceDefinitionLabelHelper getLabelHelper() {
        return new ResourceDefinitionLabelHelper(){

            public void labelAvailable(String label, String resourceDefUUID) {
                if (resourceDefUUID.equals(EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibUUID) && !EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.isDisposed() && !EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.getText().equals(label)) {
                    EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.setText(label);
                }
                if (resourceDefUUID.equals(EnterpriseProjectMetadataPropertiesComposite.this.fObjLibUUID) && !EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.isDisposed() && !EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.getText().equals(label)) {
                    EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.setText(label);
                }
            }
        };
    }

    protected ISystemDefinitionContext getResourceDefinitionContext(final String resourceDefUUID) {
        return new ISystemDefinitionContext(){

            public String getSystemDefinitionUUID() {
                return resourceDefUUID;
            }

            public ITeamRepository getTeamRepository() {
                return EnterpriseProjectMetadataPropertiesComposite.this.fTeamRepository;
            }

            public IProjectAreaHandle getProjectArea() {
                return null;
            }
        };
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fSrcLibUUID != null) {
            props.put("team.enterprise.source.library", this.fSrcLibUUID);
        } else {
            props.put("team.enterprise.source.library", "");
        }
        if (this.fObjLibUUID != null) {
            props.put("team.enterprise.object.library", this.fObjLibUUID);
        } else {
            props.put("team.enterprise.object.library", "");
        }
        return props;
    }

    public IStatus getErrorStatus() {
        return this.errorStatus;
    }

    class ResolveResourceDefExtensionsJob
    extends TeamBuildJob {
        private boolean hasUUID;
        private String currentUUID;
        private int library;

        ResolveResourceDefExtensionsJob(boolean hasUUID, String currentUUID, int library) {
            super(Messages.ResolveResourceDefinitionJob_JOB_LABEL, false);
            this.hasUUID = hasUUID;
            this.currentUUID = currentUUID;
            this.library = library;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            EnterpriseProjectMetadataPropertiesComposite.this.setExtensionMap(EnterpriseProjectMetadataPropertiesComposite.this.extensionMap);
            if (EnterpriseProjectMetadataPropertiesComposite.this.extensionMap != null && !EnterpriseProjectMetadataPropertiesComposite.this.extensionMap.isEmpty()) {
                String fileExtension = EnterpriseProjectMetadataPropertiesComposite.this.fResource.getFileExtension();
                IIBMiResourceDefinition resourceValue = null;
                if (fileExtension != null && !fileExtension.trim().equals("")) {
                    resourceValue = (IIBMiResourceDefinition)EnterpriseProjectMetadataPropertiesComposite.this.extensionMap.get(fileExtension.toUpperCase());
                }
                if (resourceValue != null) {
                    String resourceValueText = resourceValue.getUuid();
                    boolean bl = this.hasUUID = resourceValueText != null && resourceValueText.length() > 0;
                    if (this.hasUUID) {
                        this.currentUUID = resourceValueText;
                    }
                }
            }
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResolveResourceDefExtensionsJob.this.library == 1) {
                        EnterpriseProjectMetadataPropertiesComposite.this.browseSrcLibButton.setEnabled(true);
                        EnterpriseProjectMetadataPropertiesComposite.this.clearSrcLibButton.setEnabled(true);
                        if (ResolveResourceDefExtensionsJob.this.hasUUID) {
                            ((ResolveResourceDefExtensionsJob)ResolveResourceDefExtensionsJob.this).EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibrary.setText(Messages.FolderMetadataPropertiesPage_PENDING);
                            ((ResolveResourceDefExtensionsJob)ResolveResourceDefExtensionsJob.this).EnterpriseProjectMetadataPropertiesComposite.this.fSrcLibUUID = ResolveResourceDefExtensionsJob.this.currentUUID;
                        }
                    } else if (ResolveResourceDefExtensionsJob.this.library == 0) {
                        EnterpriseProjectMetadataPropertiesComposite.this.browseObjLibButton.setEnabled(true);
                        EnterpriseProjectMetadataPropertiesComposite.this.clearObjLibButton.setEnabled(true);
                        if (ResolveResourceDefExtensionsJob.this.hasUUID) {
                            ((ResolveResourceDefExtensionsJob)ResolveResourceDefExtensionsJob.this).EnterpriseProjectMetadataPropertiesComposite.this.fObjLibrary.setText(Messages.FolderMetadataPropertiesPage_PENDING);
                            ((ResolveResourceDefExtensionsJob)ResolveResourceDefExtensionsJob.this).EnterpriseProjectMetadataPropertiesComposite.this.fObjLibUUID = ResolveResourceDefExtensionsJob.this.currentUUID;
                        }
                    }
                }
            });
        }
    }
}

