/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.build.ui.wizard;

import com.ibm.team.enterprise.ibmi.build.ui.wizard.Messages;
import com.ibm.team.enterprise.ibmi.build.ui.wizard.NewLinkFileWizardFirstPage;
import com.ibm.team.enterprise.ibmi.build.ui.wizard.RecreateLinkFileWizard;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;

public class RecreateLinkFileWizardFirstPage
extends NewLinkFileWizardFirstPage {
    public RecreateLinkFileWizardFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.loadSettings();
        this.password.setFocus();
        this.setErrorMessage(null);
    }

    protected void loadSettings() {
        IResource sel = ((RecreateLinkFileWizard)this.getWizard()).getResourceFromSelection();
        if (sel instanceof IFile) {
            try {
                InputStream contents = ((IFile)sel).getContents();
                BufferedReader reader = new BufferedReader(new InputStreamReader(contents));
                String line = null;
                String header = "";
                while ((line = reader.readLine()) != null && line.indexOf("_header_end_") < 0) {
                    header = String.valueOf(header) + line + "\n";
                }
                this.setHostName(this.getLinkPropertyValue("HOST_NAME=", header));
                this.setUserId(this.getLinkPropertyValue("USER_ID=", header));
                this.setTemporaryLibraryName(this.getLinkPropertyValue("TEMP_LIBRARY=", header));
                this.setLibraryName(this.getLinkPropertyValue("OBJECT_LIBRARY=", header));
                this.setObjectName(this.getLinkPropertyValue("OBJECT_NAME=", header));
                String type = this.getLinkPropertyValue("OBJECT_TYPE=", header);
                if (type.equals(NewLinkFileWizardFirstPage.TYPE.SRVPGM.toString())) {
                    this.setType(NewLinkFileWizardFirstPage.TYPE.SRVPGM);
                } else if (type.equals(NewLinkFileWizardFirstPage.TYPE.PGM.toString())) {
                    this.setType(NewLinkFileWizardFirstPage.TYPE.PGM);
                }
                contents.close();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getLinkPropertyValue(String property, String source) {
        int strIndex = source.indexOf(property);
        if (strIndex >= 0) {
            int endIndex = source.indexOf("\n", strIndex + property.length());
            if (strIndex + property.length() < endIndex) {
                return source.substring(strIndex + property.length(), endIndex);
            }
            this.setMessage(Messages.RecreateLinkFileWizardFirstPage_WarningValueNotLoaded, 2);
            return "";
        }
        this.setMessage(Messages.RecreateLinkFileWizardFirstPage_WarningValueNotLoaded, 2);
        return "";
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.wizard_recreateLinkFile";
    }
}

