/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.build.ui.wizard;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.IFSFile;
import com.ibm.team.internal.enterprise.ibmi.build.ui.nls.Messages;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.io.IOException;
import java.net.UnknownHostException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewLinkFileWizardFirstPage
extends WizardPage {
    protected Text hostName;
    protected Text userId;
    protected Text password;
    protected Text libraryName;
    protected Text objectName;
    protected Text tempLibrary;
    protected Button pgmButton;
    protected Button srvpgmButton;
    protected TYPE type;

    public NewLinkFileWizardFirstPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite subGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        subGroup.setLayout((Layout)layout);
        subGroup.setLayoutData((Object)new GridData(768));
        this.createSystemInfoGroup(subGroup);
        this.createObjectInfoGroup(subGroup);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testSettings() {
        if (!this.validate(false)) return false;
        try {
            AS400 connection = new AS400(this.getHostName(), this.getUserId(), this.getPassword());
            try {
                connection.validateSignon();
            }
            catch (AS400SecurityException e) {
                this.setErrorMessage(Messages.NewLinkFileWizardFirstPage_ErrorInvalidCredentials);
                return false;
            }
            catch (UnknownHostException e) {
                this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorUnknownHost, (Object)this.getHostName()));
                return false;
            }
            String type = this.getType() == TYPE.PGM ? ".PGM" : ".SRVPGM";
            IFSFile ifsFile = new IFSFile(connection, "/QSYS.LIB", String.valueOf(this.getTemporaryLibraryName()) + ".LIB");
            if (!ifsFile.exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorTempLibraryNotFound, (Object)this.getTemporaryLibraryName()));
                return false;
            }
            ifsFile = new IFSFile(connection, "/QSYS.LIB", String.valueOf(this.getLibraryName()) + ".LIB");
            if (!ifsFile.exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorLibraryNotFound, (Object)this.getLibraryName()));
                return false;
            }
            ifsFile = new IFSFile(connection, "/QSYS.LIB/" + this.getLibraryName() + ".LIB", String.valueOf(this.getObjectName()) + type);
            if (ifsFile.exists()) {
                this.setMessage(null);
                return true;
            }
            if (this.getType() == TYPE.PGM) {
                this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorPGMNotFound, (Object)this.getObjectName()));
                return false;
            }
            this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorSRVPGMNotFound, (Object)this.getObjectName()));
            return false;
        }
        catch (IOException e) {
            if (e instanceof ExtendedIOException && e.getMessage().toUpperCase().contains(this.getTemporaryLibraryName().toUpperCase())) {
                this.setErrorMessage(NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ErrorTempLibUnwritable, (Object)this.getTemporaryLibraryName()));
                return false;
            }
            e.printStackTrace();
            this.setErrorMessage(String.valueOf(Messages.NewLinkFileWizardFirstPage_ErrorUnknown) + e.getMessage());
            return false;
        }
    }

    private final void createSystemInfoGroup(Composite subGroup) {
        Group typeGroup = new Group(subGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        typeGroup.setLayout((Layout)layout);
        typeGroup.setText(Messages.NewLinkFileWizardFirstPage_ConnectionGroupTitle);
        typeGroup.setLayoutData((Object)new GridData(768));
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_HostName);
        this.hostName = new Text((Composite)typeGroup, 2052);
        this.hostName.setLayoutData((Object)new GridData(768));
        this.hostName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_UserID);
        this.userId = new Text((Composite)typeGroup, 2052);
        this.userId.setLayoutData((Object)new GridData(768));
        this.userId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_Password);
        this.password = new Text((Composite)typeGroup, 0x400804);
        this.password.setLayoutData((Object)new GridData(768));
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
    }

    private final void createObjectInfoGroup(Composite subGroup) {
        Group typeGroup = new Group(subGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        typeGroup.setLayout((Layout)layout);
        typeGroup.setText(Messages.NewLinkFileWizardFirstPage_ObjectGroupTitle);
        typeGroup.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(768);
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_TemporaryLibraryName);
        this.tempLibrary = new Text((Composite)typeGroup, 2052);
        this.tempLibrary.setLayoutData((Object)gridData);
        this.tempLibrary.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_LibraryName);
        this.libraryName = new Text((Composite)typeGroup, 2052);
        gridData.horizontalSpan = 2;
        this.libraryName.setLayoutData((Object)gridData);
        this.libraryName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_ObjectName);
        this.objectName = new Text((Composite)typeGroup, 2052);
        this.objectName.setLayoutData((Object)gridData);
        this.objectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
            }
        });
        new Label((Composite)typeGroup, 0).setText(Messages.NewLinkFileWizardFirstPage_ObjectType);
        this.pgmButton = new Button((Composite)typeGroup, 16);
        this.pgmButton.setText("*PGM");
        this.pgmButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
                NewLinkFileWizardFirstPage.this.type = TYPE.PGM;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.srvpgmButton = new Button((Composite)typeGroup, 16);
        this.srvpgmButton.setText("*SRVPGM");
        this.srvpgmButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewLinkFileWizardFirstPage.this.validate(false);
                NewLinkFileWizardFirstPage.this.type = TYPE.SRVPGM;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean validate(boolean suppressErrorMessage) {
        String errorMessage = null;
        if (!this.libraryName.getText().equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.libraryName.getText().trim())) {
            errorMessage = NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ERROR_LIB_NAME_CONFORMANCE, (Object)this.libraryName.getText().trim());
        } else if (!this.tempLibrary.getText().equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.tempLibrary.getText().trim())) {
            errorMessage = NLS.bind((String)Messages.NewLinkFileWizardFirstPage_ERROR_LIB_NAME_CONFORMANCE, (Object)this.tempLibrary.getText().trim());
        } else if (this.hostName.getText().equals("") || this.userId.getText().equals("") || this.password.getText().equals("") || this.libraryName.getText().equals("") || this.objectName.getText().equals("")) {
            errorMessage = Messages.NewLinkFileWizardFirstPage_ErrorAllFieldsRequired;
        } else if (!this.pgmButton.getSelection() && !this.srvpgmButton.getSelection()) {
            errorMessage = Messages.NewLinkFileWizardFirstPage_ErrorObjectTypeRequired;
        }
        if (errorMessage != null || suppressErrorMessage) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(errorMessage == null);
        return errorMessage == null;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.wizard_newLinkFile";
    }

    public String getHostName() {
        return this.hostName.getText().trim();
    }

    public String getUserId() {
        return this.userId.getText().toUpperCase().trim();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public String getLibraryName() {
        return this.libraryName.getText().toUpperCase().trim();
    }

    public String getTemporaryLibraryName() {
        return this.tempLibrary.getText().toUpperCase().trim();
    }

    public String getObjectName() {
        return this.objectName.getText().toUpperCase().trim();
    }

    public TYPE getType() {
        return this.type;
    }

    protected void setHostName(String name) {
        this.hostName.setText(name.trim());
    }

    protected void setUserId(String id) {
        this.userId.setText(id.toUpperCase().trim());
    }

    protected void setLibraryName(String name) {
        this.libraryName.setText(name.toUpperCase().trim());
    }

    protected void setTemporaryLibraryName(String name) {
        this.tempLibrary.setText(name.toUpperCase().trim());
    }

    protected void setObjectName(String name) {
        this.objectName.setText(name.toUpperCase().trim());
    }

    protected void setType(TYPE type) {
        this.type = type;
        if (type == TYPE.PGM) {
            this.pgmButton.setSelection(true);
        } else if (type == TYPE.SRVPGM) {
            this.srvpgmButton.setSelection(true);
        }
    }

    protected static enum TYPE {
        PGM,
        SRVPGM;

    }
}

